package com.bokesoft.yigo.meta.setting;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map.Entry;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.MetaRightsProxyCollection;

public class MetaSetting extends AbstractMetaObject {
	/** 附件服务配置 */
	private MetaAttachmentService attachmentService = null;
	/** 数据传输配置 */
	private MetaDTS dts = null;
	/** hbae配置 */
	private MetaIOService IOService = null;
	/** 会话超时设置 */
	private MetaSession session = null;
	/** 数据簇对象 */
	private MetaCluster cluster = null;
	/** 入口 */
	private MetaEntrySetting entry = null;
	/** 当前解决方案是单机版还是分布式 */
	private Boolean dbCluster = false;
	/** 是否启用消息机制*/
	private Boolean messageEnabled = false;
	/** 业务流程运行设置 */
	private MetaBPMSetting BPMSetting = null;
	/** 登录界面设置 */
	private MetaLoginSetting login = null;
	/** 表单设置*/
	private MetaFormSetting formSetting = null;
	/** 迁移的运行设置 */
	private MetaMigrationSetting migrationSetting = null;
	/** 简单属性集合 */
	private HashMap<String, MetaSimpleSetting> simpleSettings = null;
	/** 认证程序集合 */
	private MetaAuthServices authServices = null;
	/** 权限代理*/
	private MetaRightsProxyCollection rightsProxyCollection = null;
	/** 系统主题设置*/
	private MetaSystemTopics systemTopics = null;
	
	/** 喜好数据的存放的根路径*/
	private String preferencePath = "";
	

	public MetaSetting() {
		super();
		simpleSettings = new HashMap<String, MetaSimpleSetting>();
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(attachmentService);
		list.add(dts);
		list.add(IOService);
		list.add(session);
		list.add(cluster);
		list.add(entry);
		list.add(BPMSetting);
		list.add(login);
		list.add(formSetting);
		list.add(migrationSetting);
		list.add(rightsProxyCollection);
		Iterator<Entry<String, MetaSimpleSetting>> it = simpleSettings.entrySet().iterator();
		Entry<String, MetaSimpleSetting> entry = null;
		while ( it.hasNext() ) {
			entry = it.next();
			MetaSimpleSetting simpleSetting = entry.getValue();
			list.add(simpleSetting);
		}
		list.add(authServices);
		list.add(systemTopics);
	}

	/**
	 * 设置附件服务配置
	 * 
	 * @param attachmentService
	 *            附件服务配置
	 */
	public void setAttachmentService(MetaAttachmentService attachmentService) {
		this.attachmentService = attachmentService;
	}

	/**
	 * 取得附件服务配置
	 * 
	 * @return 附件服务配置
	 */
	public MetaAttachmentService getAttachmentService() {
		return this.attachmentService;
	}
	
	public MetaDTS getDts() {
		return dts;
	}

	public void setDts(MetaDTS dts) {
		this.dts = dts;
	}
	
	public MetaIOService getIOService() {
		return IOService;
	}

	public void setIOService(MetaIOService iOService) {
		IOService = iOService;
	}

	/**
	 * 设置会话
	 * 
	 * @param session
	 *            会话
	 */
	public void setSession(MetaSession session) {
		this.session = session;
	}

	/**
	 * 取得会话
	 * 
	 * @return 会话
	 */
	public MetaSession getSession() {
		return this.session;
	}

	/**
	 * 设置数据簇对象
	 * 
	 * @param cluster
	 *            数据簇对象
	 */
	public void setCluster(MetaCluster cluster) {
		this.cluster = cluster;
	}

	/**
	 * 取得数据簇对象
	 * 
	 * @return 数据簇对象
	 */
	public MetaCluster getCluster() {
		return this.cluster;
	}

	/**
	 * 设置入口设置
	 * 
	 * @param entry
	 *            入口设置
	 */
	public void setEntry(MetaEntrySetting entry) {
		this.entry = entry;
	}

	/**
	 * 取得入口设置
	 * 
	 * @return 入口设置
	 */
	public MetaEntrySetting getEntry() {
		return this.entry;
	}
	
	/**
	 * 获取表单全局设置
	 * @return
	 */
	public MetaFormSetting getFormSetting() {
		return formSetting;
	}

	/**
	 * 设置表单全局设置
	 * @param formSetting
	 */
	public void setFormSetting(MetaFormSetting formSetting) {
		this.formSetting = formSetting;
	}

	public Boolean isDbCluster() {
		return dbCluster;
	}

	public void setDbCluster(Boolean dbCluster) {
		this.dbCluster = dbCluster;
	}
	
	public Boolean isMessageEnabled() {
		return messageEnabled;
	}

	public void setMessageEnabled(Boolean messageEnabled) {
		this.messageEnabled = messageEnabled;
	}

	public MetaBPMSetting getBPMSetting() {
		return BPMSetting;
	}

	public void setBPMSetting(MetaBPMSetting bPMSetting) {
		BPMSetting = bPMSetting;
	}
	
	/**
	 * 设置登录界面属性
	 * @param login 登录界面属性
	 */
	public void setLogin(MetaLoginSetting login) {
		this.login = login;
	}
	
	/**
	 * 取得登录界面属性
	 * @return 登录界面属性
	 */
	public MetaLoginSetting getLogin() {
		return this.login;
	}

	public MetaMigrationSetting getMigrationSetting() {
		return migrationSetting;
	}

	public void setMigrationSetting(MetaMigrationSetting migrationSetting) {
		this.migrationSetting = migrationSetting;
	}
	
	public MetaRightsProxyCollection getRightsProxyCollection() {
		return rightsProxyCollection;
	}

	public void setRightsProxyCollection(MetaRightsProxyCollection rightsProxyCollection) {
		this.rightsProxyCollection = rightsProxyCollection;
	}
	
	
	

	/**
	 * @return the preferencePath
	 */
	public String getPreferencePath() {
		return preferencePath;
	}

	/**
	 * @param preferencePath the preferencePath to set
	 */
	public void setPreferencePath(String preferencePath) {
		this.preferencePath = preferencePath;
	}

	/**
	 * 根据标识取得简单配置对象
	 * @param key 标识
	 * @return 如果key对象的简单配置对象存在则返回，否则返回null
	 */
	public MetaSimpleSetting getSimpleSetting(String key) {
		return this.simpleSettings.get(key);
	}
	
	public HashMap<String, MetaSimpleSetting> getSimpleSettings() {
		return simpleSettings;
	}
	
	/**
	 * 设置认证程序集合
	 * @param authServices 认证程序集合
	 */
	public void setAuthServices(MetaAuthServices authServices) {
		this.authServices = authServices;
	}
	
	/**
	 * 取得认证程序集合
	 * @return 认证程序集合
	 */
	public MetaAuthServices getAuthServices() {
		return this.authServices;
	}
	
	public MetaSystemTopics getSystemTopics(){
		return systemTopics;
	}
	
	public void setSystemTopics(MetaSystemTopics systemTopics){
		this.systemTopics = systemTopics;
	}

	public static final String TAG_NAME = "Setting";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaAttachmentService.TAG_NAME.equals(tagName)) {
			attachmentService = new MetaAttachmentService();
			resultMetaObject = attachmentService;
		}else if (MetaDTS.TAG_NAME.equals(tagName)) {
			dts = new MetaDTS();
			resultMetaObject = dts;
		}else if (MetaIOService.TAG_NAME.equals(tagName)) {
			IOService = new MetaIOService();
			resultMetaObject = IOService;
		}else if (MetaSession.TAG_NAME.equals(tagName)) {
			session = new MetaSession();
			resultMetaObject = session;
		} else if (MetaCluster.TAG_NAME.equals(tagName)) {
			cluster = new MetaCluster();
			resultMetaObject = cluster;
		} else if (MetaEntrySetting.TAG_NAME.equals(tagName)) {
			this.entry = new MetaEntrySetting();
			resultMetaObject = entry;
		} else if (MetaBPMSetting.TAG_NAME.equals(tagName)) {
			this.BPMSetting = new MetaBPMSetting();
			resultMetaObject = BPMSetting;
		} else if ( MetaLoginSetting.TAG_NAME.equals(tagName) ) {
			this.login = new MetaLoginSetting();
			resultMetaObject = login;
		} else if ( MetaFormSetting.TAG_NAME.equals(tagName) ) {
			this.formSetting = new MetaFormSetting();
			resultMetaObject = formSetting;
		} else if ( MetaMigrationSetting.TAG_NAME.equals(tagName) ) {
			this.migrationSetting = new MetaMigrationSetting();
			resultMetaObject = migrationSetting;
		} else if ( MetaAuthServices.TAG_NAME.equals(tagName) ) {
			this.authServices = new MetaAuthServices();
			resultMetaObject = this.authServices;
		} else if ( MetaSystemTopics.TAG_NAME.equals(tagName) ) {
			this.systemTopics = new MetaSystemTopics();
			resultMetaObject = this.systemTopics;
		}else if ( MetaRightsProxyCollection.TAG_NAME.equals(tagName) ) {
			this.rightsProxyCollection = new MetaRightsProxyCollection();
			resultMetaObject = this.rightsProxyCollection;
		} else {
			MetaSimpleSetting simpleSetting = new MetaSimpleSetting(tagName);
			this.simpleSettings.put(tagName, simpleSetting);
			resultMetaObject = simpleSetting;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return null;
	}

}
