package com.bokesoft.yigo.meta.report;

/**
 * ReportFormatDataType定义报表单元格的数据格式类型
 * @author wangyh
 *
 */
public class ReportFormatDataType {
	/** 文本 */
	public static final int Text = 0;
	/** 文本字符串表示 */
	public static final String STR_Text = "Text";
	
	/** 字典 */
	public static final int Dict = 1;
	/** 字典字符串表示 */
	public static final String STR_Dict = "Dict";
	
	/** 数值 */
	public static final int Number = 2;
	/** 数值字符串表示 */
	public static final String STR_Number = "Number";
	
	/** 列表 */
	public static final int List = 3;
	/** 列表字符串表示 */
	public static final String STR_List = "List";
	
	/** 多选列表 */
	public static final int MultiList = 4;
	/** 多选列表字符串表示 */
	public static final String STR_MultiList = "MultiList";
	
	/** 金额 */
	public static final int Money = 5;
	/** 金额字符串表示 */
	public static final String STR_Money = "Money";
	
	/** 日期 */
	public static final int Date = 6;
	/** 日期字符串表示 */
	public static final String STR_Date = "Date";
	
	/** 多选字典 */
	public static final int MultiDict = 7;
	/** 多选字典字符串表示 */
	public static final String STR_MultiDict = "MultiDict";
	
	/**
	 * 从字符串解析类型
	 * @param s 字符串
	 * @return 如果s在取值范围内，返回相应的类型，否则返回-1
	 */
	public static int parse(String s) {
		int type = -1;
		if ( STR_Text.equalsIgnoreCase(s) ) {
			type = Text;
		} else if ( STR_Dict.equalsIgnoreCase(s) ) {
			type = Dict;
		} else if ( STR_Number.equalsIgnoreCase(s) ) {
			type = Number;
		} else if ( STR_List.equalsIgnoreCase(s) ) {
			type = List;
		} else if ( STR_MultiList.equalsIgnoreCase(s) ) {
			type = MultiList;
		} else if ( STR_Money.equalsIgnoreCase(s) ) {
			type = Money;
		} else if ( STR_Date.equalsIgnoreCase(s) ) {
			type = Date;
		} else if ( STR_MultiDict.equalsIgnoreCase(s) ) {
			type = MultiDict;
		}
		return type;
	}
	
	/**
	 * 从类型格式化字符串
	 * @param type 类型
	 * @return 如果type在取值范围内，返回相应的字符串表示，否则返回空字符串
	 */
	public static String toString(Integer type) {
		if(type == null)
			return "";
		
		String s = "";
		switch ( type ) {
		case Text:
			s = STR_Text;
			break;
		case Dict:
			s = STR_Dict;
			break;
		case Number:
			s = STR_Number;
			break;
		case List:
			s = STR_List;
			break;
		case MultiList:
			s = STR_MultiList;
			break;
		case Money:
			s = STR_Money;
			break;
		case Date:
			s = STR_Date;
			break;
		case MultiDict:
			s = STR_MultiDict;
			break;
		}
		return s;
	}
}
