package com.bokesoft.yigo.meta.report;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaReportDataField extends KeyPairMetaObject {
	public static final String TAG_NAME = "Field";

	/** 域的标识 */
	private String key = "";
	/** 域的名称 */
	private String caption = "";
	/** 数据库的域标识 */
	private String dbFieldKey = "";
	/** 字段描述 */
	private String description = "";

	@Override
	public String getKey() {
		return key;
	}
	
	/**
	 * 设置域的标识
	 * @param key 域的标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 设置域的名称
	 * @param caption 域的名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得域的名称
	 * @return 域的名称
	 */
	public String getCaption() {
		return this.caption;
	}
	
	/**
	 * 设置数据库的域标识
	 * @param dbFieldKey 数据库的域标识
	 */
	public void setDBFieldKey(String dbFieldKey) {
		this.dbFieldKey = dbFieldKey;
	}
	
	/**
	 * 取得数据库的域标识
	 * @return 数据库的域标识
	 */
	public String getDBFieldKey() {
		return this.dbFieldKey;
	}
	
	/**
	 * 设置字段描述
	 * @param description 字段描述
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * 取得字段描述
	 * @return 字段描述
	 */
	public String getDescription() {
		return this.description;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		MetaReportDataField newField = new MetaReportDataField();
		newField.setKey(key);
		newField.setCaption(caption);
		newField.setDBFieldKey(dbFieldKey);
		newField.setDescription(description);
		return newField;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return new MetaReportDataField();
	}

}
