package com.bokesoft.yigo.meta.permission.custom;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map.Entry;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaGroup extends GenericKeyCollectionWithKey<MetaOperation> {
	public static final String TAG_NAME = "Group";
	/** 组标识*/
	private String key ="";
	/** 组名称*/
	private String caption = "";

	public String getCaption() {
		return caption;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public String getKey() {
		return key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		Iterator<Entry<String, MetaOperation>> it = this.entryIterator();
		Entry<String, MetaOperation> ent = null;
		while (it.hasNext()) {
			ent = it.next();
			//String opkey = ent.getKey();  // operationKey
			MetaOperation op = ent.getValue(); // MetaOperation
			//String ocap = op.getCaption();
			list.add(op);
		}
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject child = null;
		if (MetaOperation.TAG_NAME.equals(tagName)) {
			MetaOperation op = new MetaOperation();
			op.preProcessMetaObject(env, doc, node, flag, runType);
			add(op);
			child = op;
		}
		return child;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGroup();
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaGroup newObj = (MetaGroup)super.clone();
		newObj.key = key;
		newObj.caption = caption;
		return newObj;
	}

	@Override
	public String toString() {
		return "MetaGroup [key=" + key + ", caption=" + caption + "]";
	}
	
}
