package com.bokesoft.yigo.meta.paratable;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaParaGroup extends GenericKeyCollectionWithKey<MetaParaItem> implements IPropertyMerger<MetaParaGroup> {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	/** 组标识 */
	private String key = "";
	/** 组名称 */
	private String caption = "";
	
	/** solution的标识----不针对配置对象，用于逻辑处理 */
	private String solution = "";
	/** 是否继承(马甲)----不针对配置对象，用于逻辑处理  */
	private boolean isExtend = false;
	
	public MetaParaGroup() {
		super();
	}
	
	/**
	 * 取得组标识
	 * @return 组标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置组标识
	 * @param key 组标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 设置组名称
	 * @param caption 组名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	public String getSolution() {
		return solution;
	}
	
	public void setSolution(String solution) {
		this.solution = solution;
	}
	
	/**
	 * 取得组名称
	 * @return 组名称
	 */
	public String getCaption() {
		return this.caption;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "ParaGroup";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaParaItem.TAG_NAME.equals(tagName) ) {
			MetaParaItem item = new MetaParaItem();
			item.preProcessMetaObject(env, doc, node, flag,runType);
			this.add(item);
			resultMetaObject = item;
		}

		return resultMetaObject;
	}
	public boolean needPreLoad() {
		return true;
	}
	@Override
	public AbstractMetaObject clone() {
		MetaParaGroup newObject = (MetaParaGroup)super.clone();
		newObject.setKey(key);
		newObject.setCaption(caption);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaParaGroup();
	}

	@Override
	public void merge(MetaParaGroup metaParaItems) {
		if (metaParaItems.getCaption()!=null){
			caption = metaParaItems.getCaption();
		}
		for (MetaParaItem metaParaItem : metaParaItems) {
			if (this.containsKey(metaParaItem.getKey())) {
				this.get(metaParaItem.getKey()).merge(metaParaItem);
			} else {
				this.add(metaParaItem);
			}
		}
	}

	public boolean isExtend() {
		return isExtend;
	}
	
	public void setExtend(boolean isExtend) {
		this.isExtend = isExtend;
	}
}
