package com.bokesoft.yigo.meta.offlinedef;

import java.util.ArrayList;
import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.common.def.OfflineConfigType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaConfigInfoCollection extends GenericNoKeyCollection<MetaConfigInfo> {

	private ArrayList<String> formProjectKeys;

	private ArrayList<String> formKeys;
	
	private ArrayList<String> dataObjectProjectKeys;

	private ArrayList<String> dataObjectKeys;
	
	private ArrayList<MetaConfigInfo> commdefInfo;
	
	private ArrayList<MetaConfigInfo> resourceInfo;

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	public static final String TAG_NAME = "ConfigInfoCollection";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		for (MetaConfigInfo metaConfigInfo : elementArray) {
			
			switch (metaConfigInfo.getType()) {
			case OfflineConfigType.FORM:
				if (metaConfigInfo.getPath() != null && metaConfigInfo.getPath().length() > 0){
					if (formKeys == null) {
						formKeys = new ArrayList<>();
					}
					formKeys.add(metaConfigInfo.getPath());
				}else if (metaConfigInfo.getProject() != null && metaConfigInfo.getProject().length() > 0) {
					if (formProjectKeys == null) {
						formProjectKeys = new ArrayList<>();
					}
					formProjectKeys.add(metaConfigInfo.getProject());
				}
				break;
			case OfflineConfigType.DATAOBJECT:
				if (metaConfigInfo.getPath() != null && metaConfigInfo.getPath().length() > 0){
					if (dataObjectKeys == null) {
						dataObjectKeys = new ArrayList<>();
					}
					dataObjectKeys.add(metaConfigInfo.getPath());
				}else if (metaConfigInfo.getProject() != null && metaConfigInfo.getProject().length() > 0) {
					if (dataObjectProjectKeys == null) {
						dataObjectProjectKeys = new ArrayList<>();
					}
					dataObjectProjectKeys.add(metaConfigInfo.getProject());
				}
				break;
			case OfflineConfigType.COMMONDEF:
				if (commdefInfo == null) {
					commdefInfo = new ArrayList<>();
				}
				commdefInfo.add(metaConfigInfo);
				break;
			case OfflineConfigType.RESOURCE:
				if (resourceInfo == null) {
					resourceInfo = new ArrayList<>();
				}
				resourceInfo.add(metaConfigInfo);
				break;
			default:
				break;
			}
		}
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaConfigInfo.TAG_NAME.equals(tagName)) {
			MetaConfigInfo metaConfigInfo = new MetaConfigInfo();
			metaConfigInfo.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(metaConfigInfo);
			resultMetaObject = metaConfigInfo;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaConfigInfoCollection();
	}

	public ArrayList<String> getProjectFormKeys() {
		return formProjectKeys;
	}

	public ArrayList<String> getFormKeys() {
		return formKeys;
	}

	public ArrayList<String> getDataObjectProjectKeys() {
		return dataObjectProjectKeys;
	}

	public ArrayList<String> getDataObjectKeys() {
		return dataObjectKeys;
	}

	public ArrayList<MetaConfigInfo> getCommdefInfo() {
		return commdefInfo;
	}

	public ArrayList<MetaConfigInfo> getResourceInfo() {
		return resourceInfo;
	}

}
