package com.bokesoft.yigo.meta.form.component.view.layout;

import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 表视图布局配置对象
 * @author chenzs
 *
 */
public class MetaTableViewLayout extends MetaComponentLayout<MetaTableRowLayout>{
	public static final String TAG_NAME = "TableViewLayout";
	
	/** 行集合*/
	private MetaTableRowLayoutCollection rowCollection = null;

	@Override
	public int getLayoutType() {
		return LayoutType.LAYOUT_TABLEVIEW;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	/**
	 * 获取行布局配置对象集合
	 * @return 行布局配置对象集合
	 */
	public MetaTableRowLayoutCollection getRowCollection() {
		return rowCollection;
	}
	
	public void setRowCollection(MetaTableRowLayoutCollection rowCollection) {
		this.rowCollection = rowCollection;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTableViewLayout();
	}
	

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaTableRowLayoutCollection.TAG_NAME.equals(tagName)) {
			rowCollection = new MetaTableRowLayoutCollection();
			rowCollection.preProcessMetaObject(env, doc, node, flag, runType); 
			resultMetaObject = rowCollection;
		}
		return resultMetaObject;
	}
}
