package com.bokesoft.yigo.meta.form.component.view;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.common.def.ScreenOrientation;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaView定义表单的一个表现形式，对表单中的布局，默认值等进行重新定义
 * @author wangyh
 *
 */
public class MetaView extends GenericKeyCollectionWithKey<MetaComponentView> {
	/** 布局的标识 */
	private String key = "";
	/** 布局的名称 */
	private String caption = "";
	/** 布局匹配的媒体 */
	private Integer media = -1;
	/** 屏幕尺寸 */
	private String size = "";
	/** 布局匹配的规则 */
	private String rule = "";
	/** 最低适配的屏幕宽度 */
	private Integer minWidth=320;
	/** 适配的屏幕长宽比 */
	private Integer screenOrientation=ScreenOrientation.unspecified;
	
	public MetaView() {
		super();
	}
	
	@Override
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置布局的标识
	 * @param key 布局的标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 设置布局的名称
	 * @param caption 布局名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得布局的名称
	 * @return 布局的名称
	 */
	public String getCaption() {
		return this.caption;
	}
	
	/**
	 * 设置媒体标识
	 * @param media 媒体标识
	 */
	public void setMedia(Integer media) {
		this.media = media;
	}
	
	/**
	 * 取得媒体标识
	 * @return 媒体标识
	 */
	public Integer getMedia() {
		return this.media;
	}
	
	/**
	 * 设置尺寸
	 * @param size 尺寸
	 */
	public void setSize(String size) {
		this.size = size;
	}
	
	/**
	 * 取得尺寸
	 * @return 尺寸
	 */
	public String getSize() {
		return this.size;
	}
	
	/**
	 * 设置匹配规则
	 * @param rule 匹配规则
	 */
	public void setRule(String rule) {
		this.rule = rule;
	}
	
	/**
	 * 取得匹配规则
	 * @return 匹配规则
	 */
	public String getRule() {
		return this.rule;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "View";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaComponentView.TAG_NAME.equals(tagName) ) {
			MetaComponentView componentView = new MetaComponentView();
			componentView.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(componentView);
			resultMetaObject = componentView;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaView newObject = (MetaView)super.clone();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setMedia(media);
		newObject.setSize(size);
		newObject.setRule(rule);
		newObject.setMinWidth(minWidth);
		newObject.setScreenOrientation(screenOrientation);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaView();
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		for(MetaComponentView componentView : this){
			componentView.doPostProcess(flag, callback);
		}
	}

	public final Integer getMinWidth() {
		return minWidth;
	}

	public final void setMinWidth(Integer minWidth) {
		this.minWidth = minWidth;
	}

	public final Integer getScreenOrientation() {
		return screenOrientation;
	}

	public final void setScreenOrientation(Integer screenOrientation) {
		this.screenOrientation = screenOrientation;
	}

}
