package com.bokesoft.yigo.meta.form.component.html;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

/**
 * HTML元素基本类对象
 * 
 * @author 陈志盛
 * @since YES1.0
 */
public abstract class MetaHtmlElement extends MetaComponent {

	/** 显示文本 */
	private String text = "";

	/** 规定元素的唯一ID */
	private String id = "";

	/** 规定该元素是无关的，被隐藏的元素不会显示 */
	private Boolean hidden = false;

	/** 当按下按键时运行事件 */
	private String onKeyDown = "";

	/** 当松开按键时运行事件 */
	private String onKeyUp = "";

	/** 当按下并松开按键时运行事件 */
	private String onKeyPress = "";

	/** 当单击鼠标时运行事件 */
	private String onClick = "";

	/** 当双击鼠标时运行事件 */
	private String onDblClick = "";

	/** 当按下鼠标按钮时运行事件 */
	private String onMouseDown = "";

	/** 当松开鼠标按钮时运行事件 */
	private String onMouseUp = "";

	/** 当鼠标指针移动时运行事件 */
	private String onMouseMove = "";

	/** 当鼠标指针移出元素时运行事件 */
	private String onMouseOut = "";

	/** 当鼠标指针移至元素之上时运行事件 */
	private String onMouseOver = "";

	/**
	 * 设置规定元素的唯一ID
	 * 
	 * @param id
	 *            规定元素的唯一ID
	 */
	public void setID(String id) {
		this.id = id;
	}

	/**
	 * 获取规定元素的唯一ID
	 * 
	 * @return 规定元素的唯一ID
	 */
	public String getID() {
		return this.id;
	}

	/**
	 * 设置是否隐藏
	 * 
	 * @param hidden
	 *            是否隐藏
	 */
	public void setHidden(Boolean hidden) {
		this.hidden = hidden;
	}

	/**
	 * 获取是否隐藏
	 * 
	 * @return 是否隐藏
	 */
	public Boolean isHidden() {
		return this.hidden;
	}

	/**
	 * 设置按下按键时的事件
	 * 
	 * @param event
	 *            事件
	 */
	public void setKeyDownEvent(String event) {
		this.onKeyDown = event;
	}

	/**
	 * 获取按下按键时的事件
	 * 
	 * @return 事件
	 */
	public String getKeyDownEvent() {
		return this.onKeyDown;
	}

	/**
	 * 设置松开按键时的事件
	 * 
	 * @param event
	 *            事件
	 */
	public void setKeyUpEvent(String event) {
		this.onKeyUp = event;
	}

	/**
	 * 获取松开按键时的事件
	 * 
	 * @return 事件
	 */
	public String getKeyUpEvent() {
		return this.onKeyUp;
	}

	/**
	 * 设置按下按键并松开时的事件
	 * 
	 * @param event
	 *            事件
	 */
	public void setKeyPressEvent(String event) {
		this.onKeyPress = event;
	}

	/**
	 * 获取按下按键并松开时的事件
	 * 
	 * @return 事件
	 */
	public String getKeyPressEvent() {
		return this.onKeyPress;
	}

	/**
	 * 设置鼠标点击时的事件
	 * 
	 * @param event
	 *            事件
	 */
	public void setOnClickEvent(String event) {
		this.onClick = event;
	}

	/**
	 * 获取鼠标点击时的事件
	 * 
	 * @return 事件
	 */
	public String getOnClickEvent() {
		return this.onClick;
	}

	/**
	 * 设置鼠标双击时的事件
	 * 
	 * @param event
	 *            事件
	 */
	public void setOnDblClickEvent(String event) {
		this.onDblClick = event;
	}

	/**
	 * 获取鼠标双击时的事件
	 * 
	 * @return 事件
	 */
	public String getOnDblClickEvent() {
		return this.onDblClick;
	}

	/**
	 * 设置鼠标按钮按下时的事件
	 * 
	 * @param event
	 *            事件
	 */
	public void setOnMouseDownEvent(String event) {
		this.onMouseDown = event;
	}

	/**
	 * 获取鼠标按钮按下时的事件
	 * 
	 * @return 事件
	 */
	public String getOnMouseDownEvent() {
		return this.onMouseDown;
	}

	/**
	 * 设置鼠标按钮松开时的事件
	 * 
	 * @param event 事件
	 */
	public void setOnMouseUpEvent(String event) {
		this.onMouseUp = event;
	}

	/**
	 * 获取鼠标按钮松开时的事件
	 * 
	 * @return 事件
	 */
	public String getOnMouseUpEvent() {
		return this.onMouseUp;
	}

	/**
	 * 设置鼠标指针移出元素时的事件
	 * 
	 * @param event
	 *            事件
	 */
	public void setOnMouseOutEvent(String event) {
		this.onMouseOut = event;
	}

	/**
	 * 获取鼠标指针移出元素时的事件
	 * 
	 * @return 事件
	 */
	public String getOnMouseOutEvent() {
		return this.onMouseOut;
	}

	/**
	 * 设置鼠标指针移至元素之上时的事件
	 * 
	 * @param event
	 *            事件
	 */
	public void setOnMouseOverEvent(String event) {
		this.onMouseOver = event;
	}

	/**
	 * 获取鼠标指针移至元素之上时的事件
	 * 
	 * @return 事件
	 */
	public String getOnMouseOverEvent() {
		return this.onMouseOver;
	}

	/**
	 * 设置鼠标指针移动时的事件
	 * 
	 * @param event
	 *            事件
	 */
	public void setOnMouseMoveEvent(String event) {
		this.onMouseMove = event;
	}

	/**
	 * 获取鼠标指针移动时的事件
	 * 
	 * @return 事件
	 */
	public String getOnMouseMoveEvent() {
		return this.onMouseMove;
	}

	/**
	 * 设置显示文本
	 * 
	 * @param text
	 *            显示文本
	 */
	public void setText(String text) {
		this.text = text;
	}

	/**
	 * 获取显示文本
	 * 
	 * @return 获取显示文本
	 */
	public String getText() {
		return this.text;
	}

	@Override
	public abstract int getControlType();

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public abstract String getTagName();

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		return null;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaHtmlElement newObject = (MetaHtmlElement)super.clone();
		newObject.setText(text);
		newObject.setID(id);
		newObject.setHidden(hidden);
		newObject.setKeyDownEvent(onKeyDown);
		newObject.setKeyUpEvent(onKeyUp);
		newObject.setKeyPressEvent(onKeyPress);
		newObject.setOnClickEvent(onClick);
		newObject.setOnDblClickEvent(onDblClick);
		newObject.setOnMouseDownEvent(onMouseDown);
		newObject.setOnMouseUpEvent(onMouseUp);
		newObject.setOnMouseMoveEvent(onMouseMove);
		newObject.setOnMouseOutEvent(onMouseOut);
		newObject.setOnMouseOverEvent(onMouseOver);

		return newObject;
	}
}
