package com.bokesoft.yigo.meta.form.component.control.wizardlist;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaWizardListProperties;

public class MetaWizardList extends MetaComponent {
	
	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_WIZARDLIST;
	
	private MetaWizardListProperties properties = new MetaWizardListProperties();

	@Override
	public int getControlType() {
		return ControlType.WIZARDLIST;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return properties;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaWizardList();
	}
	
	public MetaWizardItemCollection getItemCollection() {
		return properties.getItemCollection();
	}

	public void setItemCollection(MetaWizardItemCollection itemCollection) {
		properties.setItemCollection(itemCollection);
	}
	
	public MetaWizardItemList getItemList() {
		return properties.getItemList();
	}
	
	public void setItemList(MetaWizardItemList itemList) {
		properties.setItemList(itemList);
	}
	
	public void setPromptText(String promptText) {
		properties.setPromptText(promptText);
	}

	public String getPromptText() {
		return properties.getPromptText();
	}
	
	public void setEditType(Integer editType) {
		properties.setEditType(editType);
	}
	
	public Integer getEditType() {
		return properties.getEditType();
	}
	
	@Override
	public MetaWizardList clone() {
		MetaWizardList newObject = (MetaWizardList) super.clone();
		newObject.setProperties(properties == null ? null : properties.clone());
		return newObject;
	}
	
	@Override
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaWizardListProperties)properties;
	}
}
