package com.bokesoft.yigo.meta.form.component.control.treeview;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

/**
 * MetaTreeView定义树状视图的元数据，包括列的集合，树形结构的数据来源，绑定的数据表的标识以及控件上的事件定义。
 * @author 王元和
 *
 */
public class MetaTreeView extends MetaComponent {
	/** 列集合 */
	private MetaTreeViewColumnCollection columnCollection = null;
	/** 数据源 */
	private MetaTreeViewDataSource dataSource = null;
	/** 树列标识 */
	private String treeColumnKey = "";
	/** 绑定的数据表标识 */
	private String tableKey = "";
	/** 行点击事件 */
	private MetaBaseScript rowClick = null;
	/** 行双击事件 */
	private MetaBaseScript rowDblClick = null;
	
	public MetaTreeView() {
		super();
	}
	
	public static final String TAG_NAME = ControlType.STR_TREEVIEW;
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.TREEVIEW;
	}
	
	@Override
	public boolean receiveFocus() {
		return false;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		addAll(list, new AbstractMetaObject[] { columnCollection, dataSource, rowClick, rowDblClick });
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaTreeViewColumnCollection.TAG_NAME.equals(tagName) ) {
			columnCollection = new MetaTreeViewColumnCollection();
			resultMetaObject = columnCollection;
		} else if ( MetaTreeViewDataSource.TAG_NAME.equals(tagName) ) {
			dataSource = new MetaTreeViewDataSource();
			resultMetaObject = dataSource;
		} else if ( MetaConstants.Event_RowClick.equals(tagName) ) {
			rowClick = new MetaBaseScript(MetaConstants.Event_RowClick);
			resultMetaObject = rowClick;
		} else if ( MetaConstants.Event_RowDblClick.equals(tagName) ) {
			rowDblClick = new MetaBaseScript(MetaConstants.Event_RowDblClick);
			resultMetaObject = rowDblClick;
		}
		if ( resultMetaObject == null ) {
			resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}
		return resultMetaObject;
	}

	/**
	 * 设置列集合
	 * @param columnCollection 列集合
	 */
	public void setColumnCollection(MetaTreeViewColumnCollection columnCollection) {
		this.columnCollection = columnCollection;
	}
	
	/**
	 * 取得列集合
	 * @return 列集合
	 */
	public MetaTreeViewColumnCollection getColumnCollection() {
		return this.columnCollection;
	}
	
	/**
	 * 设置数据源
	 * @param dataSource 数据源
	 */
	public void setDataSource(MetaTreeViewDataSource dataSource) {
		this.dataSource = dataSource;
	}
	
	/**
	 * 取得数据源
	 * @return 数据源
	 */
	public MetaTreeViewDataSource getDataSource() {
		return this.dataSource;
	}
	
	/**
	 * 设置树列标识
	 * @param treeColumnKey 树列标识
	 */
	public void setTreeColumnKey(String treeColumnKey) {
		this.treeColumnKey = treeColumnKey;
	}
	
	/**
	 * 取得树列标识
	 * @return 树列标识
	 */
	public String getTreeColumnKey() {
		return this.treeColumnKey;
	}
	
	/**
	 * 设置綁定的数据表
	 * @param tableKey 数据表标识
	 */
	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}
	
	/**
	 * 取得绑定的数据表
	 * @return 数据表标识
	 */
	public String getTableKey() {
		return this.tableKey;
	}
	
	/**
	 * 设置行点击事件
	 * @param rowClick 行点击事件
	 * @see MetaBaseScript
	 */
	public void setRowClick(MetaBaseScript rowClick) {
		this.rowClick = rowClick;
	}
	
	/**
	 * 取得行点击事件
	 * @return 行点击事件
	 * @see MetaBaseScript
	 */
	public MetaBaseScript getRowClick() {
		return this.rowClick;
	}
	
	/**
	 * 设置行双击事件
	 * @param rowDblClick 行双击事件
	 * @see MetaBaseScript
	 */
	public void setRowDblClick(MetaBaseScript rowDblClick) {
		this.rowDblClick = rowDblClick;
	}
	
	/**
	 * 取得行双击事件
	 * @return 行双击事件
	 * @see MetaBaseScript
	 */
	public MetaBaseScript getRowDblClick() {
		return this.rowDblClick;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaTreeView newObject = (MetaTreeView)super.clone();
		newObject.setColumnCollection(columnCollection == null ? null : (MetaTreeViewColumnCollection)columnCollection.clone());
		newObject.setDataSource(dataSource == null ? null : (MetaTreeViewDataSource)dataSource.clone());
		newObject.setTreeColumnKey(treeColumnKey);
		newObject.setTableKey(tableKey);
		newObject.setRowClick(rowClick == null ? null : (MetaBaseScript)rowClick.clone());
		newObject.setRowDblClick(rowDblClick == null ? null : (MetaBaseScript)rowDblClick.clone());
		
		return newObject;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTreeView();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}
}
