package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import com.bokesoft.yigo.meta.form.component.control.MetaHyperLink;

public class MetaHyperLinkProperties extends AbstractMetaObject implements IPropertyMerger<MetaHyperLinkProperties>{
	/** 点击事件 */
	private MetaBaseScript onClick = null;

	/** 获取超链接引用的地址 */
	private String formulaURL = "";
	
	/** 超链接引用的地址 */
	private String url = "";
	
	/** 目标显示方式，取值为新窗口(New)、当前页(Current)、新Tab页(NewTab) */
	private Integer targetShowType = MetaHyperLink.TARGETSHOWTYPE_NEWTAB;
	
	/** 是否需要认证标志--移动端 */
	private Boolean needAuthenticate = false;
	
	private Boolean checkOnClickNode = false;
	
	public MetaHyperLinkProperties() {
		super();
	}
	
	/**
	 * 设置点击事件
	 * 
	 * @param onClick
	 *            点击事件
	 */
	public void setOnClick(MetaBaseScript onClick) {
		this.onClick = onClick;
	}

	/**
	 * 获取点击事件
	 * 
	 * @return 点击事件
	 */
	public MetaBaseScript getOnClick() {
		return this.onClick;
	}

	/**
	 * 设置超链接引用的地址
	 * 
	 * @param onClick
	 *            超链接引用的地址
	 */
	public void setFormulaURL(String formulaURL) {
		this.formulaURL = formulaURL;
	}

	/**
	 * 获取超链接引用的地址
	 * 
	 * @return 超链接引用的地址
	 */
	public String getFormulaURL() {
		return this.formulaURL;
	}
	
	/**
	 * 设置引用地址
	 * 
	 * @param url
	 *            引用地址
	 */
	public void setURL(String url) {
		this.url = url;
	}

	/**
	 * 获取引用地址
	 * 
	 * @return 引用地址
	 */
	public String getURL() {
		return this.url;
	}

	/**
	 * 设置目标显示方式
	 * 
	 * @param type
	 *            目标显示方式
	 */
	public void setTargetShowType(Integer type) {
		this.targetShowType = type;
	}

	/**
	 * 获取目标显示方式
	 * 
	 * @return 目标显示方式
	 */
	public Integer getTargetShowType() {
		return this.targetShowType;
	}

	/**
	 * 设置是否需要认证标志
	 * @param needAuthenticate 是否需要认证标志
	 */
	public void setNeedAuthenticate(Boolean needAuthenticate) {
		this.needAuthenticate = needAuthenticate;
	}
	
	/**
	 * 获取是否需要认证标志
	 * @return 是否需要认证标志
	 */
	public Boolean isNeedAuthenticate() {
		return needAuthenticate;
	}
	
	public Boolean getCheckOnClickNode() {
		return checkOnClickNode;
	}

	public void setCheckOnClickNode(Boolean checkOnClickNode) {
		this.checkOnClickNode = checkOnClickNode;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new Object[] {
				onClick
		});
	}

	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaConstants.Event_OnClick.equals(tagName) ) {
			onClick = new MetaBaseScript(MetaConstants.Event_OnClick);
			resultMetaObject = onClick;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaHyperLinkProperties newObject = new MetaHyperLinkProperties();
		newObject.setOnClick(onClick == null ? null : (MetaBaseScript)onClick.clone());
		newObject.setURL(url);
		newObject.setTargetShowType(targetShowType);
		newObject.setFormulaURL(formulaURL);
		newObject.setNeedAuthenticate(needAuthenticate);
		newObject.setCheckOnClickNode(checkOnClickNode);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaHyperLinkProperties();
	}

	@Override
	public void merge(MetaHyperLinkProperties properties) {
		if( this.onClick == null ) {
			this.onClick = properties.getOnClick();
		}
		if( this.targetShowType == -1 ) {
			this.targetShowType = properties.getTargetShowType();
		}
		if( this.url == null ) {
			this.url = properties.getURL();
		}
		if( this.formulaURL == null ) {
			this.formulaURL = properties.getFormulaURL();
		}
		if(needAuthenticate == null){
			needAuthenticate = properties.isNeedAuthenticate();
		}
		if (this.checkOnClickNode == null) {
			this.checkOnClickNode = properties.getCheckOnClickNode();
		}
	}
}
