package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaFileChooserProperties extends AbstractMetaObject {
	/** 用途 */
	private String useType = "";
	/** 是否允许多选 */
	private Boolean allowMulti = false;
	/** 扩展过滤 */
	private String extFilter = "";
	
	public MetaFileChooserProperties() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public String getTagName() {
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}
	
	/**
	 * 设置用途
	 * @param useType 用途，取值为Open和Save。
	 */
	public void setUseType(String useType) {
		this.useType = useType;
	}
	
	/**
	 * 取得用途，取值为Open和Save。
	 * @return 用途
	 */
	public String getUseType() {
		return this.useType;
	}
	
	/**
	 * 设置是否允许多选标志
	 * @param allowMulti 允许多选标志
	 */
	public void setAllowMulti(Boolean allowMulti) {
		this.allowMulti = allowMulti;
	}
	
	/**
	 * 取得是否允许多选标志
	 * @return 允许多选标志
	 */
	public Boolean isAllowMulti() {
		return this.allowMulti;
	}
	
	/**
	 * 设置扩展过滤
	 * @param extFilter 扩展过滤，以;分隔，比如xml;xls
	 */
	public void setExtFilter(String extFilter) {
		this.extFilter = extFilter;
	}
	
	/**
	 * 取得扩展过滤
	 * @return 扩展过滤
	 */
	public String getExtFilter() {
		return this.extFilter;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaFileChooserProperties newObject = (MetaFileChooserProperties)newInstance();
		newObject.setUseType(useType);
		newObject.setAllowMulti(allowMulti);
		newObject.setExtFilter(extFilter);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFileChooserProperties();
	}

}
