package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ComboBoxSourceType;
import com.bokesoft.yigo.common.def.ComboBoxTextShowType;
import com.bokesoft.yigo.common.def.SelectEditType;
import com.bokesoft.yigo.common.def.SelectStyle;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;

public class MetaComboBoxProperties extends AbstractMetaObject implements IPropertyMerger<MetaComboBoxProperties>{
    /**
     *
     */
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_COLUMN_COUNT = 3;
    /** 固定下拉项集合*/
    private MetaListBoxItemCollection items = null;

    /** 表达式表示的下拉项集合 */
    private MetaBaseScript formulaItems = null;

    /** 是否可编辑,指的是编辑不存在的值是否保存*/
    /** 对于绑定非数值类型的下拉框才有效*/
    private Boolean isEditable = false;

    /** 下拉项的依赖*/
    private String itemsDependency = "";

    /** 是否缓存下拉项,不缓存每次都会远程取得,对固定项的没意义*/
    private Boolean cache = true;

    /** 下拉所依赖的字段*/
    private List<String> dependentFields = new ArrayList<String>();

    /** 查询来源的查询定义*/
    private MetaQueryDef query = null;

    /** 下拉项来源,-1代表未定义*/
    private Integer sourceType = ComboBoxSourceType.ITEMS;

    /** 当sourceType为ParaGroup时 的分组标志*/
    private String groupKey = "";

    /** 全局下拉定义*/
    private String globalItems = "";

    /** 是否是整型值,如果绑定了数值类型的列,处理为true*/
    private Boolean integerValue = false;

    /** 文本编辑器为空时的提示信息 */
    private String promptText = "";

    /** 显示样式*/
    private Integer style = SelectStyle.POP;

    /** 编辑样式*/
    private Integer editType = SelectEditType.DIALOG;

    /** 平铺标签样式下的列数*/
    private Integer columnCount = DEFAULT_COLUMN_COUNT;

    /** 弹出动画,仅当style取值为Pop或者DropDown时有效，取值参考{@link com.bokesoft.yigo.common.def.PopAnim}*/
    private String popAnim = "";

    /**联想数据条数*/
    private Integer promptSize = -1;

    /** 下拉项显示方式 */
    private Integer textShowType = ComboBoxTextShowType.UNDEFINED;
    
    /**下拉过滤**/
    private MetaComboFilter comboFilter = null;

    /**
     * 构造方法，初始化items
     */
    public MetaComboBoxProperties() {
        super();
        items = new MetaListBoxItemCollection();
    }

    /**
     * 设置是否可编辑
     *
     * @param isEditable
     *            是否可编辑
     */
    public void setEditable(Boolean isEditable) {
        this.isEditable = isEditable;
    }

    /**
     * 获取是否可编辑
     *
     * @return 是否可编辑
     */
    public Boolean isEditable() {
        return this.isEditable;
    }

    /**
     * 获取是否动态behavior
     * @return 是否动态behavior
     */
    public boolean isDynamicBehavior() {
        return dependentFields.size() > 0;
    }

    /**
     * 获取全局下拉项定义
     * @return 全局下拉项定义
     */
    public String getGlobalItems() {
        return globalItems;
    }

    /**
     * 设置全局下拉项
     * @param globalItems 全局下拉项定义
     */
    public void setGlobalItems(String globalItems) {
        this.globalItems = globalItems;
    }

    /**
     * 设置表达式下拉项
     * @param formulaItems 脚本元数据
     */
    public void setFormulaItems(MetaBaseScript formulaItems) {
        this.formulaItems = formulaItems;
    }

    /**
     * 取得表达式下拉项
     * @return 脚本元数据
     */
    public MetaBaseScript getFormulaItems() {
        return this.formulaItems;
    }

    /**
     * 载入的时候会将类型为Field的查询参数加入进来,
     * 所以可以直接获取
     *
     * @return 下拉项依赖的字段集合
     */
    public List<String> getDependedFields(){
        return this.dependentFields;
    }

    /**
     * 获取依赖
     * @return 下拉项依赖
     */
    public String getItemsDependency(){
        return this.itemsDependency;
    }

    /**
     * 获取是否缓存
     * @return 标志
     */
    public Boolean getCache() {
        return cache;
    }

    /**
     * 设置是否缓存
     * @param cache 标志
     */
    public void setCache(Boolean cache) {
        this.cache = cache;
    }

    /**
     * 设置依赖
     * @param dependency 依赖
     */
    public void setItemsDependency(String dependency){
        this.itemsDependency = "";
        this.dependentFields.clear();
        if(dependency != null && dependency.length() > 0){
            this.itemsDependency = dependency;

            String[] fields = this.itemsDependency.split(",");

            for(String field : fields){
                dependentFields.add(field);
            }
        }
    }

    /**
     * 设置依赖列表
     * @param dependentFields 依赖列表
     */
    public void setDependentFields(List<String> dependentFields) {
        this.dependentFields = dependentFields;
    }

    /**
     * 取得是否取整型值
     * @return 标志
     */
    public Boolean isIntegerValue() {
        return this.integerValue;
    }

    /**
     * 设置是否取整型值
     * @param integerValue 标志
     */
    public void setIntegerValue(Boolean integerValue) {
        this.integerValue = integerValue;
    }

    /**
     * 获取下拉项的总数
     *
     * @return 下拉项总数
     */
    public int getItemCount() {
        return items.size();
    }

    /**
     * 根据序号获取下拉项
     *
     * @param index
     *            序号
     * @return 下拉项
     */
    public MetaDefaultItem getItem(int index) {
        return items.get(index);
    }

    /**
     * 设置下拉项集合
     * @param items 下拉项集合
     */
    public void setItems(MetaListBoxItemCollection items) {
        this.items = items;
    }

    /**
     * 取得下拉项集合
     * @return 下拉项集合
     */
    public MetaListBoxItemCollection getItems() {
        return items;
    }

    /**
     * 设置查询定义
     * @param query 查询定义
     */
    public void setQueryDef(MetaQueryDef query) {
        this.query = query;
    }

    /**
     * 取得查询定义
     * @return 查询定义
     */
    public MetaQueryDef getQueryDef(){
        return this.query;
    }

    /**
     * 取得来源类型
     * @return 来源类型
     */
    public Integer getSourceType(){
        return this.sourceType;
    }

    /**
     * 取得来源类型
     * @param type 来源类型
     */
    public void setSourceType(Integer type){
        this.sourceType = type;
    }

    /**
     * 取得组标识
     * @return 组标识
     */
    public String getGroupKey() {
        return groupKey;
    }

    /**
     * 设置组标识
     * @param groupKey 组标识
     */
    public void setGroupKey(String groupKey) {
        this.groupKey = groupKey;
    }

    /**
     * 设置文本为空时的提示信息
     *
     * @param promptText
     *            提示信息
     */
    public void setPromptText(String promptText) {
        this.promptText = promptText;
    }

    /**
     * 获取文本为空时的提示信息
     *
     * @return 提示信息
     */
    public String getPromptText() {
        return this.promptText;
    }

    /**
     * 获取显示样式
     * @return 显示样式，取值参考{@link SelectStyle}
     */
    public Integer getStyle() {
        return style;
    }

    /**
     * 设置显示样式
     * @param style 显示样式，取值参考{@link SelectStyle}
     */
    public void setStyle(Integer style) {
        this.style = style;
    }

    /**
     * 获取编辑样式
     * @return 编辑样式，取值参考{@link SelectEditType}
     */
    public Integer getEditType() {
        return editType;
    }

    /**
     * 设置编辑样式
     * @param editType 编辑样式，取值参考{@link SelectEditType}
     */
    public void setEditType(Integer editType) {
        this.editType = editType;
    }

    /**
     * 获取平铺标签样式下的列数
     * @return 平铺标签样式下的列数
     */
    public Integer getColumnCount() {
        return columnCount;
    }

    /**
     * 设置平铺标签样式下的列数
     * @param columnCount 平铺标签样式下的列数
     */
    public void setColumnCount(Integer columnCount) {
        this.columnCount = columnCount;
    }

    /**
     * 获取弹出动画
     * @return 弹出动画，取值参考{@link com.bokesoft.yigo.common.def.PopAnim}
     */
    public String getPopAnim() {
        return popAnim;
    }

    /**
     * 设置弹出动画
     * @param popAnim 弹出动画，取值参考{@link com.bokesoft.yigo.common.def.PopAnim}
     */
    public void setPopAnim(String popAnim) {
        this.popAnim = popAnim;
    }

    /**
     * 获取联想条数
     * @return
     */
    public Integer getPromptSize() {
        return promptSize;
    }

    /**
     * 设置联想条数
     * @param promptSize
     */
    public void setPromptSize(Integer promptSize) {
        this.promptSize = promptSize;
    }

    /**
     * 取得下拉项显示方式
     * @return 下拉项显示方式
     */
    public Integer getTextShowType(){
        return this.textShowType;
    }

    /**
     * 取得下拉项显示方式
     * @param type 下拉项显示方式
     */
    public void setTextShowType(Integer type){
        this.textShowType = type;
    }
     
    /**
     * 取得下拉过滤
     * @return 下拉过滤
     */
    public MetaComboFilter getComboFilter() {
		return comboFilter;
	}
    
    
    /**
     * 设置下拉过滤
     * @param comboFilter 下拉过滤
     */
    public void setComboFilter(MetaComboFilter comboFilter) {
		this.comboFilter = comboFilter;
	}
    
    /**
     * 获取下拉项显示格式
     *
     * @return
     */
    public String getTextShowFormat() {
        return ComboBoxTextShowType.getFormatString(this.getTextShowType());
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        addAll(list, new AbstractMetaObject[] { items, formulaItems, query, comboFilter });
    }

    @Override
    public String getTagName() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
        super.doPostProcess(flag, callback);
        if(this.query != null){
            query.doPostProcess(flag, callback);

            List<String> list = this.query.getDependedFields();
            if(list != null){
                for(String field : list){
                    if(!this.dependentFields.contains(field)){
                        this.dependentFields.add(field);
                    }
                }
            }
        }
        if(this.comboFilter != null) {
        	this.comboFilter.doPostProcess(flag, callback);
        }
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
                                                    Object node, String tagName, Object flag, int runType) throws MetaException {
        AbstractMetaObject resultMetaObject = items.createChildMetaObject(env, doc, node, tagName, flag, runType);
        if ( resultMetaObject == null ) {
            if ( tagName.equalsIgnoreCase(MetaConstants.COMBOBOX_FORMULAITEMS) ) {
                this.formulaItems = new MetaBaseScript(MetaConstants.COMBOBOX_FORMULAITEMS);
                resultMetaObject = formulaItems;
            }else if(tagName.equalsIgnoreCase(MetaQueryDef.TAG_NAME)){
                this.query = new MetaQueryDef();
                resultMetaObject = query;
            }else if(tagName.equalsIgnoreCase(MetaComboFilter.TAG_NAME)) {
            	this.comboFilter = new MetaComboFilter();
            	resultMetaObject = comboFilter;
            }
        }

        return resultMetaObject;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaComboBoxProperties newObject = new MetaComboBoxProperties();
        newObject.setEditable(isEditable);
        newObject.setItems(items == null ? null : (MetaListBoxItemCollection)items.clone());
        newObject.setFormulaItems(formulaItems == null ? null : (MetaBaseScript)formulaItems.clone());
        newObject.setItemsDependency(itemsDependency);
        newObject.setQueryDef(query == null ? null : (MetaQueryDef)query.clone());
        newObject.setSourceType(this.sourceType);
        newObject.setCache(cache);
        newObject.setGroupKey(groupKey);
        newObject.setGlobalItems(globalItems);
        newObject.setIntegerValue(integerValue);
        newObject.setDependentFields(dependentFields);
        newObject.setPromptText(promptText);
        newObject.setStyle(style);
        newObject.setEditType(editType);
        newObject.setColumnCount(columnCount);
        newObject.setPopAnim(popAnim);
        newObject.setPromptSize(promptSize);
        newObject.setTextShowType(textShowType);
        newObject.setComboFilter(comboFilter == null ? null : (MetaComboFilter)comboFilter.clone());
        return newObject;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaComboBoxProperties();
    }

    @Override
    public void merge(MetaComboBoxProperties properties) {
        if( this.isEditable == null ) {
            this.isEditable = properties.isEditable();
        }
        //noinspection DuplicatedCode
        if (Objects.nonNull(properties.getItems())) {
            MetaListBoxItemCollection items = (MetaListBoxItemCollection) properties.getItems().clone();
            if (Objects.nonNull(this.items)) {
                List<String> existItemKeys = new ArrayList<>();
                for (MetaDefaultItem item : items) {
                    existItemKeys.add(item.getKey());
                }
                for (MetaDefaultItem item : this.items) {
                    if (!existItemKeys.contains(item.getKey())) {
                        items.add((MetaDefaultItem) item.clone());
                    }
                }
            }
            this.items = (MetaListBoxItemCollection) items.clone();
        }
        if( this.formulaItems == null ) {
            this.formulaItems = properties.getFormulaItems();
        }
        if( this.itemsDependency == null ) {
            this.itemsDependency = properties.getItemsDependency();
        }
        if( this.cache == null ) {
            this.cache = properties.getCache();
        }
        if( this.query == null ) {
            this.query = properties.getQueryDef();
        }
        if( this.sourceType == -1 ) {
            this.sourceType = properties.getSourceType();
        }
        if( this.groupKey == null ) {
            this.groupKey = properties.getGroupKey();
        }
        if( this.globalItems == null ) {
            this.globalItems = properties.getGlobalItems();
        }
        if( this.integerValue == null ) {
            this.integerValue = properties.isIntegerValue();
        }
        if( this.promptText == null ) {
            this.promptText = properties.getPromptText();
        }
        //解决PP_MRP_MaterialImpl_ERP_Vest_2表单PPBlackflush字段的NPE错误
        if( this.promptSize==null || this.promptSize == -1 ) {
            this.promptSize = properties.getPromptSize();
        }
        if( this.textShowType == ComboBoxTextShowType.UNDEFINED ) {
            this.textShowType = properties.getTextShowType();
        }

        MetaComboFilter comboFilter = properties.getComboFilter();
        if( comboFilter != null ) {
            if( this.comboFilter == null ) {
                this.comboFilter = (MetaComboFilter) comboFilter.clone();
            } else {
                this.comboFilter.merge(comboFilter);
            }
        }
    }
}
