package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.IconLocationType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaCheckBoxProperties extends AbstractMetaObject implements IPropertyMerger<MetaCheckBoxProperties>{
	/**默认图标*/
	private String icon = "";
	/**选中图标*/
	private String selectedIcon = "";
	/**图标位置*/
	private Integer iconLocation = IconLocationType.LEFT;
	/**是否隐藏图标按钮*/
	private Boolean isHideButton = false;
	/**选中联动类型,PS,P,S,""*/
	private String checkedType = "";
	/**取消选中联动类型,PS,P,S,""*/
	private String unCheckedType = "";
	/**是否开启半选*/
	private Boolean enableHalfCheck = false;
	/**是否显示全选框*/
	private Boolean enableCheckAll = true;
	
	private Boolean checkOnClickNode = false;
	
	/**
	 * 设置默认图标
	 * @param icon 默认图标
	 */
	public void setIcon(String icon) {
		this.icon = icon;
	}
	
	/**
	 * 获取默认图标
	 * @return 默认图标
	 */
	public String getIcon() {
		return icon;
	}
	
	/**
	 * 设置选中图标
	 * @param selectedIcon 选中图标
	 */
	public void setSelectedIcon(String selectedIcon) {
		this.selectedIcon = selectedIcon;
	}
	
	/**
	 * 获取选中图标
	 * @return 选中图标
	 */
	public String getSelectedIcon() {
		return selectedIcon;
	}
	
	/**
	 * 设置图标位置
	 * @param iconLocation 图标位置
	 */
	public void setIconLocation(Integer iconLocation) {
		this.iconLocation = iconLocation;
	}
	
	/**
	 * 获取图标位置
	 * @return 图标位置
	 */
	public Integer getIconLocation() {
		return iconLocation;
	}
	
	/**
	 * 获取是否隐藏按钮
	 * @return 是否隐藏按钮
	 */
	public Boolean getIsHideButton() {
		return this.isHideButton;
	}
	
	/**
	 * 设置是否隐藏按钮
	 * @param 
	 */
	public void setHideButton(Boolean isHideButton) {
		this.isHideButton = isHideButton;
	}

	/**
	 * 获取是否开启半选
	 * @return
	 */
	public Boolean getEnableHalfCheck() {
		return enableHalfCheck;
	}

	/**
	 * 设置是否开启半选
	 * @param enableHalfCheck
	 */
	public void setEnableHalfCheck(Boolean enableHalfCheck) {
		this.enableHalfCheck = enableHalfCheck;
	}

	/**
	 * 获取是否显示全选框
	 * @return
	 */
	public Boolean getEnableCheckAll() {
		return enableCheckAll;
	}

	/**
	 * 设置是否显示全选框
	 * @param checkAllButton
	 */
	public void setEnableCheckAll(Boolean enableCheckAll) {
		this.enableCheckAll = enableCheckAll;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	public String getCheckedType() {
		return checkedType;
	}

	public void setCheckedType(String checkedType) {
		this.checkedType = checkedType;
	}

	public String getUnCheckedType() {
		return unCheckedType;
	}

	public void setUnCheckedType(String unCheckedType) {
		this.unCheckedType = unCheckedType;
	}
	
	public Boolean getCheckOnClickNode() {
		return checkOnClickNode;
	}

	public void setCheckOnClickNode(Boolean checkOnClickNode) {
		this.checkOnClickNode = checkOnClickNode;
	}

	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaCheckBoxProperties newObject = new MetaCheckBoxProperties();
		newObject.setIcon(icon);
		newObject.setSelectedIcon(selectedIcon);
		newObject.setIconLocation(iconLocation);
		newObject.setHideButton(isHideButton);
		newObject.setCheckedType(checkedType);
		newObject.setUnCheckedType(unCheckedType);
		newObject.setEnableHalfCheck(enableHalfCheck);
		newObject.setEnableCheckAll(enableCheckAll);
		newObject.setCheckOnClickNode(checkOnClickNode);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCheckBoxProperties();
	}

	@Override
	public void merge(MetaCheckBoxProperties p) {
		if( this.icon == null ) {
			this.icon = p.getIcon();
		}
		if( this.selectedIcon == null ) {
			this.selectedIcon = p.getSelectedIcon();
		}
		if( this.iconLocation == -1 ) {
			this.iconLocation = p.getIconLocation();
		}
		if( this.isHideButton == null ) {
			this.isHideButton = p.getIsHideButton();
		}
		if( this.checkedType == null ) {
			this.checkedType = p.getCheckedType();
		}
		if( this.unCheckedType == null ) {
			this.unCheckedType = p.getUnCheckedType();
		}
		if( this.enableHalfCheck == null ) {
			this.enableHalfCheck = p.getEnableHalfCheck();
		}
		if( this.enableCheckAll == null ) {
			this.enableCheckAll = p.getEnableCheckAll();
		}
		if (this.checkOnClickNode == null) {
			this.checkOnClickNode = p.getCheckOnClickNode();
		}
	}
}
