package com.bokesoft.yigo.meta.form.component.control.listview;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;

public class MetaRotator extends MetaEditView {
	public static final String TAG_NAME = ControlType.STR_ROTATOR;
	
	/** 自动切换间隔时间 */
	private Double intervalTime = 0d;
	/** 是否循环显示*/
	private Boolean repeat = true;
	/** 是否显示指示器*/
	private Boolean indicator = true;
	/** 是否显示页码*/
	private Boolean pagination = false;
	/** 指示器位置*/
	private Integer indicatorLocation = -1;
	/** 自动切换的动画用时*/
	private Double animTime = 0d;
	
	/**
	 * 设置自动切换间隔时间
	 * @param intervalTime 间隔时间
	 */
	public void setIntervalTime(Double intervalTime) {
		this.intervalTime = intervalTime;
	}
	
	/**
	 * 取得自动切换的间隔时间
	 * @return 间隔时间
	 */
	public Double getIntervalTime() {
		return intervalTime;
	}
	
	/**
	 * 设置是否循环显示
	 * @param repeat 是否循环显示
	 */
	public void setRepeat(Boolean repeat) {
		this.repeat = repeat;
	}
	
	/**
	 * 是否循环显示
	 * @return 是否循环显示
	 */
	public Boolean isRepeat() {
		return repeat;
	}

	/**
	 * 设置是否显示指示器
	 * @param indicator 是否显示指示器
	 */
	public void setIndicator(Boolean indicator) {
		this.indicator = indicator;
	}
	
	/**
	 * 是否显示指示器
	 * @return 是否显示指示器
	 */
	public Boolean isIndicator() {
		return indicator;
	}
	
	/**
	 * 设置是否显示页码
	 * @param pagination 是否显示页码
	 */
	public void setPagination(Boolean pagination) {
		this.pagination = pagination;
	}
	
	/**
	 * 是否显示页码
	 * @return 是否显示页码
	 */
	public Boolean isPagination() {
		return pagination;
	}
	
	/**
	 * 设置指示器位置
	 * @param indicatorLocation 指示器位置，参考{@link com.bokesoft.yigo.common.def.HAlignment}
	 */
	public void setIndicatorLocation(Integer indicatorLocation) {
		this.indicatorLocation = indicatorLocation;
	}
	
	/**
	 * 获取指示器位置
	 * @return 指示器位置，参考{@link com.bokesoft.yigo.common.def.HAlignment}
	 */
	public Integer getIndicatorLocation() {
		return indicatorLocation;
	}
	
	/**
	 * 设置切换时的动画用时
	 * @param animTime 切换时的动画用时
	 */
	public void setAnimTime(Double animTime) {
		this.animTime = animTime;
	}
	
	/**
	 * 获取切换时的动画用时
	 * @return 切换时的动画用时
	 */
	public Double getAnimTime() {
		return animTime;
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.ROTATOR;
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if(animTime > 0 && intervalTime != null && intervalTime > 0 && animTime >= intervalTime){
			throw new MetaException(MetaException.ROTATOR_ANIMTIME_GREATER_THAN_OR_EQUAL_TO_INTERVALTIME, 
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.RotatorAnimTimeGreaterThanOrEqualToIntervalTime), getKey()));
		}
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaRotator newObject = (MetaRotator)super.clone();
		newObject.setIntervalTime(intervalTime);
		newObject.setRepeat(repeat);
		newObject.setIndicator(indicator);
		newObject.setIndicatorLocation(indicatorLocation);
		newObject.setPagination(pagination);
		newObject.setAnimTime(animTime);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRotator();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}
	
	@Override
	public int getDefaultPromptRowCount() {
		return 1;
	}
	
	@Override
	public int getDefaultOrientation() {
		return OrientationType.Horizontal;
	}
}
