package com.bokesoft.yigo.meta.form.component.control.listview;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

/**
 * 列表固定项配置对象集合
 */

public class MetaListViewItemCollection extends GenericKeyCollection<MetaListViewItem> {

	public static final String TAG_NAME = "ListViewItemCollection";
	/**
	 * 公式数据来源  
	 */
	private MetaBaseScript formulaItems;
	
	/**
	 * 获取公式数据来源 
	 *
	 * @return 公式数据来源
	 */
	public MetaBaseScript getFormulaItems() {
		return formulaItems;
	}

	/**
	 * 设置公式数据来源 
	 *
	 * @param formulaItems
	 *            公式数据来源
	 */
	public void setFormulaItems(MetaBaseScript formulaItems) {
		this.formulaItems = formulaItems;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] {formulaItems });
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
													String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equals(MetaConstants.COMBOBOX_FORMULAITEMS)) {
			this.formulaItems = new MetaBaseScript(MetaConstants.COMBOBOX_FORMULAITEMS);
			resultMetaObject = formulaItems;
		}else if (MetaListViewItem.TAG_NAME.equals(tagName)) {
			MetaListViewItem item = new MetaListViewItem();
			item.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(item);
			resultMetaObject = item;
		}
		return resultMetaObject;
	}

	@Override
	public boolean isStandaloneNode() {
		return false;
	}

	@Override
	public MetaListViewItemCollection clone() {
		MetaListViewItemCollection newObject = (MetaListViewItemCollection) super.clone();
		newObject.setFormulaItems(formulaItems == null ? null : (MetaBaseScript) formulaItems.clone());
		return newObject;
	}

	@Override
	public MetaListViewItemCollection newInstance() {
		return new MetaListViewItemCollection();
	}
}
