package com.bokesoft.yigo.meta.form.component.control.listview;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.ItemAnimType;
import com.bokesoft.yigo.common.def.ListViewSortType;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.common.def.PageLoadType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.grid.IGridComponent;

public class MetaListView extends MetaComponent implements IGridComponent {
	public static final String TAG_NAME = ControlType.STR_LISTVIEW;
	/** 默认行高*/
	public static final int DEFAULT_HEIGHT = 36;

	/** 列配置定义集合*/
	private MetaListViewColumnCollection columnCollection = null;
	/** 行点击事件 */
	private MetaBaseScript rowClick = null;
	/** 行双击事件 */
	private MetaBaseScript rowDblClick = null;
	/** 焦点行改变事件 */
	private MetaBaseScript focusRowChanged = null;
	/** 关联数据表标识 */
	private String tableKey = "";
	/** 行高*/
	private Integer rowHeight = -1;
	/** 分页时 每页显示行数*/
	private Integer pageRowCount = 50;
	/** 分页类型*/
	private Integer pageLoadType = PageLoadType.NONE;
	/** 选择字段所在的列序号*/
	private Integer selectFieldIndex = -1;
	/** 行配置定义*/
	private MetaListViewRow row = null;
	/** 是否展示表头*/
	private Boolean isShowHead = false;
	/** 默认选中行序号*/
	private Integer defaultSelectRow = -1;
	/** 空数据时的显示文本*/
	private String promptText = "";
	/** 加载中的行视图图片名称或路径*/
	private String promptImage = "";
	/** 加载中的行视图数量*/
	private Integer promptRowCount = getDefaultPromptRowCount();
	/** 列表行插入删除的动画*/
	private String itemAnim = ItemAnimType.FADEIN;
	/** 列表的布局动画，即显示行数据时，行显示的动画*/
	private String layoutAnim = "";
	/** 布局方向*/
	private Integer orientation = getDefaultOrientation();
	/** 固定项配置对象集合*/
	private MetaListViewItemCollection itemCollection = null;
	/** 是否允许上下左右滚动,默认只上下滚动,报表查看使用*/
	private Boolean scrollXY = false;
	/** 行编辑表单名称*/
	private String editRowFormKey = "";
	/** 是否显示总行数 */
	private Boolean showTotalRowCount = null;
	/** 业务字段集合*/
	private List<String> primaryKeys = new ArrayList<String>();
	/** 排序类型*/
	private Integer sortType = ListViewSortType.CurrentPage;
	
	public MetaListView() {
		columnCollection = new MetaListViewColumnCollection();
		itemCollection = new MetaListViewItemCollection();
	}
	
	/**
	 * 设置默认选中行序号
	 * @param defaultSelectRow 默认选中行序号
	 */
	public void setDefaultSelectRow(Integer defaultSelectRow) {
		this.defaultSelectRow = defaultSelectRow;
	}
	
	/** 获取默认选中行序号
	 * @return 默认选中行序号
	 */
	public Integer getDefaultSelectRow() {
		return defaultSelectRow;
	}
	
	/**
	 * 获取行编辑表单标识
	 * @return
	 */
	public String getEditRowFormKey() {
		return editRowFormKey;
	}
	
	/**
	 * 设置行编辑表单标识
	 * @param editRowFormKey
	 */
	public void setEditRowFormKey(String editRowFormKey) {
		this.editRowFormKey = editRowFormKey;
	}
	
	/**
	 * 获取业务关键字集合
	 * @return
	 */
	public List<String> getPrimaryKeys() {
		return primaryKeys;
	}

	/**
	 * 设置业务关键字集合
	 * @param primaryKeys
	 */
	public void setPrimaryKeys(List<String> primaryKeys) {
		this.primaryKeys = primaryKeys;
	}

	/**
	 * 设置空数据时的显示文本
	 * @param promptText 空数据时的显示文本
	 */
	public void setPromptText(String promptText) {
		this.promptText = promptText;
	}
	
	/**
	 * 获取空数据时的显示文本
	 * @return 空数据时的显示文本
	 */
	public String getPromptText() {
		return promptText;
	}
	
	/**
	 * 设置加载中的行视图图片名称或路径
	 * @param promptImage 加载中的行视图图片名称或路径
	 */
	public void setPromptImage(String promptImage) {
		this.promptImage = promptImage;
	}
	
	/**
	 * 获取加载中的行视图图片名称或路径
	 * @return 加载中的行视图图片名称或路径
	 */
	public String getPromptImage() {
		return promptImage;
	}
	
	/**
	 * 获取是否允许上下左右滚动
	 * @return
	 */
	public Boolean isScrollXY() {
		return scrollXY;
	}

	/**
	 * 设置是否允许上下左右滚动
	 * @param scrollXY
	 */
	public void setScrollXY(Boolean scrollXY) {
		this.scrollXY = scrollXY;
	}

	/**
	 * 获取默认加载中行视图的数量
	 * @return 默认加载中行视图的数量
	 */
	public int getDefaultPromptRowCount() {
		return 2;
	}
	
	/**
	 * 获取默认布局方向
	 * @return 默认布局方向，参考{@link com.bokesoft.yigo.common.def.OrientationType}
	 */
	public int getDefaultOrientation(){
		return OrientationType.Vertical;
	}
	
	/**
	 * 设置加载中的行视图的数量
	 * @param promptRowCount 加载中的行视图的数量
	 */
	public void setPromptRowCount(Integer promptRowCount) {
		this.promptRowCount = promptRowCount;
	}
	
	/**
	 * 获取加载中的行视图的数量
	 * @return 加载中的行视图的数量
	 */
	public Integer getPromptRowCount() {
		return promptRowCount;
	}
	
	/**
	 * 设置行插入删除的动画类型
	 * @param itemAnim 行插入删除的动画类型，参考{@link ItemAnimType}
	 */
	public void setItemAnim(String itemAnim) {
		this.itemAnim = itemAnim;
	}
	
	/**
	 * 获取行插入删除的动画类型
	 * @return 行插入删除的动画类型，参考{@link ItemAnimType}
	 */
	public String getItemAnim() {
		return itemAnim;
	}
	
	/**
	 * 设置列表的布局动画，即显示行数据时，行显示的动画
	 * @param layoutAnim 列表的布局动画，类型默认支持：
	 * SLIDEINDOWN-底部滑入；SLIDEINRIGHT-从右侧滑入；FADE-淡入淡出；EXPLODE-放大；
	 * 也支持自定义的布局动画，该值表示自定义动画的标识
	 */
	public void setLayoutAnim(String layoutAnim) {
		this.layoutAnim = layoutAnim;
	}
	
	/** 
	 * 获取列表的布局动画，即显示行数据时，行显示的动画
	 * @return 列表的布局动画，即显示行数据时，行显示的动画
	 */
	public String getLayoutAnim() {
		return layoutAnim;
	}

	/**
	 * 设置行点击事件
	 * @param rowClick 定义
	 */
	public void setRowClick(MetaBaseScript rowClick) {
		this.rowClick = rowClick;
	}
	
	@Override
	public boolean receiveFocus() {
		return false;
	}

	/**
	 * 取得行击点事件
	 * @return 定义
	 */
	public MetaBaseScript getRowClick() {
		return this.rowClick;
	}
	
	/**
	 * 获取行背景色
	 * @return 行背景色
	 * */
	public String getRowBackColor() {
	    return this.row == null ? null : this.row.getBackColor();
	}

	/**
	 * 设置行双击事件
	 * @param rowDblClick 定义
	 */
	public void setRowDblClick(MetaBaseScript rowDblClick) {
		this.rowDblClick = rowDblClick;
	}

	/**
	 * 取得行双击事件
	 * @return 定义
	 */
	public MetaBaseScript getRowDblClick() {
		return this.rowDblClick;
	}
	
	/**
	 * 设置焦点行改变事件
	 * @param focusRowChanged 定义
	 */
	public void setFocusRowChanged(MetaBaseScript focusRowChanged) {
		this.focusRowChanged = focusRowChanged;
	}
	
	/**
	 * 取得焦点行改变事件
	 * @return 定义
	 */
	public MetaBaseScript getFocusRowChanged() {
		return this.focusRowChanged;
	}

	/**
	 * 设置关联表标识
	 * @param tableKey 关联表标识
	 */
	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}

	/**
	 * 获取关联表标识
	 * @return 关联表标识
	 */
	public String getTableKey() {
		return this.tableKey;
	}
	
	/**
	 * 设置是否显示表头，仅移动端使用
	 * @param isShowHead 是否显示表头
	 */
	public void setShowHead(Boolean isShowHead) {
		this.isShowHead = isShowHead;
	}
	
	/**
	 * 是否显示表头，仅移动端使用
	 * @return 是否显示表头
	 */
	public Boolean isShowHead() {
		return this.isShowHead;
	}
	
	/**
	 * 设置列集合
	 * @param columnCollection 列集合
	 */
	public void setColumnCollection(MetaListViewColumnCollection columnCollection) {
		this.columnCollection = columnCollection;
	}
	
	/**
	 * 获取列集合
	 * @return 列集合
	 */
	public MetaListViewColumnCollection getColumnCollection() {
		return this.columnCollection;
	}
	
	/**
	 * 设置行配置定义对象
	 * @param row 行配置定义对象
	 */
	public void setRow(MetaListViewRow row) {
		this.row = row;
	}
	
	/**
	 * 获取行配置定义对象
	 * @return 行配置定义对象
	 */
	public MetaListViewRow getRow() {
		return row;
	}
	
	/**
	 * 保证行配置定义对象不为空，并返回
	 * @return 行配置定义对象
	 */
	public MetaListViewRow ensureRow() {
		if (this.row == null) {
			this.row = new MetaListViewRow();
		}
		return this.row;
	}
	
	/**
	 * 设置布局方向
	 * @param orientation 布局方向，参考{@link com.bokesoft.yigo.common.def.OrientationType}
	 */
	public void setOrientation(Integer orientation) {
		this.orientation = orientation;
	}
	
	/**
	 * 获取布局方向
	 * @return 布局方向，参考{@link com.bokesoft.yigo.common.def.OrientationType}
	 */
	public Integer getOrientation() {
		return orientation;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.LISTVIEW;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		addAll(list, new AbstractMetaObject[] { columnCollection, rowClick, rowDblClick, focusRowChanged, row, itemCollection });
	}


	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		
		if(orientation < 0){
			orientation = getDefaultOrientation();
		}
		
		Iterator<MetaListViewColumn> it = this.columnCollection.iterator();

		MetaListViewColumn column = null;
		int index = 0;
		while (it.hasNext()) {
			column = it.next();
			if (column.isOnlyShow() == null) {
				column.setOnlyShow(true);
			}
			column.setTableKey(this.tableKey);
			if (column.getDataBinding() != null) {
				column.getDataBinding().setTableKey(tableKey);
			}
			column.doPostProcess(flag, callback);
			if (column.isSelect()) {
				this.selectFieldIndex = index;
			}
			index++;
		}

	}
	
	public void setSelectFieldIndex(Integer selectFieldIndex) {
		this.selectFieldIndex = selectFieldIndex;
	}
	
	/**
	 * 获取该ListView是否有选择字段
	 * @return 如果ListView有选择字段返回true，否则返回false
	 */
	@Override
	public boolean hasSelectField() {
		return selectFieldIndex != -1;
	}
	
	/**
	 * 获取选择字段所在的列序号
	 * @return 列序列
	 */
	public Integer getSelectFieldIndex() {
		return selectFieldIndex;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaListViewColumnCollection.TAG_NAME)) {
			columnCollection = new MetaListViewColumnCollection();
			resultMetaObject = columnCollection;
		} else if ( MetaConstants.Event_RowClick.equals(tagName) ) {
			rowClick = new MetaBaseScript(MetaConstants.Event_RowClick);
			resultMetaObject = rowClick;
		} else if ( MetaConstants.Event_RowDblClick.equals(tagName) ) {
			rowDblClick = new MetaBaseScript(MetaConstants.Event_RowDblClick);
			resultMetaObject = rowDblClick;
		} else if ( MetaConstants.Event_FocusRowChanged.equals(tagName) ) {
			focusRowChanged = new MetaBaseScript(MetaConstants.Event_FocusRowChanged);
			resultMetaObject = focusRowChanged;
		} else if(MetaListViewRow.TAG_NAME.equals(tagName)){
			row = new MetaListViewRow();
			resultMetaObject = row;
		}
		if(resultMetaObject == null){
			resultMetaObject = itemCollection.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}
		if ( resultMetaObject == null ) {
			resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}
		return resultMetaObject;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaListView newObject = (MetaListView)super.clone();
		newObject.setColumnCollection(columnCollection == null ? null : (MetaListViewColumnCollection)columnCollection.clone());
		newObject.setRowClick(rowClick == null ? null : (MetaBaseScript)rowClick.clone());
		newObject.setRowDblClick(rowDblClick == null ? null : (MetaBaseScript)rowDblClick.clone());
		newObject.setFocusRowChanged(focusRowChanged == null ? null : (MetaBaseScript)focusRowChanged.clone());
		newObject.setTableKey(tableKey);
		newObject.setPageRowCount(pageRowCount);
		newObject.setPageLoadType(pageLoadType);
		newObject.setRowHeight(rowHeight);
		newObject.setRow(row == null ? null : (MetaListViewRow)row.clone());
		newObject.setShowHead(isShowHead);
		newObject.setPromptText(promptText);
		newObject.setPromptImage(promptImage);
		newObject.setPromptRowCount(promptRowCount);
		newObject.setDefaultSelectRow(defaultSelectRow);
		newObject.setItemAnim(itemAnim);
		newObject.setLayoutAnim(layoutAnim);
		newObject.setSelectFieldIndex(selectFieldIndex);
		newObject.setOrientation(orientation);
		newObject.setScrollXY(scrollXY);
		newObject.setEditRowFormKey(editRowFormKey);
		newObject.setItemCollection(itemCollection == null ? null :(MetaListViewItemCollection)itemCollection.clone());
		newObject.setShowTotalRowCount(showTotalRowCount);
		newObject.setSortType(sortType);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaListView();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}

	/**
	 * 设置每页行数
	 * @param count 每页行数
	 */
	public void setPageRowCount(Integer count) {
		this.pageRowCount = count;
	}
	
	/**
	 * 取得每页行数
	 * @return 每页行数
	 */
	public Integer getPageRowCount() {
		return this.pageRowCount;
	}

	/**
	 * 设置分页类型
	 * @param type 分页类型
	 */
	public void setPageLoadType(Integer type) {
		this.pageLoadType = type;
	}
	
	/**
	 * 取得分页类型
	 * @return 分页类型
	 */
	@Override
	public Integer getPageLoadType() {
		return this.pageLoadType;
	}

	/**
	 * 获取行高
	 * @return 行高
	 */
	public Integer getRowHeight() {
		return rowHeight;
	}

	/**
	 * 设置行高
	 * @param rowHeight 行高
	 */
	public void setRowHeight(Integer rowHeight) {
		this.rowHeight = rowHeight;
	}
	
	/**
	 * 设置是否显示总行数
	 * @param showTotalRowCount 是否显示总行数
	 */
	public void setShowTotalRowCount(Boolean showTotalRowCount) {
		this.showTotalRowCount = showTotalRowCount;
	}
	
	/**
	 * 是否显示总行数
	 * @return 是否显示总行数
	 */
	public Boolean isShowTotalRowCount() {
		return this.showTotalRowCount;
	}
	
	/**
	 * 获取固定项配置对象集合
	 * @return 固定项配置对象集合
	 */
	public MetaListViewItemCollection getItemCollection() {
		return itemCollection;
	}
	
	/**
	 * 设置固定项配置对象集合
	 * @param itemCollection 固定项配置对象集合
	 */
	public void setItemCollection(MetaListViewItemCollection itemCollection) {
		this.itemCollection = itemCollection;
	}
	
	public Integer getSortType() {
		return sortType;
	}

	public void setSortType(Integer sortType) {
		this.sortType = sortType;
	}
		
	@Override
	public void merge(MetaComponent meta) {
		super.merge(meta);
		
		MetaListView metaLV = (MetaListView)meta;
		
		if( this.rowClick == null ) {
			this.rowClick = metaLV.getRowClick() == null ? null : (MetaBaseScript)metaLV.getRowClick().clone();
		}
		if( this.rowDblClick == null ) {
			this.rowDblClick = metaLV.getRowDblClick() == null ? null : (MetaBaseScript)metaLV.getRowDblClick().clone();
		}
		if( this.focusRowChanged == null ) {
			this.focusRowChanged = metaLV.getFocusRowChanged() == null ? null : (MetaBaseScript)metaLV.getFocusRowChanged().clone();
		}
		if( this.tableKey == null ) {
			this.tableKey = metaLV.getTableKey();
		}
		if( this.rowHeight == -1 ) {
			this.rowHeight = metaLV.getRowHeight();
		}
		if( this.pageRowCount == -1 ) {
			this.pageRowCount = metaLV.getPageRowCount();
		}
		if( this.getPageLoadType() == -1 ) {
			this.pageLoadType = metaLV.getPageLoadType();
		}
		if( this.row == null ) {
			this.row = metaLV.getRow() == null ? null : (MetaListViewRow)metaLV.getRow().clone();
		}
		if( this.isShowHead == null ) {
			this.isShowHead = metaLV.isShowHead();
		}
		if( this.defaultSelectRow == -1 ) {
			this.defaultSelectRow = metaLV.getDefaultSelectRow();
		}
		if( this.editRowFormKey == null ) {
			this.editRowFormKey = metaLV.getEditRowFormKey();
		}
		if( this.promptText == null ) {
			this.promptText = metaLV.getPromptText();
		}
		if( this.promptImage == null ) {
			this.promptImage = metaLV.getPromptImage();
		}
		if( this.promptRowCount == -1 ) {
			this.promptRowCount = metaLV.getPromptRowCount();
		}
		if( this.scrollXY == null ) {
			this.scrollXY = metaLV.isScrollXY();
		}
		if( this.itemAnim == null ) {
			this.itemAnim = metaLV.getItemAnim();
		}
		if( this.layoutAnim == null ) {
			this.layoutAnim = metaLV.getLayoutAnim();
		}
		if( this.orientation == -1 ) {
			this.orientation = metaLV.getOrientation();
		}
		if( this.showTotalRowCount == null) {
			this.showTotalRowCount = metaLV.isShowTotalRowCount();
		}
		if( this.sortType == -1){
			this.sortType = metaLV.getSortType();
		}
	}
}
