package com.bokesoft.yigo.meta.form.component.control.gantt;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 甘特图中表的列
 */
public class MetaGanttColumn extends KeyPairMetaObject {

	public static final String TAG_NAME = "GanttColumn";

	/** 列标识 */
	private String key = "";

	/** 列标题 */
	private String caption = "";

	/** 数据列标识 */
	private String columnKey = "";

	/** 列类型 */
	private int columnType = ControlType.LABEL;

	/** 单元格格式化字符串*/
	private String format = "";

	/** 日期格式化字符串*/
	private String dateFormat = "";

	/** 带时分秒格式化字符串*/
	private String dateTimeFormat = "";
	
	/** 树形列 */
	private boolean tree = false;

	/** 可见性*/
	private String visible = "";

	/** 默认值表达式*/
	private String defaultFormulaValue = "";

	/** 宽度*/
	private String width = "";

	/**
	 * 获取宽度
	 * @return
	 */
	public String getWidth() {
		return width;
	}

	/**
	 * 设置宽度
	 * @param width
	 */
	public void setWidth(String width) {
		this.width = width;
	}

	/**
	 * 设置列标识
	 */
	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public String getKey() {
		return this.key;
	}

	/**
	 * 设置列标题
	 * 
	 * @param caption
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}

	/**
	 * 获取列标题
	 * 
	 * @return
	 */
	public String getCaption() {
		return this.caption;
	}

	/**
	 * 设置数据列
	 * 
	 * @param columnKey
	 */
	public void setColumnKey(String columnKey) {
		this.columnKey = columnKey;
	}

	/**
	 * 获取数据列
	 * 
	 * @return
	 */
	public String getColumnKey() {
		return this.columnKey;
	}

	/**
	 * 获取格式化字符串
	 * @return
	 */
	public String getFormat() {
		return format;
	}

	/**
	 * 设置格式化字符串
	 * @param format
	 */
	public void setFormat(String format) {
		this.format = format;
	}

	/**
	 * 获取时分秒Format
	 * @return
	 */
	public String getDateTimeFormat() {
		return dateTimeFormat;
	}

	/**
	 * 设置时分秒Format
	 * @param dateTimeFormat
	 */
	public void setDateTimeFormat(String dateTimeFormat) {
		this.dateTimeFormat = dateTimeFormat;
	}

	/**
	 * 获取日期格式化字符串
	 * @return
	 */
	public String getDateFormat() {
		return dateFormat;
	}

	/**
	 * 设置日期格式化字符串
	 * @param dateFormat
	 */
	public void setDateFormat(String dateFormat) {
		this.dateFormat = dateFormat;
	}

	/**
	 * 获取默认值表达式
	 * @return
	 */
	public String getDefaultFormulaValue() {
		return defaultFormulaValue;
	}

	/**
	 * 设置默认值表达式
	 * @param defaultFormulaValue
	 */
	public void setDefaultFormulaValue(String defaultFormulaValue) {
		this.defaultFormulaValue = defaultFormulaValue;
	}

	/**
	 * 是否可见
	 * @return
	 */
	public String isVisible() {
		return visible;
	}

	/**
	 * 设置是否可见
	 * @param visible
	 */
	public void setVisible(String visible) {
		this.visible = visible;
	}

	/**
	 * 设置列控件类型
	 * 
	 * @param columnType
	 */
	public void setColumnType(int columnType) {
		this.columnType = columnType;
	}

	/**
	 * 获取列控件类型
	 * 
	 * @return
	 */
	public int getColumnType() {
		return this.columnType;
	}

	/**
	 * 获取是否树列
	 * 
	 * @return
	 */
	public boolean isTree() {
		return tree;
	}

	/**
	 * 设置是否树列
	 * 
	 * @param tree
	 */
	public void setTree(boolean tree) {
		this.tree = tree;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {

	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaGanttColumn newObject = new MetaGanttColumn();
		newObject.setKey(this.key);
		newObject.setCaption(this.caption);
		newObject.setColumnKey(this.columnKey);
		newObject.setColumnType(this.columnType);
		newObject.setTree(this.tree);
		newObject.setFormat(this.format);
		newObject.setFormat(this.dateFormat);
		newObject.setDateTimeFormat(this.dateTimeFormat);
		newObject.setVisible(this.visible);
		newObject.setWidth(this.width);
		newObject.setDefaultFormulaValue(this.defaultFormulaValue);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGanttColumn();
	}

	@Override
    public boolean needPreLoad() {
        return false;
    }
}
