package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.WebBrowserSourceType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

/**
 * 根据DefaultValue或DefaultFormulaValue确定浏览器地址，浏览器控件不绑定数据源字段
 * @author zhufw
 *
 */
public class MetaWebBrowser extends MetaComponent {
	
	/** URL类型时，可定义的前缀，数据为相对路径*/
	private String urlPrefix = "";
	/** 来源类型：URL类型及HTML类型*/
	private Integer sourceType = WebBrowserSourceType.URL;

	public void setUrlPrefix(String urlPrefix) {
		this.urlPrefix = urlPrefix;
	}
	
	public String getUrlPrefix() {
		return urlPrefix;
	}
	
	public void setSourceType(Integer sourceType) {
		this.sourceType = sourceType;
	}
	
	public Integer getSourceType() {
		return sourceType;
	}
	
	public MetaWebBrowser() {
		super();
	}
	
	@Override
	public int getControlType() {
		return ControlType.WEBBROWSER;
	}

	public static final String TAG_NAME = ControlType.STR_WEBBROWSER;
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaWebBrowser newObject = (MetaWebBrowser)super.clone();
		newObject.setUrlPrefix(urlPrefix);
		newObject.setSourceType(sourceType);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaWebBrowser();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}
	
	@Override
	public boolean receiveFocus() {
		return false;
	}

}
