package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaUploadButtonProperties;

public class MetaUploadButton extends MetaComponent {
	private MetaUploadButtonProperties properties = new MetaUploadButtonProperties();
	public MetaUploadButton() {
		super();
	}
	
	@Override
	public int getControlType() {
		return ControlType.UPLOADBUTTON;
	}
	
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaUploadButtonProperties) properties;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return this.properties;
	}

	public static final String TAG_NAME = ControlType.STR_UPLOADBUTTON;
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaUploadButton();
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		MetaUploadButton newObject = (MetaUploadButton) super.clone();
		newObject.setProperties(properties == null ? null : (MetaUploadButtonProperties) properties.clone());
		return newObject;
	}




	/** 
	 * 取得上传文件的大小，-1表示无限制
	 * @return 文件大小
	 * */
	public Integer getMaxSize() {
		return properties.getMaxSize();
	}

	
	/** 
	 * 设置上传文件的大小， -1表示无限制
	 * @param maxSize 文件大小
	 * */
	public void setMaxSize(Integer maxSize) {
		this.properties.setMaxSize(maxSize);
	}

	
	/**
	 * 取得允许的文件类型
	 * @return 允许的文件类型
	 */
	public String getAllowedTypes() {
		return this.properties.getAllowedTypes();
	}

	/**
	 * 设置允许的文件类型
	 * @param allowedTypes 允许的文件类型
	 */
	public void setAllowedTypes(String allowedTypes) {
		this.properties.setAllowedTypes(allowedTypes);
	}

	/**
	 * 设置是否覆盖同名文件
	 * @param deleteOld 是否覆盖同名文件
	 */
	public void setCover(Boolean deleteOld) {
		this.properties.setDeleteOld(deleteOld);
	}
	
	/**
	 * 获取是否覆盖同名文件
	 * @return 是否覆盖同名文件
	 */
	public Boolean isDeleteOld() {
		return this.properties.isDeleteOld();
	}
	
	/**
	 * 设置是否多文件上传
	 * @param isMultiFile 是否多文件上传
	 */
	public void setMultiFile(Boolean isMultiFile) {
		this.properties.setMultiFile(isMultiFile);
	}
	
	
	/**
	 * 获取是否多文件上传
	 * @return 是否多文件上传
	 */
	public Boolean isMultiFile() {
		return this.properties.isMultiFile();
	}
	
	
	/**
	 * 设置后台上传完成事件
	 * @param backFinishEvent 后台上传完成事件
	 */
	public void setPostProcess(String backFinishEvent) {
		this.properties.setPostProcess(backFinishEvent);
	}
	
	
	/**
	 * 获取后台上传完成事件
	 * @return 后台上传完成事件
	 */
	public String getPostProcess() {
		return this.properties.getPostProcess();
	}
	
	
	/**
	 * 设置前台上传完成事件
	 * @param frontFinishEvent 前台上传完成事件
	 */
	public void setFinishEvent(MetaBaseScript frontFinishEvent) {
		this.properties.setFinishEvent(frontFinishEvent);
	}
	
	
	/**
	 * 获取前台上传完成事件
	 * @return 前台上传完成事件
	 */
	public MetaBaseScript getFinishEvent() {
		return this.properties.getFinishEvent();
	}


}
