package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDropdownItemCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSplitButtonProperties;

public class MetaSplitButton extends MetaComponent {
	private MetaSplitButtonProperties properties = new MetaSplitButtonProperties();
	public MetaSplitButton() {
		super();
	}
	
	@Override
	public int getControlType() {
		return ControlType.SPLITBUTTON;
	}
	
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaSplitButtonProperties) properties;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return properties;
	}

	public static final String TAG_NAME = ControlType.STR_SPLITBUTTON;
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaSplitButton newObject = (MetaSplitButton)super.clone();
		newObject.setProperties(properties == null ? null : (MetaSplitButtonProperties)properties.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSplitButton();
	}
	/**
	 * 设置下拉项集合
	 * @param itemCollection 下拉项集合
	 */
	public void setItemCollection(MetaDropdownItemCollection itemCollection) {
		this.properties.setItemCollection(itemCollection);;
	}
	
	/**
	 * 取得下拉项集合
	 * @return 下拉项集合
	 */
	public MetaDropdownItemCollection getItemCollection() {
		return this.properties.getItemCollection();
	}
	/**
	 * 设置点击事件
	 * @param onClick 点击事件
	 */
	public void setOnClick(MetaBaseScript onClick) {
		this.properties.setOnClick(onClick);;
	}
	
	/**
	 * 取得点击事件
	 * @return 点击事件
	 */
	public MetaBaseScript getOnClick() {
		return this.properties.getOnClick();
	}

	/**
	 * 设置图标
	 * @param icon 图标
	 */
	public void setIcon(String icon) {
		this.properties.setIcon(icon);
	}
	
	/**
	 * 取得图标
	 * @return 图标
	 */
	public String getIcon() {
		return this.properties.getIcon();
	}
}
