package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaPasswordEditorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextEditorProperties;

public class MetaPasswordEditor extends MetaTextEditor {
	
	public MetaPasswordEditor() {
		super();
	}

	/**
	 * 获取是否使用自定义安全软键盘
	 *
	 * @return 是否使用自定义安全软键盘
	 */
	public Boolean isSafeInput() {
		return getProperties().isSafeInput();
	}

	/**
	 * 设置是否使用自定义安全软键盘
	 *
	 * @param safeInput 是否使用自定义安全软键盘
	 */
	public void setSafeInput(Boolean safeInput) {
		getProperties().setSafeInput(safeInput);
	}

	/**
	 * 获取是否显示切换文本样式（密码或明文）按钮
	 *
	 * @return 是否显示切换文本样式（密码或明文）按钮
	 */
	public Boolean isShowSwitchIcon() {
		return getProperties().isShowSwitchIcon();
	}

	/**
	 * 设置是否显示切换文本样式（密码或明文）按钮
	 *
	 * @param showSwitchIcon 是否显示切换文本样式（密码或明文）按钮
	 */
	public void setShowSwitchIcon(Boolean showSwitchIcon) {
		getProperties().setShowSwitchIcon(showSwitchIcon);
	}

	/**
	 * 获取样式
	 *
	 * @return 样式
	 */
	public Integer getStyle() {
		return getProperties().getStyle();
	}

	/**
	 * 设置样式
	 *
	 * @param style 样式
	 */
	public void setStyle(Integer style) {
		getProperties().setStyle(style);
	}

	/**
	 * 获取初始是否显示明文
	 *
	 * @return 初始是否显示明文
	 */
	public Boolean isShowPlainText() {
		return getProperties().isShowPlainText();
	}

	/**
	 * 设置初始是否显示明文
	 *
	 * @param showPlainText 初始是否显示明文
	 */
	public void setShowPlainText(Boolean showPlainText) {
		getProperties().setShowPlainText(showPlainText);
	}

	/**
	 * 获取方框和下划线样式的间距
	 *
	 * @return 方框和下划线样式的间距
	 */
	public DefSize getSpacing() {
		return getProperties().getSpacing();
	}

	/**
	 * 设置方框和下划线样式的间距
	 *
	 * @param spacing 方框和下划线样式的间距
	 */
	public void setSpacing(DefSize spacing) {
		getProperties().setSpacing(spacing);
	}

	@Override
	public int getControlType() {
		return ControlType.PASSWORDEDITOR;
	}

	public static final String TAG_NAME = ControlType.STR_PASSWORDEDITOR;
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public MetaPasswordEditor newInstance() {
		return new MetaPasswordEditor();
	}

	@Override
	public MetaPasswordEditor clone() {
		MetaPasswordEditor newObject = (MetaPasswordEditor) super.clone();
		newObject.setProperties(properties == null ? null : getProperties().clone());
		return newObject;
	}

	@Override
	public MetaPasswordEditorProperties getProperties() {
		return (MetaPasswordEditorProperties) properties;
	}

	/**
	 * 设置属性对象
	 *
	 * @param properties 属性对象
	 */
	@Override
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaPasswordEditorProperties) properties;
	}

	@Override
	public MetaTextEditorProperties newProperties() {
		return new MetaPasswordEditorProperties();
	}
}