package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaGridDesignerProperties;

public class MetaGridDesigner extends MetaComponent {
	private MetaGridDesignerProperties properties = new MetaGridDesignerProperties();
	public MetaGridDesigner() {
		super();
	}
	
	@Override
	public int getControlType() {
		return ControlType.GRIDDESIGNER;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return properties;
	}

	public static final String TAG_NAME = ControlType.STR_GRIDDESIGNER;
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaGridDesigner newObj = (MetaGridDesigner)super.clone();
		newObj.properties = properties == null ? null : (MetaGridDesignerProperties)properties.clone();
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGridDesigner();
	}

}
