package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDropdownButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDropdownItemCollection;

public class MetaDropdownButton extends MetaComponent {

	public static final String TAG_NAME = ControlType.STR_DROPDOWNBUTTON;
	
	private MetaDropdownButtonProperties properties = new MetaDropdownButtonProperties();
	public MetaDropdownButton() {
		super();
 	}
	
	@Override
	public int getControlType() {
		return ControlType.DROPDOWNBUTTON;
	}
	
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaDropdownButtonProperties) properties;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return properties;
	}
	
	/**
	 * 设置图标
	 * @param icon 图标
	 */
	public void setIcon(String icon) {
		this.properties.setIcon(icon);
	}
	
	/**
	 * 取得图标
	 * @return 图标
	 */
	public String getIcon() {
		return this.properties.getIcon();
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaDropdownButton newObject = (MetaDropdownButton)super.clone();
		newObject.setProperties(properties == null ? null : (MetaDropdownButtonProperties)properties.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDropdownButton();
	}
	
	/**
	 * 设置下拉项集合
	 * @param itemCollection 下拉项集合
	 */
	public void setItemCollection(MetaDropdownItemCollection itemCollection) {
		this.properties.setItemCollection(itemCollection);;
	}
	
	/**
	 * 取得下拉项集合
	 * @return 下拉项集合
	 */
	public MetaDropdownItemCollection getItemCollection() {
		return this.properties.getItemCollection();
	}
	
	public MetaBaseScript getOnClick() {
		return this.properties.getOnClick();
	}

	public void setOnClick(MetaBaseScript onClick) {
		this.properties.setOnClick(onClick);;
	}
}
