package com.bokesoft.yigo.meta.form.component.bar;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

/**
 * MetaTreeMenuBar定义命令视图的元数据，包括其样式、命令来源和定制标记。
 * 命令视图的样式见{@link com.bokesoft.yigo.common.def.TreeMenuBarType}；
 * 命令的来源一般是来源于系统中的入口定义，也可以指向其它入口定义，此时来源定义需要指向命名的入口定义。
 * 定制标记在样式取值为“定制”时用来区分具体实现。
 * @author 王元和
 */
public class MetaTreeMenuBar extends MetaComponent {
	/** 样式类型，参见{@link com.bokesoft.yigo.common.def.TreeMenuBarType} */
	private Integer type = -1;
	/** 命令来源 */
	private String source = "";
	/** 定制标记 */
	private String tag = "";
	/** 是否默认菜单 */
	private Boolean isDefault = false;

	/** 树节点形菜单 */
	public static final int TREEMENU_TYPE_TREEMENU = 1;
	public static final int TREEMENU_TYPE_LISTTREEMENU = 2;
	/** 手风琴菜单 */
	public static final int TREEMENU_TYPE_ACCORDIONMENU = 3;
	private Integer menuType = TREEMENU_TYPE_TREEMENU;
	/** 菜单项集合 */
	private MetaTreeMenuItemCollection itemCollection = null;
	
	public MetaTreeMenuBar() {
		super();
	}
	
	@Override
	public int getControlType() {
		return ControlType.TREEMENUBAR;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = ControlType.STR_TREEMENUBAR;
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaTreeMenuItemCollection.TAG_NAME.equals(tagName) ) {
			itemCollection = new MetaTreeMenuItemCollection();
			resultMetaObject = itemCollection;
		}
		return resultMetaObject;
	}

	/**
	 * 设置菜单显示的样式
	 * @return 菜单显示的样式
	 */
	public Integer getMenuType() {
		return menuType;
	}

	/**
	 * 获取树形菜单的样式
	 * @param menuType 树形菜单的样式 
	 */
	public void setMenuType(Integer menuType) {
		this.menuType = menuType;
	}
	
	@Override
	public boolean receiveFocus() {
		return false;
	}

	/** 
	 * 设置样式
	 * @param type 样式，取值为{@link com.bokesoft.yigo.common.def.TreeMenuBarType}
	 */
	public void setType(Integer type) {
		this.type = type;
	}
	
	/**
	 * 取得样式
	 * @return 样式，结果为{@link com.bokesoft.yigo.common.def.TreeMenuBarType}
	 */
	public Integer getType() {
		return this.type;
	}
	
	/**
	 * 设置命令来源
	 * @param source 集合来源
	 */
	public void setSource(String source) {
		this.source = source;
	}
	
	/**
	 * 取得命令来源
	 * @return 命令来源
	 */
	public String getSource() {
		return this.source;
	}
	
	/**
	 * 设置定制标记
	 * @param tag 定制标记
	 */
	public void setTag(String tag) {
		this.tag = tag;
	}
	
	/**
	 * 取得定制标记
	 * @return 定制标记
	 */
	public String getTag() {
		return this.tag;
	}
	
	public void setIsDefault(Boolean isDefault) {
		this.isDefault = isDefault;
	}
	
	public Boolean getIsDefault() {
		return this.isDefault;
	}
	
	public void setItemCollection(MetaTreeMenuItemCollection itemCollection) {
		this.itemCollection = itemCollection;
	}
	
	public MetaTreeMenuItemCollection getItemCollection() {
		return this.itemCollection;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaTreeMenuBar newObject = (MetaTreeMenuBar)super.clone();
		newObject.setType(type);
		newObject.setSource(source);
		newObject.setTag(tag);
		newObject.setIsDefault(isDefault);
		newObject.setItemCollection(itemCollection == null ? null : (MetaTreeMenuItemCollection)itemCollection.clone());
		newObject.setMenuType(menuType);
		return newObject;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTreeMenuBar();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}
}
