package com.bokesoft.yigo.meta.form.component.bar;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

/**
 * MetaStatusBar定义状态栏的元数据描述，状态栏中的元数据，主要用来描述状态栏中的区域划分以区域的属性。 其中区域的集合在
 * {@link MetaAreaCollection}定义，其包含了多个{@link MetaArea}
 * 
 * @author 王元和
 *
 */
public class MetaStatusBar extends MetaComponent {
	private MetaAreaCollection areaCollection = null;

	public MetaStatusBar() {
		super();
	}

	@Override
	public int getControlType() {
		return ControlType.STATUSBAR;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = ControlType.STR_STATUSBAR;

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaAreaCollection.TAG_NAME.equals(tagName)) {
			areaCollection = new MetaAreaCollection();
			resultMetaObject = areaCollection;
		} else {
			resultMetaObject = super.createChildMetaObject(env, doc, node,
					tagName, flag, runType);
		}
		return resultMetaObject;
	}

	/**
	 * 设置区域集合
	 * 
	 * @param areaCollection
	 *            区域集合
	 */
	public void setAreaCollection(MetaAreaCollection areaCollection) {
		this.areaCollection = areaCollection;
	}

	/**
	 * 取得区域集合
	 * 
	 * @return 区域集合
	 */
	public MetaAreaCollection getAreaCollection() {
		return this.areaCollection;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaStatusBar newObject = (MetaStatusBar) super.clone();
		newObject.setAreaCollection(areaCollection == null ? null : (MetaAreaCollection) areaCollection.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaStatusBar();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}
	
	@Override
	public boolean receiveFocus() {
		return false;
	}
}
