package com.bokesoft.yigo.meta.form;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaVariant extends AbstractMetaObject {
	
	public static final String TAG_NAME = "Variant";
	
	/**
	 * 依赖
	 */
	private String depended = "";
	
	private List<String> depends = null;
	
	/**
	 * 获取依赖
	 * @return
	 */
	public String getDepended() {
		return depended;
	}

	/**
	 * 设置依赖
	 * @param depended
	 */
	public void setDepended(String depended) {
		this.depended = depended;
		if( depended != null && !depended.isEmpty() ) {
			depends = Arrays.asList(depended.split(","));
		}
	}
	
	/**
	 * 获取变体依赖集合
	 * @return
	 */
	public List<String> getDepends() {
		return depends;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaVariant variant = (MetaVariant) newInstance();
		variant.setDepended(depended);
		return variant;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaVariant();
	}
	
	@Override
	public JSONObject toJSON() throws SerializationException {
		JSONObject o = new JSONObject();
		JSONArray arr = new JSONArray();
		if( depends != null ) {
			for( String d : depends ) {
				arr.put(d);
			}
		}
		o.put("dependency", arr);
		return o;
	}

}
