package com.bokesoft.yigo.meta.form;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaUICalcExpr定义界面全局的计算表达式
 * @author wangyh
 *
 */
public class MetaUICalcExpr extends AbstractMetaObject {
	/** 描述 */
	private String description = "";
	/** 计算表达式内容 */
	private String defaultFormulaValue = "";
	/** 目标 */
	private String target = "";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	public static final String TAG_NAME = "UICalcExpr";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 设置描述
	 * @param description 描述
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * 取得描述
	 * @return 描述
	 */
	public String getDescription() {
		return this.description;
	}
	
	/**
	 * 设置表达式内容
	 * @param defaultFormulaValue 表达式内容
	 */
	public void setDefaultFormulaValue(String defaultFormulaValue) {
		this.defaultFormulaValue = defaultFormulaValue;
	}
	
	/**
	 * 取得表达式内容
	 * @return 表达式内容
	 */
	public String getDefaultFormulaValue() {
		return this.defaultFormulaValue;
	}
	
	/**
	 * 设置目标组件
	 * @param target 目标组件标识，为空或者为表格的标识
	 */
	public void setTarget(String target) {
		this.target = target;
	}
	
	/**
	 * 取得目标组件
	 * @return 目标组件标识，为空或者为表格的标识
	 */
	public String getTarget() {
		return this.target;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaUICalcExpr newObject = (MetaUICalcExpr)newInstance();
		newObject.setDescription(description);
		newObject.setDefaultFormulaValue(defaultFormulaValue);
		newObject.setTarget(target);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaUICalcExpr();
	}

}
