package com.bokesoft.yigo.meta.form;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaComponentFactory;

public class MetaNavigationBarItem extends KeyPairMetaObject {

	public static final String TAG_NAME = "BarItem";
	private String key = "";
	private String caption = "";
	private Integer location = -1;
	private MetaComponent root;

	@Override
	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getCaption() {
		return caption;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public Integer getLocation() {
		return location;
	}

	public void setLocation(Integer location) {
		this.location = location;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { root });
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		MetaComponent control = MetaComponentFactory.getInstance().newComponent(tagName);
		if (control != null) {
			control.preProcessMetaObject(env, doc, node, flag, runType);
			root = control;
		}
		return control;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaNavigationBarItem newObj = (MetaNavigationBarItem)newInstance();
		newObj.setKey(key);
		newObj.setCaption(caption);
		newObj.setLocation(location);
		newObj.setRoot(root == null ? null : (MetaComponent)root.clone());
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaNavigationBarItem();
	}
	
	public MetaComponent getRoot() {
		return root;
	}
	
	public void setRoot(MetaComponent root) {
		this.root = root;
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if(root != null){
			root.doPostProcess(flag, callback);
		}
	}
}
