package com.bokesoft.yigo.meta.flatcanvas.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import org.w3c.dom.Element;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.flatcanvas.common.AttributeItem;
import com.bokesoft.yigo.meta.flatcanvas.convertor.IContentHandler;
import com.bokesoft.yigo.meta.flatcanvas.convertor.INode;
import com.bokesoft.yigo.meta.flatcanvas.struct.FCAttrNames;
import com.bokesoft.yigo.meta.flatcanvas.struct.FCStandforType;

/**
 * 平面图的数据绑定
 * 
 * @author chenbinbin
 *
 */
public class MetaFCDataBind extends AbstractMetaFCObject {
	
	public static final String TAG_NAME = "DataBind";
	
	public static final List<String> DATA_ATTRS = Arrays.asList(			
			FCAttrNames.ATTR_Data_Standfor, FCAttrNames.ATTR_Data_TableKey
				,FCAttrNames.ATTR_Data_SignKey, FCAttrNames.ATTR_Data_SignValue
				//,FCAttrNames.ATTR_Data_AmountKey, FCAttrNames.ATTR_Data_MaxAmount
			);
	
	/**
	 * 设置关联的TableKey
	 * 
	 * @param tableKey 关联数据源表标识
	 */
	public void setTableKey(String tableKey) {
		set(FCAttrNames.ATTR_Data_TableKey, tableKey);
	}
	
	/**
	 * 设置区域 数量 关联字段标识
	 * 
	 * @param amountKey 关联的数量字段标识
	 */
	public void setAmountKey(String amountKey) {
		//set(FCAttrNames.ATTR_Data_AmountKey, amountKey);
	}
	
	/**
	 * 获取区域 数量 关联字段标识
	 * 
	 * @return 关联的数量字段标识
	 */
	public String getAmountKey() {
		//return get(FCAttrNames.ATTR_Data_AmountKey);
		return "";
	}
	
	/**
	 * 设置区域存储最大量
	 * 
	 * @param maxAmount 区域存储最大量
	 */
	public void setMaxAmount(String maxAmount) {
		//set(FCAttrNames.ATTR_Data_MaxAmount, maxAmount);
	}
	
	/**
	 * 获取区域存储数量最大值
	 * 
	 * @return 区域存储最大量
	 */
	public String getMaxAmount() {
		//return get(FCAttrNames.ATTR_Data_MaxAmount);
		return "";
	}
	
	/**
	 * 是否已经设置TableKey
	 * 
	 * @return 是否已经设置TableKey
	 */
	public boolean hasCurTableKey() {
		return attributeMap.containsKey(FCAttrNames.ATTR_Data_TableKey) && !StringUtil.isBlankOrNull(get(FCAttrNames.ATTR_Data_TableKey));
	}
	
	/**
	 * 获取当前区域TableKey
	 * 
	 * @return 当前区域TableKey
	 */
	public String getCurTableKey() {
		return TypeConvertor.toString(get(FCAttrNames.ATTR_Data_TableKey));
	}
	
	/**
	 * 当前区域是否在设置了TableKey的区域中
	 * 
	 * @return 当前区域是否在设置了TableKey的区域中
	 */
	public boolean isTableSection() {
		return !StringUtil.isBlankOrNull(get(FCAttrNames.ATTR_Data_TableKey));
	}
	
	/**
	 * 设置当前表区域所代表的数据类型
	 * 
	 * @param standfor 区域所代表的数据类型
	 * 
	 * @see FCStandforType
	 */
	public void getStandfor(String standfor) {
		set(FCAttrNames.ATTR_Data_Standfor, standfor);
	}
	
	/**
	 * 获取当前表区域所代表的数据类型
	 * 
	 * @return 区域所代表的数据类型
	 * 
	 * @see FCStandforType
	 */
	public String getStandfor() {
		return get(FCAttrNames.ATTR_Data_Standfor);
	}
	
	/**
	 * 获取分组标志key
	 * 
	 * @return 分组标志key
	 */
	public String getSignKey() {
		return get(FCAttrNames.ATTR_Data_SignKey);
	}
	
	/**
	 * 获取分组标志值
	 * @return 分组标志值
	 */
	public String getSignValue() {
		return get(FCAttrNames.ATTR_Data_SignValue);
	}
	
	/**
	 * 当前区域是否未设置数据类型
	 * 
	 * @return 是否未设置数据类型
	 * 
	 * @see FCStandforType
	 */
	public boolean isStandforNone() {
		String standfor = getStandfor();
		return FCStandforType.SF_None.equals(standfor) || "".equals(standfor) ;
	}
	
	private boolean isSectionInTable = false;
	
	/**
	 * 设置当前区域是否存在于表区域中
	 * 
	 * @param isSectionInTable 区域存是否在于表区域中
	 */
	public void setIsSectionInTable(boolean isSectionInTable) {
		this.isSectionInTable = isSectionInTable;
	}
	
	/**
	 * 判断属性key是否是表区域中的属性
	 * 
	 * @param attrName 属性名称
	 * 
	 * @return 属性key是否是表区域中的属性
	 */
	private boolean isTableSectionAttr(String attrName) {
		return FCAttrNames.ATTR_Data_TableKey.equals(attrName) ||
				FCAttrNames.ATTR_Data_Standfor.equals(attrName) ||
				FCAttrNames.ATTR_Data_SignKey.equals(attrName) ||
				FCAttrNames.ATTR_Data_AmountKey.equals(attrName);
	}
	
	/**
	 * 更新属性
	 */
	public void updateAttrs() {
		List<String> keys = getPropItemKeys();
		if (isSectionInTable) {
			for	(String key: keys) {
				if (isTableSectionAttr(key)) {
					attrs.remove(key);
				} else {
					this.set(key, this.get(key));
				}
			}
		} else {
			for	(String key: keys) {
				if (!isTableSectionAttr(key)) {
					attrs.remove(key);
				} else {
					this.set(key, this.get(key));
				}
			}
		}
	}
	
	@Override
	public List<String> getPropItemKeys() {
		return DATA_ATTRS;
	}
	
	@Override
	public List<AttributeItem> getPropItems() {
		updateAttrs();
		List<AttributeItem> items = new ArrayList<AttributeItem>();
		Set<Entry<String, AttributeItem>> set = attrs.entrySet();
		for (Map.Entry<String, AttributeItem> entry: set) {
			items.add(entry.getValue());
		}
		return items;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	protected void loadChild(Element elem) {
		
	}
	
	@Override
	protected boolean isCollection() {
		return false;
	}

	@Override
	protected boolean saveChild(IContentHandler saveHandler, INode node) {
		return false;
	}
}
