package com.bokesoft.yigo.meta.flatcanvas.common;

import com.bokesoft.yigo.common.util.TypeConvertor;

public class ValueProperty<T> {
	
	private T value = null;
	
	private IChangeListener changeListener = null;
	
	public ValueProperty() {
		
	}
	
	public void setChangeListener(IChangeListener changeListener) {
		this.changeListener = changeListener;
	}
	
	public void set(T value) {
		if (this.value == value) {
			return;
		}
		
		boolean isChanged = !TypeConvertor.toString(value).equals(TypeConvertor.toString(this.value));
		this.value = value;
		if (isChanged && changeListener != null) {
			changeListener.fireChanged();
		}
	}
	
	public T get() {
		return this.value;
	}
}
