package com.bokesoft.yigo.meta.factory;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;

import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.common.util.LockUtil;
import com.bokesoft.yes.common.util.ReflectUtil;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.AbstractLoad;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.app.MetaAppDefinitionLoad;
import com.bokesoft.yes.meta.persist.dom.app.MetaClientAppDefLoad;
import com.bokesoft.yes.meta.persist.dom.archive.MetaArchiveLoad;
import com.bokesoft.yes.meta.persist.dom.archive.MetaArchiveSettingLoad;
import com.bokesoft.yes.meta.persist.dom.biz.MetaBizExtendScanLoad;
import com.bokesoft.yes.meta.persist.dom.bpm.action.extend.MetaExConfigurationLoad;
import com.bokesoft.yes.meta.persist.dom.bpm.action.monitor.MetaBPMMonitorLoad;
import com.bokesoft.yes.meta.persist.dom.bpm.action.perm.extend.MetaPermConfigurationLoad;
import com.bokesoft.yes.meta.persist.dom.charging.MetaChargingObjectLoad;
import com.bokesoft.yes.meta.persist.dom.charging.MetaChargingObjectProfile;
import com.bokesoft.yes.meta.persist.dom.charging.MetaChargingRuleGroupLoad;
import com.bokesoft.yes.meta.persist.dom.charging.MetaChargingRuleGroupProfile;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaCommonDefLoad;
import com.bokesoft.yes.meta.persist.dom.custom.MetaCustomObjectScanLoad;
import com.bokesoft.yes.meta.persist.dom.datamigration.MetaDataMigrationLoad;
import com.bokesoft.yes.meta.persist.dom.dataobject.MetaDataObjectLoad;
import com.bokesoft.yes.meta.persist.dom.enhance.MetaEnhanceLoad;
import com.bokesoft.yes.meta.persist.dom.entry.MetaEntryLoad;
import com.bokesoft.yes.meta.persist.dom.excel.MetaExcelTemplateLoad;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormLoad;
import com.bokesoft.yes.meta.persist.dom.iosetting.MetaIOSettingLoad;
import com.bokesoft.yes.meta.persist.dom.mapping.MetaMappingLoad;
import com.bokesoft.yes.meta.persist.dom.mapping.MetaMappingScanLoad;
import com.bokesoft.yes.meta.persist.dom.midsetting.MetaMidSettingLoad;
import com.bokesoft.yes.meta.persist.dom.mobiledef.MetaMobileDefLoad;
import com.bokesoft.yes.meta.persist.dom.offlinedef.MetaOfflineDefLoad;
import com.bokesoft.yes.meta.persist.dom.paratable.MetaParaTableLoad;
import com.bokesoft.yes.meta.persist.dom.permission.custom.MetaCustomPermissionLoad;
import com.bokesoft.yes.meta.persist.dom.permission.filter.MetaPermissionFilterLoad;
import com.bokesoft.yes.meta.persist.dom.report.MetaReportLoad;
import com.bokesoft.yes.meta.persist.dom.rights.MetaRightsDefinitionLoad;
import com.bokesoft.yes.meta.persist.dom.search.MetaElasticSearchLoad;
import com.bokesoft.yes.meta.persist.dom.setting.MetaSettingLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaDataMapI18NScanLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaDataMapScanLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaDataMigrationI18NScanLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaDataMigrationScanLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaDataObjectI18NScanLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaDataObjectScanLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaDiffScanLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaExcelFileTemplateScanLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaExcelTemplateScanLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaFlatCanvasScanLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaFormI18NScanLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaFormScanLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaI18NScanLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaJarScanLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaParaTableScanLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaParameterScanLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaProcessI18NScanLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaProjectDataMapI18NScanLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaProjectDataMigrationI18NScanLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaProjectI18NScanLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaProjectLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaReportScanLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaSolutionLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaUserSVGFileScanLoad;
import com.bokesoft.yes.meta.persist.dom.taskflow.MetaTaskFlowLoad;
import com.bokesoft.yes.meta.process.MetaDataObjectTemplateProcess;
import com.bokesoft.yes.meta.process.MetaFormExtendProcess;
import com.bokesoft.yes.meta.process.MetaFormFrameProcess;
import com.bokesoft.yes.meta.process.MetaFormTemplateProcess;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.def.ComboBoxSourceType;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DataObjectPrimaryType;
import com.bokesoft.yigo.common.def.DataObjectSecondaryType;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.common.def.OperationState;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.common.def.SystemPrefix;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.app.MetaApp;
import com.bokesoft.yigo.meta.app.MetaAppDefiniton;
import com.bokesoft.yigo.meta.app.MetaApps;
import com.bokesoft.yigo.meta.app.MetaClientAppDef;
import com.bokesoft.yigo.meta.app.MetaRefProject;
import com.bokesoft.yigo.meta.archive.MetaArchive;
import com.bokesoft.yigo.meta.archive.MetaArchiveSetting;
import com.bokesoft.yigo.meta.base.AbstractCompositeObject;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.IMetaResourceFilter;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.base.MetaGenericProfile;
import com.bokesoft.yigo.meta.biz.MetaBizExtend;
import com.bokesoft.yigo.meta.bpm.process.MetaBPMReferenceScanLoad;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.ProcessDefinitionProfile;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.extend.MetaExConfiguration;
import com.bokesoft.yigo.meta.bpm.process.monitor.MetaBPMMonitorSetting;
import com.bokesoft.yigo.meta.bpm.process.perm.extend.MetaPermConfiguration;
import com.bokesoft.yigo.meta.bpm.total.MetaBPM;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessDeployInfo;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessMap;
import com.bokesoft.yigo.meta.charging.MetaChargingObject;
import com.bokesoft.yigo.meta.charging.MetaChargingObjectList;
import com.bokesoft.yigo.meta.charging.MetaChargingRuleGroup;
import com.bokesoft.yigo.meta.charging.MetaChargingRuleGroupList;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.commondef.MetaOperation;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconFontItem;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconFontItemCollection;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconFontSource;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconFontSourceCollection;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconSourceCollection;
import com.bokesoft.yigo.meta.dataelement.MetaDataElement;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementCollection;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementDef;
import com.bokesoft.yigo.meta.datamap.MetaDataMapList;
import com.bokesoft.yigo.meta.datamap.MetaDataMapProfile;
import com.bokesoft.yigo.meta.datamap.MetaMap;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationList;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.diff.MetaDiff;
import com.bokesoft.yigo.meta.diff.MetaDiffList;
import com.bokesoft.yigo.meta.diff.MetaDiffProfile;
import com.bokesoft.yigo.meta.diff.load.MetaFormDiffLoad;
import com.bokesoft.yigo.meta.diff.load.MetaMapDiffLoad;
import com.bokesoft.yigo.meta.diff.load.MetaMigrationDiffLoad;
import com.bokesoft.yigo.meta.diff.util.DiffActionManager;
import com.bokesoft.yigo.meta.diff.util.DiffKeyUtil;
import com.bokesoft.yigo.meta.domain.MetaDomainCollection;
import com.bokesoft.yigo.meta.domain.MetaDomainDef;
import com.bokesoft.yigo.meta.enhance.MetaEnhance;
import com.bokesoft.yigo.meta.entry.MetaEntry;
import com.bokesoft.yigo.meta.entry.MetaEntryItem;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateList;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateProfile;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateSubList;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import com.bokesoft.yigo.meta.factory.extend.DefaultFormExtendProcessor;
import com.bokesoft.yigo.meta.factory.extend.IFormExtendProcessor;
import com.bokesoft.yigo.meta.factory.workflow.ProcessSourceFactory;
import com.bokesoft.yigo.meta.factory.workflow.source.IProcessSource;
import com.bokesoft.yigo.meta.flatcanvas.MetaFlatCanvasList;
import com.bokesoft.yigo.meta.flatcanvas.MetaFlatCanvasProfile;
import com.bokesoft.yigo.meta.flatcanvas.node.MetaFCPaper;
import com.bokesoft.yigo.meta.form.MetaBlock;
import com.bokesoft.yigo.meta.form.MetaBody;
import com.bokesoft.yigo.meta.form.MetaExtFormList;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormMergeHandler;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaEmbed;
import com.bokesoft.yigo.meta.form.component.bar.MetaToolBar;
import com.bokesoft.yigo.meta.form.component.container.MetaSubDetail;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaComboBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNumberEditorProperties;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumn;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumnCollection;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRowCollection;
import com.bokesoft.yigo.meta.form.component.grid.dynamic.MetaCellTypeTable;
import com.bokesoft.yigo.meta.form.component.panel.MetaFlexFlowLayoutPanel;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.intf.IMetaSolution;
import com.bokesoft.yigo.meta.iosetting.MetaIOSetting;
import com.bokesoft.yigo.meta.mapping.MetaMapping;
import com.bokesoft.yigo.meta.mapping.MetaMappingList;
import com.bokesoft.yigo.meta.mapping.MetaMappingProfile;
import com.bokesoft.yigo.meta.midsetting.MetaMidSetting;
import com.bokesoft.yigo.meta.mobiledef.MetaMobileDef;
import com.bokesoft.yigo.meta.offlinedef.MetaOfflineDef;
import com.bokesoft.yigo.meta.parameter.MetaParameter;
import com.bokesoft.yigo.meta.paratable.MetaParaTable;
import com.bokesoft.yigo.meta.path.MetaRelationList;
import com.bokesoft.yigo.meta.path.MetaRelationPath;
import com.bokesoft.yigo.meta.path.MetaRelationPathLoad;
import com.bokesoft.yigo.meta.path.MetaRelationProfile;
import com.bokesoft.yigo.meta.path.MetaRelationScanLoad;
import com.bokesoft.yigo.meta.path.MetaSecurityFilter;
import com.bokesoft.yigo.meta.path.MetaSecurityFilterLoad;
import com.bokesoft.yigo.meta.path.check.MetaRelationCheck;
import com.bokesoft.yigo.meta.permission.custom.MetaCustomPermission;
import com.bokesoft.yigo.meta.permission.filter.MetaPermissionFilter;
import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.meta.report.MetaReportList;
import com.bokesoft.yigo.meta.report.MetaReportProfile;
import com.bokesoft.yigo.meta.report.MetaReportSubList;
import com.bokesoft.yigo.meta.rights.MetaRightsDefinition;
import com.bokesoft.yigo.meta.search.MetaElasticSearch;
import com.bokesoft.yigo.meta.setting.MetaFormSetting;
import com.bokesoft.yigo.meta.setting.MetaSetting;
import com.bokesoft.yigo.meta.setting.MetaSimpleSetting;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.meta.solution.MetaProjectCollection;
import com.bokesoft.yigo.meta.solution.MetaProjectProfile;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.meta.strings.MetaStringTable;
import com.bokesoft.yigo.meta.task.MetaTaskProcess;
import com.bokesoft.yigo.meta.task.MetaTaskProcessProfile;
import com.bokesoft.yigo.meta.task.MetaTaskScanLoad;
import com.bokesoft.yigo.meta.task.deploy.MetaTask;
import com.bokesoft.yigo.meta.task.deploy.MetaTaskProcessDeployInfo;
import com.bokesoft.yigo.meta.taskflow.MetaTaskFlow;
import com.bokesoft.yigo.meta.taskflow.MetaTaskFlowList;
import com.bokesoft.yigo.meta.taskflow.MetaTaskFlowProfile;
import com.bokesoft.yigo.meta.taskflow.MetaTaskFlowScanLoad;
import com.bokesoft.yigo.meta.util.MetaUtil;

public class DefaultMetaFactory implements IMetaFactory {

	/** 应用定义 */
	private MetaSolution solution = null;
	/** 应用级公共定义 */
	private MetaCommonDef solutionCommonDef = null;
	/** 应用级域定义 标识(Domain Key)全局唯一 */
	private MetaDomainDef solutionDomainDef = null;
	/** 应用级数据元素定义 标识(DataElement Key)全局唯一 */
	private MetaDataElementDef solutionDataElementDef = null;
	/** 应用级扩展定义 */
	private MetaEnhance solutionEnhance = null;
	/** 移动端定义 */
	private MetaMobileDef solutionMobileDef = null;

	private IMetaResolver primarySolutionResourceResolver = null;
	private HashMap<String, IMetaResolver> projectResolverMap = null;

	/** 表单列表 */
	private MetaFormList formList = null;

	private List<MetaFormProfile> normalFormProfileList = new ArrayList<>();

	/** 数据对象列表 */
	private MetaDataObjectList dataObjectList = null;
	/** 迁移列表 */
	private MetaDataMigrationList migrationList = null;
	/** 数据映射列表 */
	private MetaDataMapList dataMapList = null;
	/** 流程全局定义 */
	private MetaBPM metaBPM = null;
	/** 打印模板列表 */
	private MetaReportList reportList = null;
	/** 关系检查定义列表 */
	private MetaRelationList relationList = null;
	/** 数据集映射定义列表 */
	private MetaMappingList mappingList = null;
	/** 应用安全检查定义 */
	private MetaSecurityFilter solutionFilter = null;
	/** Excel导出模板列表 */
	private MetaExcelTemplateList excelTemplateList = null;
	/** 应用设置 */
	private MetaSetting setting = null;
	/** 中间层应用设置 */
	private MetaMidSetting midSetting = null;
	/** IO设置 */
	private MetaIOSetting IOSetting = null;
	/** ParaTable*/
	private MetaParaTable paraTable = null;
	private MetaParameter parameter = null;
	/** 应用级 i18n 定义 */
	private GlobalI18N globalI18N = null;

	private MetaClientAppDef clientAppDef = null;
	private MetaRightsDefinition rightsDefinition = null;
	/** 归档配置 */
	private MetaArchive archive = null;
	/** 归档数据源设置 */
	private MetaArchiveSetting archiveSetting = null;
	private MetaElasticSearch metaES = null;
	private MetaCellTypeTable cellTypeTable = null;
	/** 拓展配置 */
	private MetaExConfiguration exConfiguration = null;
	/** 外部权限文件 */
	private MetaPermConfiguration permConfiguration = null;

	private MetaTaskFlowList taskFlowList = null;

	/** 流程监控配置 */
	private MetaBPMMonitorSetting bpmMonitorSetting = null;

	/** 业务扩展对象 */
	private MetaBizExtend bizExtend = null;
	/** 检查规则（合并） */
	private MetaRelationCheck relationCheck = null;

	/** 移动多应用所引用的工程描述信息 */
	private MetaAppDefiniton appDefiniton = null;

	/** 平面图形配置目录 */
	private MetaFlatCanvasList flatCanvasList = null;

	/** svg自定义图形 */
	private HashMapIgnoreCase<File> svgUserFileMap = null;
	/** 表单字符串 */
	private Map<String, MetaStringTable> stringTableMap = null;

	/** 流程字符串 */
	private Map<String, MetaStringTable> processStringTableMap = null;

	/** 数据对象字符串 */
	private Map<String, MetaStringTable> dataObjStringTableMap = null;
	/** 自定义权限操作 */
	private MetaCustomPermission customPermission = null;
	/** 服务权限过滤配置 */
	private MetaPermissionFilter permissionFilter = null;
	/** 自定义配置对象 */
	private List<KeyPairMetaObject> customList = null;

	/**
	 * 非主配置 Solution 的 CommondDef 集合, Map 的 Key 为 Solution Key.
	 * 注意: 所有 Solution 的 statusCollection 合并至主 solution commonDef({@link #solutionCommonDef})
	 */
	private HashMap<String, MetaCommonDef> solutionCommmonDefMap = null;
	
	/**
	 * 所有配置 Solution 的 DomainDef 集合, Map 的 Key 为 Solution Key.
	 * 注意: 所有 Solution 的 DomainDef 会合并到 {@link #solutionDomainDef}, 其中的 Domain Key 不能重复
	 */
	private HashMap<String, MetaDomainDef> solutionDomainDefMap = null;
	
	/**
	 * 所有配置 Solution 的 DataElementDef 集合, Map 的 Key 为 Solution Key.
	 * 注意: 所有 Solution 的 DataElementDef 会合并到 {@link #solutionDataElementDef}, 其中的 DataElement Key 不能重复
	 */
	private HashMap<String, MetaDataElementDef> solutionDataElementDefMap = null;

	/** 主 Solution 的 {@link IMetaResolverFactory} */
	private IMetaResolverFactory primaryResolverFactory = null;

	/**
	 * 所有配置 Solution 的 {@link IMetaResolverFactory} 集合, Map 的 Key 为 Solution Key.
	 * 注意: 主 Solution 的 {@link IMetaResolverFactory} 被记录在 {@link #primaryResolverFactory}
	 */
	private HashMap<String, IMetaResolverFactory> resolverFactoryMap = null;
	
	/**
	 * 非主配置 Solution 的 GlobalI18N, Map 的 Key 为 Solution Key.
	 * 注意: 所有 Solution 的 i18n 合并至主 solution ({@link #globalI18N})
	 */
	private HashMap<String, GlobalI18N> solutionI18NMap = null;

	/** jar包存放的目标目录 */
	protected String pluginsPath = null;

	private MetaTask metaTask = null;

	/** 差异列表 */
	private MetaDiffList diffList = null;
	private static List<IReLoadForm> reportFuntions;
	private HashMap<String, String> mapDiffSourceProject = null;
	/** xls格式excel模板 */
	private HashMapIgnoreCase<MetaGenericProfile> excelFileTemplateMap = null;
	/** 移动离线g功能相关定义 */
	private MetaOfflineDef offlineDef = null;
	/** 字体库图标源定义,只加载一次 */
	private MetaIconFontSourceCollection collection;

	private Map<String, MetaSolution> solutionMap;

	/** 扩展表单列表 */
	private MetaExtFormList extFormList = null;
	/** 临时变量，后续可能合并其余CommonDef中非主配置Solution的，合并了主Solution的StatusCollection集合 */
	private HashMap<String, MetaStatusCollection> solutionStatusCollectionMap = null;

	public DefaultMetaFactory(IMetaResolverFactory resolverFactory) {
		this.primaryResolverFactory = resolverFactory;
		this.primarySolutionResourceResolver = resolverFactory.newMetaResolver("");
		projectResolverMap = new HashMap<String, IMetaResolver>();
		formList = new MetaFormList();
		dataObjectList = new MetaDataObjectList();
		migrationList = new MetaDataMigrationList();
		dataMapList = new MetaDataMapList();
		metaBPM = new MetaBPM();
		reportList = new MetaReportList();
		relationList = new MetaRelationList();
		excelTemplateList = new MetaExcelTemplateList();
		cellTypeTable = new MetaCellTypeTable();
		bizExtend = new MetaBizExtend();
		relationCheck = new MetaRelationCheck();
		flatCanvasList = new MetaFlatCanvasList();
		svgUserFileMap = new HashMapIgnoreCase<File>();
		stringTableMap = new HashMap<String, MetaStringTable>();
		processStringTableMap = new HashMap<String, MetaStringTable>();
		dataObjStringTableMap = new HashMap<String, MetaStringTable>();
		mappingList = new MetaMappingList();
		customList = new ArrayList<KeyPairMetaObject>();
		diffList = new MetaDiffList();
		mapDiffSourceProject = new LinkedHashMap<>();
		metaTask = new MetaTask();
		paraTable = new MetaParaTable();
		parameter = new MetaParameter();
		globalI18N = new GlobalI18N();
		taskFlowList = new MetaTaskFlowList();
		excelFileTemplateMap = new HashMapIgnoreCase<>();
		extFormList = new MetaExtFormList();
		solutionCommmonDefMap = new LinkedHashMap<String, MetaCommonDef>();
		resolverFactoryMap = new HashMap<String, IMetaResolverFactory>();
		solutionMap = new HashMap<>();
		solutionStatusCollectionMap = new HashMap<>();
		solutionDomainDefMap = new HashMap<String, MetaDomainDef>();
		solutionDataElementDefMap = new HashMap<String, MetaDataElementDef>();
		solutionI18NMap = new HashMap<String, GlobalI18N>();
	}

	@Override
	public String getSolutionPath() {
		return this.primaryResolverFactory.getSolutionPath();
	}

	/**
	 * 将工程加载重新排序, 差异工程先行加载
	 * @param metaProjectCollection
	 * @return
	 */
	private synchronized List<MetaProjectProfile> sortProjects4DiffFirst(MetaProjectCollection metaProjectCollection) {
		if (metaProjectCollection != null) {
			List<MetaProjectProfile> listProject = new ArrayList<>();
			Iterator<MetaProjectProfile> itMetaProject = metaProjectCollection.iterator();
			MetaProjectProfile metaProjectProfile = null;
			while (itMetaProject.hasNext()) {
				metaProjectProfile = itMetaProject.next();
				if (metaProjectProfile.isDiffProject()) {
					listProject.add(metaProjectProfile);
				}
			}

			itMetaProject = metaProjectCollection.iterator();
			while (itMetaProject.hasNext()) {
				metaProjectProfile = itMetaProject.next();
				if (!listProject.contains(metaProjectProfile)) {
					listProject.add(metaProjectProfile);
				}
			}
			return listProject;
		}
		return null;
	}
	/**
	 * 加载solution.xml
	 * @param resolverFactory
	 * @return
	 * @throws Throwable
	 */
	private MetaSolution loadSolutionProfile(IMetaResolverFactory resolverFactory) throws Throwable {
		MetaSolution tmpSolution = null;
		IMetaResolver solutionResourceResolver = resolverFactory.newMetaResolver("");
		// 加载应用元数据
		MetaSolutionLoad solutionLoad = new MetaSolutionLoad(AppRunType.App);
		solutionLoad.load(solutionResourceResolver, DomMetaConstants.SOLUTION_FILE);
		tmpSolution = (MetaSolution) solutionLoad.getRootMetaObject();
		if (tmpSolution == null) {
			throw new MetaException(MetaException.INVALID_SOLUTION_PATH,
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.InvalidSolutionPath),
							resolverFactory.getSolutionPath()));
		}
		this.solutionMap.put(tmpSolution.getKey(), tmpSolution);
		return tmpSolution;
	}
	/**
	 * 加载主配置
	 * @param resolverFactory
	 * @param tmpSolution
	 * @throws Throwable
	 */
	private void loadPrimarySetting(IMetaResolverFactory resolverFactory, MetaSolution tmpSolution) throws Throwable {

		IMetaResolver solutionResourceResolver = resolverFactory.newMetaResolver("");
		// 加载归档配置
		MetaArchiveLoad ArchiveLoad = new MetaArchiveLoad(AppRunType.App);
		ArchiveLoad.load(solutionResourceResolver, "Archive.xml");
		archive = (MetaArchive) ArchiveLoad.getRootMetaObject();

		MetaArchiveSettingLoad archiveSettingLoad = new MetaArchiveSettingLoad(AppRunType.App);
		archiveSettingLoad.load(solutionResourceResolver, "ArchiveSetting.xml");
		archiveSetting = (MetaArchiveSetting) archiveSettingLoad.getRootMetaObject();

		// 加载拓展配置（参与者、定时任务）
		MetaExConfigurationLoad exConfigurationLoad = new MetaExConfigurationLoad(AppRunType.App);
		exConfigurationLoad.load(solutionResourceResolver, "ExConfiguration.xml");
		exConfiguration = (MetaExConfiguration) exConfigurationLoad.getRootMetaObject();

		// 加载外部权限配置
		MetaPermConfigurationLoad permConfigurationLoad = new MetaPermConfigurationLoad(AppRunType.App);
		permConfigurationLoad.load(solutionResourceResolver, "PermConfiguration.xml");
		permConfiguration = (MetaPermConfiguration) permConfigurationLoad.getRootMetaObject();

		// 流程监控配置
		MetaBPMMonitorLoad bpmMonitorLoad = new MetaBPMMonitorLoad(AppRunType.App);
		bpmMonitorLoad.load(solutionResourceResolver, "BPMMonitorSetting.xml");
		bpmMonitorSetting = (MetaBPMMonitorSetting) bpmMonitorLoad.getRootMetaObject();

		// 加载用户自定义权限操作
		MetaCustomPermissionLoad customLoad = new MetaCustomPermissionLoad(AppRunType.App);
		customLoad.load(solutionResourceResolver, "CustomPermission.xml");
		customPermission = (MetaCustomPermission) customLoad.getRootMetaObject();

		// 加载服务权限过滤配置
		MetaPermissionFilterLoad permissionLoad = new MetaPermissionFilterLoad(AppRunType.App);
		permissionLoad.load(solutionResourceResolver, "PermissionFilter.xml");
		permissionFilter = (MetaPermissionFilter) permissionLoad.getRootMetaObject();
		if (permissionFilter == null)
			permissionFilter = new MetaPermissionFilter();

		// 加载ElasticSearch
		MetaElasticSearchLoad ESLoad = new MetaElasticSearchLoad(AppRunType.App);
		ESLoad.load(solutionResourceResolver, "ElasticSearch.xml");
		metaES = (MetaElasticSearch) ESLoad.getRootMetaObject();

		// 加载全局设置对象
		MetaSettingLoad settingLoad = new MetaSettingLoad(AppRunType.App);
		settingLoad.load(solutionResourceResolver, DomMetaConstants.SETTING_FILE);
		setting = (MetaSetting) settingLoad.getRootMetaObject();

		// 加载中间层应用设置对象
		MetaMidSettingLoad midSettingLoad = new MetaMidSettingLoad(AppRunType.App);
		midSettingLoad.load(solutionResourceResolver, DomMetaConstants.MIDSETTING_FILE);
		midSetting = (MetaMidSetting) midSettingLoad.getRootMetaObject();

		MetaCommonDefLoad load = new MetaCommonDefLoad(AppRunType.App);
		load.load(solutionResourceResolver, DomMetaConstants.COMMON_DEF_FILE);
		solutionCommonDef = (MetaCommonDef) load.getRootMetaObject();
		if (solutionCommonDef != null) {
			solutionCommonDef.doPostProcess(0, newCommonDefCallBack(this, resolverFactory, solutionCommonDef));
		}
		String solutionKey = tmpSolution.getKey();
		if (solutionDomainDef == null){
			initSolutionDomainDef();
		}
		MetaDomainDef metaDomainDef = this.loadDomainDef(solutionDomainDef,solutionResourceResolver, solutionKey, null);
		solutionDomainDefMap.put(solutionKey, metaDomainDef);

		if (solutionDataElementDef == null){
			initSolutionDataElementDef();
		}
		MetaDataElementDef metaDataElementDef = this.loadDataElementDef(solutionDataElementDef,solutionResourceResolver, solutionKey, null);

		solutionDataElementDefMap.put(solutionKey, metaDataElementDef);

		// 加载IOSetting配置
		MetaIOSettingLoad IOSettingLoad = new MetaIOSettingLoad(AppRunType.App);
		IOSettingLoad.load(solutionResourceResolver, DomMetaConstants.IOSETTING_FILE);
		IOSetting = (MetaIOSetting) IOSettingLoad.getRootMetaObject();


		// 加载安全过滤配置SecurityFilter
		MetaSecurityFilterLoad relationLoad = new MetaSecurityFilterLoad(AppRunType.App);
		relationLoad.load(solutionResourceResolver, DomMetaConstants.RELATION_FILE);
		solutionFilter = (MetaSecurityFilter) relationLoad.getRootMetaObject();

		// 加载客户端应用程序定义
		MetaClientAppDefLoad clientAppDefLoad = new MetaClientAppDefLoad(AppRunType.App);
		clientAppDefLoad.load(solutionResourceResolver, DomMetaConstants.CLIENT_APP_DEF_FILE);
		this.clientAppDef = (MetaClientAppDef) clientAppDefLoad.getRootMetaObject();

		// 加载不同应用所引用的工程定义(移动端)
		MetaAppDefinitionLoad appDefinitionLoad = new MetaAppDefinitionLoad(AppRunType.App);
		appDefinitionLoad.load(solutionResourceResolver, DomMetaConstants.APP_DEFINITION_FILE);
		this.appDefiniton = (MetaAppDefiniton) appDefinitionLoad.getRootMetaObject();

		// 多语言resolver
		IMetaResolver i18NResolver = resolverFactory.newMetaResolver(resolverFactory.getSeparator() + DomMetaConstants.I18N_FOLD);

		// 清除状态
		globalI18N.clearSolutionI18N();

		// 载入应用多语种
		MetaI18NScanLoad i18nScanLoad = new MetaI18NScanLoad(globalI18N, i18NResolver, null, null);
		i18nScanLoad.load();

		// 加载应用定义的数据映射多语言
		MetaDataMapI18NScanLoad dataMapI18NScanLoad = new MetaDataMapI18NScanLoad(globalI18N, i18NResolver, null, null);
		dataMapI18NScanLoad.load();

		// 加载应用定义的数据迁移多语言
		MetaDataMigrationI18NScanLoad dataMigrationI18NScanLoad = new MetaDataMigrationI18NScanLoad(globalI18N, i18NResolver, null, null);
		dataMigrationI18NScanLoad.load();

		// 加载移动端定义
		MetaMobileDefLoad mobileDefLoad = new MetaMobileDefLoad(AppRunType.App);
		mobileDefLoad.load(solutionResourceResolver, DomMetaConstants.MOBILE_DEF_FILE);
		solutionMobileDef = (MetaMobileDef) mobileDefLoad.getRootMetaObject();
		if (solutionMobileDef != null) {
			solutionMobileDef.doPostProcess(0, null);
		}

		// 加载移动端离线定义
		MetaOfflineDefLoad offlineDefLoad = new MetaOfflineDefLoad(AppRunType.App);
		offlineDefLoad.load(solutionResourceResolver, DomMetaConstants.OFFLINE_DEF_FILE);
		offlineDef = (MetaOfflineDef) offlineDefLoad.getRootMetaObject();
		if (offlineDef != null) {
			offlineDef.doPostProcess(0, null);
		}
	}

	private void scanJarAndProjects(IMetaResolverFactory resolverFactory, MetaSolution tmpSolution) throws Throwable {
		IMetaResolver solutionResourceResolver = resolverFactory.newMetaResolver("");
		// 加载jar包
		Set<String> jarNameSet = new HashSet<>();
		if (pluginsPath != null) {
			MetaJarScanLoad jarLoad = new MetaJarScanLoad(jarNameSet, pluginsPath, solutionResourceResolver, null, null);
			jarLoad.load();
		}
		MetaProjectCollection metaProjectCollection = tmpSolution.getProjectCollection();
		if (metaProjectCollection != null) {
			String solutionKey = tmpSolution.getKey();
			Iterator<MetaProjectProfile> itMetaProject = null;
			if (tmpSolution.isEnableDiff()) {
				initReferDiffProject(metaProjectCollection);
				List<MetaProjectProfile> listProject = sortProjects4DiffFirst(metaProjectCollection);
				if (listProject == null) return;
				itMetaProject = listProject.iterator();
			} else {
				itMetaProject = metaProjectCollection.iterator();
			}
			MetaProjectProfile metaProjectProfile = null;
			String projectKey = null;

			while (itMetaProject.hasNext()) {
				metaProjectProfile = itMetaProject.next();
				projectKey = metaProjectProfile.getKey();

				IMetaResolver projectMetaResolver = null;
				String refPath = metaProjectProfile.getRefPath();
				if (refPath == null || refPath.isEmpty()) {
					projectMetaResolver = resolverFactory.newMetaResolver(resolverFactory.getSeparator() + metaProjectProfile.getKey());
				} else {
					projectMetaResolver = resolverFactory.newFileMetaResolver(refPath);
				}

				// 保留多个配置的projectMetaResolver
				projectResolverMap.put(projectKey, projectMetaResolver);

				MetaProjectLoad projectLoad = new MetaProjectLoad(AppRunType.App);
				projectLoad.load(projectMetaResolver, DomMetaConstants.PROJECT_FILE);
				MetaProject metaProject = (MetaProject) projectLoad.getRootMetaObject();
				metaProjectProfile.setProject(metaProject);
				String diffProjectKey = mapDiffSourceProject.get(metaProjectProfile.getKey());
				metaProjectProfile.setDiffProject(diffProjectKey == null ? "" : diffProjectKey);
				metaProject.setSolution(tmpSolution);

				// 加载差异
				IMetaResolver diffResolver = StringUtil.isBlankOrNull(metaProjectProfile.getDiffProject()) ? null : projectResolverMap.get(metaProjectProfile.getDiffProject());
				diffResolver = (diffResolver == null ? projectMetaResolver : diffResolver);
				if (getSolution().isEnableDiff()) {
					MetaDiffScanLoad diffScanLoad = new MetaDiffScanLoad(diffList, diffResolver, metaProject, null);
					diffScanLoad.load();
				}

				MetaEntryLoad entryLoad = new MetaEntryLoad(AppRunType.App);
				entryLoad.load(projectMetaResolver, DomMetaConstants.ENTRY_FILE);
				MetaEntry metaEntry = (MetaEntry) entryLoad.getRootMetaObject();
				metaProjectProfile.setEntry(metaEntry);

				// commondef
				MetaCommonDefLoad commonDefLoad = new MetaCommonDefLoad(AppRunType.App);
				commonDefLoad.load(projectMetaResolver, DomMetaConstants.COMMON_DEF_FILE);
				MetaCommonDef commonDef = (MetaCommonDef) commonDefLoad.getRootMetaObject();
				if (commonDef != null) {
					commonDef.setSolutionKey(tmpSolution.getKey());
					commonDef.doPostProcess(0, newCommonDefCallBack(this, resolverFactory, commonDef));
				}
				metaProject.setCommonDef(commonDef);

				// mobileDef
				MetaMobileDefLoad mobildDefLoad = new MetaMobileDefLoad(AppRunType.App);
				mobildDefLoad.load(projectMetaResolver, DomMetaConstants.MOBILE_DEF_FILE);
				MetaMobileDef metaMobileDef = (MetaMobileDef) mobildDefLoad.getRootMetaObject();
				if (metaMobileDef != null) {
					metaMobileDef.doPostProcess(0, null);
				}
				metaProject.setMobileDef(metaMobileDef);

				// securityFilter
				MetaSecurityFilterLoad securityFilterLoad = new MetaSecurityFilterLoad(AppRunType.App);
				securityFilterLoad.load(projectMetaResolver, DomMetaConstants.RELATION_FILE);
				MetaSecurityFilter securityFilter = (MetaSecurityFilter) securityFilterLoad.getRootMetaObject();
				if (securityFilter != null) {
					securityFilter.doPostProcess(0, null);
				}
				metaProject.setSecurityFilter(securityFilter);

				// Enhance
				MetaEnhanceLoad projectEnhanceLoad = new MetaEnhanceLoad(AppRunType.App);
				projectEnhanceLoad.load(projectMetaResolver, DomMetaConstants.ENHANCE_FILE);
				MetaEnhance enhance = (MetaEnhance) projectEnhanceLoad.getRootMetaObject();
				if (enhance != null) {
					enhance.doPostProcess(0, null);
					if (solutionEnhance == null) {
						solutionEnhance = enhance;
					} else {
						solutionEnhance.toMerge(enhance);
					}
				}
				metaProject.setEnhance(enhance);

//				// Domain
//				MetaDomainDef projectDomainDef = this.loadDomainDef(projectMetaResolver, solutionKey, metaProject);
//				if (projectDomainDef != null) {
//					metaProject.setDomainDef(projectDomainDef);
//				}
//
//				// DataElement
//				MetaDataElementDef projectDataDelementDef = this.loadDataElementDef(this, projectMetaResolver, solutionKey, metaProject);
//				if (projectDataDelementDef != null) {
//					metaProject.setDataElementDef(projectDataDelementDef);
//				}

				// 加载jar包
				if (pluginsPath != null) {
					MetaJarScanLoad jarLoad = new MetaJarScanLoad(jarNameSet, pluginsPath, projectMetaResolver, null, null);
					jarLoad.load();
				}

				MetaFormScanLoad scanLoad = new MetaFormScanLoad(formList, cellTypeTable, projectMetaResolver,
						metaProject, null);
				scanLoad.setExtFormKeyList(extFormList);
				scanLoad.load();

				MetaDataObjectScanLoad dataObjectScanLoad = new MetaDataObjectScanLoad(dataObjectList,
						projectMetaResolver, metaProject, null);
				dataObjectScanLoad.load();


				MetaDataMigrationScanLoad migrationScanLoad = new MetaDataMigrationScanLoad(migrationList,
						projectMetaResolver, metaProject, null, AppRunType.App);
				migrationScanLoad.load();

				MetaDataMapScanLoad dataMapScanLoad = new MetaDataMapScanLoad(dataMapList, projectMetaResolver,
						metaProject, null, AppRunType.App);
				dataMapScanLoad.load();

				MetaBPMReferenceScanLoad BPMScanLoad = new MetaBPMReferenceScanLoad(metaBPM, solutionResourceResolver,
						metaProject, null, AppRunType.App);
				BPMScanLoad.load();

				MetaTaskScanLoad metaTaskScanLoad = new MetaTaskScanLoad(metaTask, projectMetaResolver, metaProject, null, AppRunType.App);
				metaTaskScanLoad.load();

				MetaFlatCanvasScanLoad FlatCanvasScanLoad = new MetaFlatCanvasScanLoad(flatCanvasList, projectMetaResolver,
						metaProject, null, AppRunType.App);
				FlatCanvasScanLoad.load();

				MetaUserSVGFileScanLoad UserSVGFileScanLoad = new MetaUserSVGFileScanLoad(svgUserFileMap, projectMetaResolver,
						metaProject, null, AppRunType.App);
				UserSVGFileScanLoad.load();

				MetaReportScanLoad reportScanLoad = new MetaReportScanLoad(reportList, projectMetaResolver, metaProject,
						null);
				reportScanLoad.load();

				MetaRelationScanLoad relationScanLoad = new MetaRelationScanLoad(relationCheck, relationList,
						projectMetaResolver, metaProject, null, AppRunType.App);
				relationScanLoad.load();
				// 数据集映射配置加载
				MetaMappingScanLoad mappingScanLoad = new MetaMappingScanLoad(mappingList, projectMetaResolver, metaProject, null, AppRunType.App);
				mappingScanLoad.load();

				MetaExcelTemplateScanLoad excelTemplateScanLoad = new MetaExcelTemplateScanLoad(excelTemplateList,
						projectMetaResolver, metaProject, null);
				excelTemplateScanLoad.load();

				MetaExcelFileTemplateScanLoad excelFileTemplateScanLoad = new MetaExcelFileTemplateScanLoad(excelFileTemplateMap,
						projectMetaResolver, metaProject, null);
				excelFileTemplateScanLoad.setFilter(new IMetaResourceFilter() {
					@Override
					public boolean isAccepted(String fileName) {
						return fileName.endsWith(".xls") || fileName.endsWith(".xlsx");
					}

				});
				excelFileTemplateScanLoad.load();

				MetaBizExtendScanLoad bizExtendScanLoad = new MetaBizExtendScanLoad(bizExtend, projectMetaResolver,
						metaProject, null);
				bizExtendScanLoad.load();

				MetaTaskFlowScanLoad taskFlowScanLoad = new MetaTaskFlowScanLoad(taskFlowList, projectMetaResolver,
						metaProject, null, AppRunType.App);
				taskFlowScanLoad.load();

				MetaSimpleSetting mss = this.setting == null ? null :this.setting.getSimpleSetting("MetaCustomObjectBuilder");
				if (mss != null) {
					String impl = mss.get("Impl");
					if (impl != null && !impl.isEmpty()) {
						MetaCustomObjectScanLoad customObjectScanLoad = new MetaCustomObjectScanLoad(customList, projectMetaResolver,
								metaProject, null, impl, AppRunType.App);
						customObjectScanLoad.load();
					}
				}

				IMetaResolver projectI18NResolver = null;
				if (refPath == null || refPath.isEmpty()) {
					projectI18NResolver = resolverFactory.newMetaResolver(
							resolverFactory.getSeparator() + metaProjectProfile.getKey() + resolverFactory.getSeparator()
									+ DomMetaConstants.I18N_FOLD);
				} else {
					projectI18NResolver = resolverFactory.newFileMetaResolver(
							refPath + resolverFactory.getSeparator() + DomMetaConstants.I18N_FOLD);
				}

				// 载入工程多语种(直接加载)
				MetaStringTable strings = new MetaStringTable();
				metaProject.setStrings(strings);
				MetaProjectI18NScanLoad i18nScanLoad = new MetaProjectI18NScanLoad(strings, projectI18NResolver, metaProject, null);
				i18nScanLoad.load();

				// 载入数据映射多语种(直接加载)
				strings = new MetaStringTable();
				metaProject.setDataMapStrings(strings);
				MetaProjectDataMapI18NScanLoad dataMapI18NScanLoad = new MetaProjectDataMapI18NScanLoad(strings, projectI18NResolver, metaProject,null);
				dataMapI18NScanLoad.load();

				// 载入数据迁移多语种(直接加载)
				strings = new MetaStringTable();
				metaProject.setDataMigrationStrings(strings);
				MetaProjectDataMigrationI18NScanLoad dataMigrationI18NScanLoad = new MetaProjectDataMigrationI18NScanLoad(strings, projectI18NResolver, metaProject, null);
				dataMigrationI18NScanLoad.load();

				// 载入表单多语种(延迟加载)
				MetaFormI18NScanLoad formI18NScanLoad = new MetaFormI18NScanLoad(globalI18N, projectI18NResolver, null, null);
				formI18NScanLoad.load();

				// 载入流程多语种(延迟加载)
				MetaProcessI18NScanLoad processI18NScanLoad = new MetaProcessI18NScanLoad(globalI18N, projectI18NResolver, null, null);
				processI18NScanLoad.load();

				// 载入数据对象多语种(延迟加载)
				MetaDataObjectI18NScanLoad dataObjI18NScanLoad = new MetaDataObjectI18NScanLoad(globalI18N, projectI18NResolver, null, null);
				dataObjI18NScanLoad.load();
			}
		}
	}

	private MetaRightsDefinition loadSolutionRightsDefinition(IMetaResolverFactory resolverFactory) throws Exception {
		IMetaResolver solutionResourceResolver = resolverFactory.newMetaResolver("");
		MetaRightsDefinitionLoad rightsDefinitionLoad = new MetaRightsDefinitionLoad(AppRunType.App);
		rightsDefinitionLoad.load(solutionResourceResolver, DomMetaConstants.RIGHTS_FILE);
		MetaRightsDefinition rightsDefinition = (MetaRightsDefinition) rightsDefinitionLoad.getRootMetaObject();
		if (rightsDefinition != null) {
			rightsDefinition.doPostProcess(0, null);
		}
		return rightsDefinition;
	}

	private MetaEnhance loadSolutionEnhance(IMetaResolverFactory resolverFactory) throws Exception {
		IMetaResolver solutionResourceResolver = resolverFactory.newMetaResolver("");
		MetaEnhanceLoad enhanceload = new MetaEnhanceLoad(AppRunType.App);
		enhanceload.load(solutionResourceResolver, DomMetaConstants.ENHANCE_FILE);
		MetaEnhance solutionEnhance = (MetaEnhance) enhanceload.getRootMetaObject();
		if (solutionEnhance != null) {
			solutionEnhance.doPostProcess(0, null);
		}
		return solutionEnhance;
	}

	public void preLoadSolution(IMetaResolverFactory resolverFactory) throws Throwable {
		if (resolverFactory == null) {
			return;
		}

		IMetaResolver solutionResourceResolver = resolverFactory.newMetaResolver("");
		MetaSolution solution = loadSolutionProfile(resolverFactory);
		String solutionKey = solution.getKey();

		//预加载Parameter.xml
		MetaParameterScanLoad parameterScanLoad = new MetaParameterScanLoad(solutionResourceResolver, parameter, "Parameter.xml",solutionKey);
		parameterScanLoad.load();



		//预加载ParaTable.xml
		MetaParaTableScanLoad scanLoad = new MetaParaTableScanLoad(solutionResourceResolver, paraTable, solutionKey, DomMetaConstants.PARATABLE_FILE);
		scanLoad.load();
		//预加载ParaTable.xml的马甲
		scanLoad = new MetaParaTableScanLoad(solutionResourceResolver, paraTable, solutionKey, DomMetaConstants.PARATABLE_FILE_VEST);
		scanLoad.load();



		//预加载数据元素



	}

	@Override
	public synchronized MetaSolution loadSolution(IMetaResolverFactory resolverFactory, boolean isMultiple,
												  boolean isPrimary, boolean again) throws Throwable {
		if (resolverFactory == null) {
			return null;
		}
		if (!isMultiple) { // 非多配置加载
			this.solution = loadSolutionProfile(resolverFactory);
			loadPrimarySetting(resolverFactory, this.solution);
			// 加载权限定义
			this.rightsDefinition = loadSolutionRightsDefinition(resolverFactory);
			// 加载二次开发
			this.solutionEnhance = loadSolutionEnhance(resolverFactory);
			// 扫描工程
			scanJarAndProjects(resolverFactory, this.solution);
		} else {
			if (isPrimary && !again) { // 主配置第一次加载
				MetaSolution tmpSolution = loadSolutionProfile(resolverFactory);
				loadPrimarySetting(resolverFactory, tmpSolution);
				// 加载权限定义
				this.rightsDefinition = loadSolutionRightsDefinition(resolverFactory);
				// 加载二次开发
				this.solutionEnhance = loadSolutionEnhance(resolverFactory);
				this.solution = tmpSolution;
				this.resolverFactoryMap.put(tmpSolution.getKey(), primaryResolverFactory);
			} else if (isPrimary && again) {// 主配置再次加载
				MetaSolution tmpSolution = loadSolutionProfile(resolverFactory);
				// 扫描工程
				scanJarAndProjects(resolverFactory, tmpSolution);
				this.solution = this.solution == null ? tmpSolution : this.solution.toMerge(tmpSolution);
				return tmpSolution;
			} else {// 其他配置
				MetaSolution tmpSolution = loadSolutionProfile(resolverFactory);
				String solutionKey = tmpSolution.getKey();
				IMetaResolver solutionResourceResolver = resolverFactory.newMetaResolver("");
				MetaCommonDef tempCommonDef = loadSolutionCommonDef(resolverFactory, solutionKey);
				MetaDomainDef tempDomainDef = this.loadDomainDef(solutionDomainDef,solutionResourceResolver, solutionKey, null);
				GlobalI18N tempI18N = loadSolutionI18N(resolverFactory);

				// 存储非primary的domainDef
				this.solutionDomainDefMap.put(solutionKey, tempDomainDef);
				MetaDataElementDef tempDataElementDef = this.loadDataElementDef(solutionDataElementDef,solutionResourceResolver, solutionKey, null);
				// 存储非primary的dataElementDef
				this.solutionDataElementDefMap.put(solutionKey, tempDataElementDef);
				// 加载权限定义
				MetaRightsDefinition rightsDefinition = loadSolutionRightsDefinition(resolverFactory);
				// 加载二次开发
				MetaEnhance solutionEnhance = loadSolutionEnhance(resolverFactory);
				// 扫描工程
				scanJarAndProjects(resolverFactory, tmpSolution);
				// 存储非primary的commonDef
				this.solutionCommmonDefMap.put(solutionKey, tempCommonDef);
				// 存储非primary的i18n
				this.solutionI18NMap.put(tmpSolution.getKey(), tempI18N);
				// 存储非primary的resolverFactory
				this.resolverFactoryMap.put(solutionKey, resolverFactory);
				// 对需要合并的对象进行合并
				this.solution = this.solution == null ? tmpSolution : this.solution.toMerge(tmpSolution);
				this.solutionEnhance = this.solutionEnhance == null ? solutionEnhance
						: this.solutionEnhance.toMerge(solutionEnhance);
				this.rightsDefinition = this.rightsDefinition == null ? rightsDefinition
						: this.rightsDefinition.toMerge(rightsDefinition, tmpSolution.getKey());

				mergeMetaStatusCollectionSecondary(tmpSolution.getKey(), tempCommonDef);
				return tmpSolution;
			}
		}
		return this.solution;
	}

	private MetaCommonDef loadSolutionCommonDef(IMetaResolverFactory resolverFactory, String solutionKey)
			throws Throwable {
		IMetaResolver solutionResourceResolver = resolverFactory.newMetaResolver("");
		// commondef
		MetaCommonDefLoad load = new MetaCommonDefLoad(AppRunType.App);
		load.load(solutionResourceResolver, DomMetaConstants.COMMON_DEF_FILE);
		MetaCommonDef tempCommonDef = (MetaCommonDef) load.getRootMetaObject();
		if (tempCommonDef != null) {
			tempCommonDef.setSolutionKey(solutionKey);
			tempCommonDef.doPostProcess(0, newCommonDefCallBack(this, resolverFactory, tempCommonDef));
		}
		return tempCommonDef;
	}

	private MetaParaTable loadParaTable(IMetaResolver solutionResourceResolver) throws Exception {
		// 加载ParaTable配置
		MetaParaTableLoad  paraTableLoad = new MetaParaTableLoad(AppRunType.App);
		paraTableLoad.load(solutionResourceResolver, DomMetaConstants.PARATABLE_FILE);
		MetaParaTable rootMetaObject = (MetaParaTable) paraTableLoad.getRootMetaObject();

		MetaParaTableLoad  paraTableLoadExt = new MetaParaTableLoad(AppRunType.App);
		paraTableLoadExt.load(solutionResourceResolver, DomMetaConstants.PARATABLE_FILE_VEST);
		MetaParaTable rootMetaObjectExt = (MetaParaTable) paraTableLoadExt.getRootMetaObject();

		if (rootMetaObject != null){
			rootMetaObject.merge(rootMetaObjectExt);
		}


		return  rootMetaObject;
	}
	private MetaParaTable loadParaTableVest(IMetaResolver solutionResourceResolver) throws Exception {
		// 加载ParaTable配置
		MetaParaTableLoad  paraTableLoadExt = new MetaParaTableLoad(AppRunType.App);
		paraTableLoadExt.load(solutionResourceResolver, DomMetaConstants.PARATABLE_FILE_VEST);
		return (MetaParaTable) paraTableLoadExt.getRootMetaObject();
	}

	/**
	 * 当加载一个非主Solution时，合并状态集合
	 * @param secondarySolutionKey 加载的非主Solution的标识
	 * @param secondaryCommonDef   加载的非主Solution的公共定义
	 */
	private void mergeMetaStatusCollectionSecondary(String secondarySolutionKey, MetaCommonDef secondaryCommonDef) {
		if (secondaryCommonDef == null) {
			return;
		}
		MetaStatusCollection secondaryStatusCollection = secondaryCommonDef.getStatusCollection();
		if (secondaryStatusCollection == null || secondaryStatusCollection.isEmpty()) {
			return;
		}

		// 将新加载的非主Solution的状态集合，合并进已有的已合并非主Solution的状态集合
		for (MetaStatusCollection statusCollection : solutionStatusCollectionMap.values()) {
			statusCollection.toMerge(secondaryStatusCollection);
		}

		// 将合并了非主Solution和主Solution的状态集合，注册到集合里
		MetaStatusCollection mergeStatusCollection = new MetaStatusCollection();
		mergeStatusCollection.toMerge(secondaryStatusCollection);
		MetaStatusCollection primaryStatusCollection = null;
		if (solutionCommonDef == null) {
			solutionCommonDef = new MetaCommonDef();
		} else {
			primaryStatusCollection = solutionCommonDef.getStatusCollection();
		}
		if (primaryStatusCollection != null) {
			mergeStatusCollection.toMerge(primaryStatusCollection);
		}
		solutionStatusCollectionMap.put(secondarySolutionKey, mergeStatusCollection);

		// 如果加载的非主Solution的状态集合非空，则合并到主Solution
		innerMergeMetaStatusCollection(secondaryStatusCollection, solutionCommonDef);
	}

	/**
	 * 合并状态集合
	 * @param fromStatusCollection 用来合并的状态集合
	 * @param toCommonDef          被合并的公共定义类
	 */
	private void innerMergeMetaStatusCollection(MetaStatusCollection fromStatusCollection, MetaCommonDef toCommonDef) {
		MetaStatusCollection toStatusCollection = toCommonDef.getStatusCollection();
		if (fromStatusCollection == toStatusCollection) {
			return;
		}
		if (toStatusCollection == null) {
			toStatusCollection = new MetaStatusCollection();
			toCommonDef.setStatusCollection(toStatusCollection);
		}
		toStatusCollection.toMerge(fromStatusCollection);
	}

	/**
	 * 根据指定的配置解析工厂加载配置
	 *
	 * @param resolverFactory 配置解析工厂
	 * @param isMultiple      是否是多配置模式
	 * @param isPrimary       是否是主配置
	 * @param again           是否再次加载
	 * @return 解析后的配置工厂
	 * @throws Throwable
	 */
	public IMetaFactory load(IMetaResolverFactory resolverFactory, boolean isMultiple, boolean isPrimary, boolean again)
			throws Throwable {
//		preLoadSolution();
		loadSolution(resolverFactory, isMultiple, isPrimary, again);
		// 多配置下延后处理
//		if (!isMultiple) {
//			postLoadSolution();
//		}
		return this;
	}

	@Override
	public MetaSolution getSolution() throws Throwable {
		if (solution == null) {
			loadSolution(primaryResolverFactory, false, true, false);
		}
		return solution;
	}

	/**
	 * 热更新下加载配置的后处理：一次性加载所有配置，避免延迟加载
	 *
	 * @throws Throwable 加载异常
	 *
	 */
	protected void loadAll() throws Throwable {

		// 初始化参数表
		initParaTable();
		// 优先加载马甲数据对象
		loadVestDataObject();
		// 一次性加载所有的dataObject
		for (MetaDataObjectProfile profile : dataObjectList) {
			String extendFormKey = profile.getExtend();
			boolean isVestDiff = extendFormKey != null && !extendFormKey.isEmpty();
			if (!isVestDiff) {
				getDataObject(profile.getKey());
			}
		}
		loadVestForm();
		// 一次性加载所有表单
		for (MetaFormProfile metaFormProfile : formList) {
			String extendFormKey = metaFormProfile.getExtend();
			Boolean mergeToSource = metaFormProfile.getMergeToSource();
			boolean isVestDiff = mergeToSource && extendFormKey != null && !extendFormKey.isEmpty();
			if (!isVestDiff) {
				getMetaForm(metaFormProfile.getKey());
			}
		}

		// mapping
		for (MetaMappingProfile metaMappingProfile : mappingList) {
			getMapping(metaMappingProfile.getKey());
		}

		// 迁移
		for (MetaDataMigrationProfile profile : migrationList) {
			getDataMigration(profile.getKey());
		}

		// 映射
		for (MetaDataMapProfile profile : dataMapList) {
			getDataMap(profile.getKey());
		}

		// 打印模板
		for (MetaReportSubList subList : reportList) {
			for (MetaReportProfile profile : subList) {
				MetaReport metaReport = profile.getReport();
				if (metaReport == null) {
					MetaProject metaProject = (MetaProject) profile.getProject();
					IMetaResolver projectResourceResolver = projectResolverMap.get(metaProject.getKey());
					MetaReportLoad load = new MetaReportLoad(AppRunType.App);
					load.load(projectResourceResolver, profile.getResource());
					metaReport = (MetaReport) load.getRootMetaObject();
					profile.setReport(metaReport);
					metaReport.setProject(metaProject);
				}
			}
		}

		// 流程
		for (Map.Entry<String, ProcessDefinitionProfile> entry : metaBPM.getProfileMap().entrySet()) {
			MetaProcess process = entry.getValue().getDefination();
			if (process == null) {
				loadProcess(entry.getValue());
			}
		}

		// 关系检查定义列表
		for (MetaRelationProfile profile : relationList) {
			getMetaRelationPath(profile.getKey());
		}

		// Excel导出模板
		for (MetaExcelTemplateSubList subList : excelTemplateList) {
			for (MetaExcelTemplateProfile profile : subList) {
				MetaExcelWorkbook metaWorkbook = profile.getWorkbook();
				if (metaWorkbook == null) {
					IMetaResolver projectResourceResolver = projectResolverMap.get(profile.getProject().getKey());
					MetaExcelTemplateLoad load = new MetaExcelTemplateLoad(AppRunType.App);
					load.load(projectResourceResolver, profile.getResource());
					metaWorkbook = (MetaExcelWorkbook) load.getRootMetaObject();
					profile.setWorkbook(metaWorkbook);
				}
			}
		}

		// 平面图形配置
		for (MetaFlatCanvasProfile profile : flatCanvasList.values()) {
			getMetaFCPaper(profile.getKey());
		}

		// biz-extend
		if (getChargingObjectList() != null) {
			for (MetaChargingObjectProfile profile : getChargingObjectList()) {
				getChargingObject(profile.getKey());
			}
		}
		if (getChargingRuleGroupList() != null) {
			for (MetaChargingRuleGroupProfile profile : getChargingRuleGroupList()) {
				getChargingRuleGroup(profile.getKey());
			}
		}

		if (CollectionUtils.isNotEmpty(normalFormProfileList)) {
			// 找出FormType="Entity"表单的所有表名
			List<String> dbTableNameList = new ArrayList<>();
			for (MetaDataObjectProfile metaDataObjectProfile : dataObjectList) {
				final MetaDataObject dataObject = metaDataObjectProfile.getDataObject();
				final MetaTableCollection tableCollection = dataObject.getTableCollection();
				if (Objects.isNull(tableCollection)) {
					continue;
				}
				for (MetaTable metaTable : tableCollection) {
					final String dbTableName = metaTable.getBindingDBTableName();
					dbTableNameList.add(dbTableName);
				}
			}

			// 判断不存在与FormType="Entity"的表单存在重复表名的表单，再加载DataObjectList
			for (MetaFormProfile formProfile : normalFormProfileList) {
				final MetaForm metaForm = formProfile.getForm();
				final MetaDataSource dataSource = metaForm.getDataSource();
				final MetaDataObject dataObject = dataSource.getDataObject();
				final MetaTableCollection tableCollection = dataObject.getTableCollection();
				if (Objects.isNull(tableCollection)) {
					continue;
				}

				List<String> normalTableNameList = new ArrayList<>();
				for (MetaTable metaTable : tableCollection) {
					final String dbTableName = metaTable.getBindingDBTableName();
					normalTableNameList.add(dbTableName);
				}
				final boolean existFlag = normalTableNameList.stream().anyMatch(normalTableName -> dbTableNameList.stream().anyMatch(dbTableName -> StringUtils.equalsIgnoreCase(normalTableName, dbTableName)));
				if (!existFlag) {
					this.addInlineDataObject(formProfile, metaForm, false);
				}
			}
		}

		// 加载所有延迟加载的多语言
		globalI18N.loadAll();
		for (Map.Entry<String, GlobalI18N> entry : solutionI18NMap.entrySet()) {
			GlobalI18N i18n = entry.getValue();
			i18n.loadAll();
		}

	}

	/**
	 * 提前处理特殊马甲
	 */
	private void loadVestForm() throws Throwable {
		ArrayList<String> templateList = new ArrayList<>();
		ArrayList<String> notTemplateList = new ArrayList<>();
		formList.forEach(metaFormProfile -> {
			String extendFormKey = metaFormProfile.getExtend();
			Boolean mergeToSource = metaFormProfile.getMergeToSource();
			boolean isVestDiff = mergeToSource && extendFormKey != null && !extendFormKey.isEmpty();
			if (isVestDiff) {
				String key = metaFormProfile.getKey();
				if (formList.get(extendFormKey).getFormType() == FormType.Template) {// 源单为Template
					templateList.add(key);
				} else {// 实体表单
					notTemplateList.add(key);
				}
			}
		});
		for (String key : templateList) {// 遍历加载特殊马甲
			MetaForm metaForm = null;
			metaForm = getMetaForm(key);
			this.replaceMetaForm4VestDiff(metaForm.getExtend(), metaForm);
		}
		for (String key : notTemplateList) {// 遍历加载特殊马甲
			MetaForm metaForm = null;
			metaForm = getMetaForm(key);
			this.replaceMetaForm4VestDiff(metaForm.getExtend(), metaForm);
		}
	}
	/**
	 * 提前处理特殊马甲
	 */
	public void loadVestDataObject() throws Throwable {
		ArrayList<String> templateList = new ArrayList<>();
		ArrayList<String> notTemplateList = new ArrayList<>();
		dataObjectList.forEach(dataObjectProfile -> {
			String extendDataObjectKey = dataObjectProfile.getExtend();
			boolean isVestDiff = extendDataObjectKey != null && !extendDataObjectKey.isEmpty();
			if (isVestDiff) {
				String key = dataObjectProfile.getKey();
				if (dataObjectList.get(extendDataObjectKey).getPrimaryType() == DataObjectPrimaryType.TEMPLATE) {// 源单为Template
					templateList.add(key);
				} else {// 实体表单
					notTemplateList.add(key);
				}
			}
		});
		for (String key : templateList) {// 遍历加载特殊马甲
			getDataObject(key);
		}
		for (String key : notTemplateList) {// 遍历加载特殊马甲
			getDataObject(key);
		}
	}

	@Override
	public void initParaTable() throws Throwable {
	}

	@Override
	public void init() throws Throwable {

	}

	@Override
	public MetaProject getMetaProject(String key) throws Throwable {
		MetaProjectProfile metaProjectProfile = solution.getProjectCollection().get(key);
		return metaProjectProfile.getProject();
	}

	@Override
	public MetaFormList getMetaFormList() throws Throwable {
		return formList;
	}

	@Override
	public List<KeyPairMetaObject> getCustomList() {
		return customList;
	}

	@Override
	public MetaCommonDef getSolutionCommonDef() {
		return solutionCommonDef;
	}

	public void setSolutionCommonDef(MetaCommonDef solutionCommonDef) {
		this.solutionCommonDef = solutionCommonDef;
	}

	public void setDataElementDef(MetaDataElementDef dataElementDef) {
		this.solutionDataElementDef = dataElementDef;
	}

	@Override
	public MetaDataElementDef getDataElementDef(String solutionKey) {
		if (solutionKey == null || solutionKey.isEmpty()) {
			return this.solutionDataElementDef;
		}
		return solutionDataElementDefMap.get(solutionKey);
	}
	@Override
	public HashMap<String, MetaDataElementDef> getSolutionDataElementDefMap() {
		return solutionDataElementDefMap;
	}
	@Override
	public HashMap<String, MetaDomainDef> getSolutionDomainDefMap() {
		return solutionDomainDefMap;
	}
	public  MetaDataElementDef initSolutionDataElementDef(){
 		if (solutionDataElementDef == null) {
			solutionDataElementDef = new MetaDataElementDef();
			MetaDataElementCollection dataElementCollection = new MetaDataElementCollection();
			solutionDataElementDef.setDataElementCollection(dataElementCollection);
		}
		 return solutionDataElementDef;
	}
	public  MetaDomainDef initSolutionDomainDef(){
 		if (solutionDomainDef == null) {
			solutionDomainDef = new MetaDomainDef();
			solutionDomainDef.setDomainCollection(new MetaDomainCollection());
		}
		 return solutionDomainDef;
	}
	@Override
	public MetaDataElementDef getDataElementDef() {
		initSolutionDataElementDef();
		return solutionDataElementDef;
	}
	@Override
	public void reloadDataElementDef() {
		solutionDataElementDef = null;
		initSolutionDataElementDef();
	}


	@Override
	public MetaDomainDef getDomainDef(String solutionKey) {
		if (solutionKey == null || solutionKey.isEmpty()) {
			return this.solutionDomainDef;
		}

		return solutionDomainDefMap.get(solutionKey);
	}
	@Override
	public void reloadDomainDef() {
		solutionDomainDef = null;
	}
	@Override
	public MetaDomainDef getDomainDef() {
		initSolutionDomainDef();
		return solutionDomainDef;
	}

	private boolean isEntityForm(MetaFormProfile metaFormProfile) {
		return metaFormProfile.getFormType() == FormType.Entity ||
				metaFormProfile.getFormType() == FormType.Dict ||
				metaFormProfile.getFormType() == FormType.ChainDict;
	}

	@Override
	public boolean hasMetaForm(String key) throws Throwable {
		return formList.containsKey(key);
	}

	private void mergeDiffMeta4FormAndDataObject(String formKey, AbstractMetaObject oldMeta, String tagName) throws Throwable {
		if (getSolution().isEnableDiff() && DiffActionManager.getInstance().isInited()) {
			String diffMetaKey = DiffKeyUtil.getMetaDiffKey(formKey, tagName);
			MetaDiff metaDiff = getMetaDiff4FormAndDataObject(diffMetaKey);
			DiffActionManager.getInstance().doDiffMergeAction(oldMeta, metaDiff, new MetaFormDiffLoad(AppRunType.App));
		}
	}

	private MetaDiff getMetaDiff4FormAndDataObject(String diffMetaKey) throws Exception {
		MetaDiff metaDiff = null;
		MetaDiffProfile metaDiffProfile = diffList.get(diffMetaKey);
		if (metaDiffProfile != null) {
			metaDiff = metaDiffProfile.getDiff();
		}

		if (metaDiff == null && metaDiffProfile != null) {
			MetaProject metaProject = (MetaProject) metaDiffProfile.getProject();
			IMetaResolver projectResourceResolver = projectResolverMap.get(metaProject.getKey());
			if (projectResourceResolver == null) {
				throw new MetaException(MetaException.PROJECT_RESOLVER_UNDEFINED,
						SimpleStringFormat.format(StringTable.getString(null, "", StringTable.ProjectResolverUndefined), metaProject.getKey()));
			}

			MetaFormDiffLoad diffFormLoad = new MetaFormDiffLoad(AppRunType.App);
			diffFormLoad.load(projectResourceResolver, metaDiffProfile.getResource());
			metaDiff = (MetaDiff) diffFormLoad.getRootMetaObject();
			metaDiff.setProject(metaProject);
			metaDiff.setResource(metaDiffProfile.getResource());

			metaDiffProfile.setDiff(metaDiff);
		}
		return metaDiff;

	}

	private void getLoadReportRegister(String key) throws Throwable {
		if (reportFuntions == null) {
			reportFuntions = new ArrayList<>();
			Iterable<IReLoadForm> iterator = ServiceLoader.load(IReLoadForm.class);
			for (IReLoadForm loadReportFuntion : iterator) {
				reportFuntions.add(loadReportFuntion);
			}
		}
		if (reportFuntions != null && !reportFuntions.isEmpty()) {
			for (IReLoadForm loadReportRegister : reportFuntions) {
				loadReportRegister.reloadReport(key);
			}
		}
	}

	private List<IReLoadForm> getLoadReportRegister() {
		if (reportFuntions == null) {
			reportFuntions = new ArrayList<>();
			Iterable<IReLoadForm> iterator = ServiceLoader.load(IReLoadForm.class);
			for (IReLoadForm loadReportFuntion : iterator) {
				reportFuntions.add(loadReportFuntion);
			}
		}
		return reportFuntions;
	}

	@Override
	public MetaForm getMetaForm(String key) throws Throwable {
		getLoadReportRegister(key);
		MetaForm metaForm = null;
		MetaFormProfile metaFormProfile = formList.get(key);
		if (metaFormProfile != null) {
			metaForm = metaFormProfile.getForm();
		}

		//if (metaForm == null && metaFormProfile != null) {
		String lockKey = SystemPrefix.LOAD_META_FORM + key;
		metaForm = LockUtil.execute(lockKey, () -> {
			MetaForm meta = metaFormProfile.getForm();
			if (meta != null) {
				return meta;
			}
			meta = loadMetaForm(metaFormProfile);
			if (meta != null) {
				metaFormProfile.setForm(meta);
			}
			return meta;
		});
		//}
		if (metaForm == null) {
			throw new MetaException(MetaException.NO_FORM_DEFINED,
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.NoFormDefined), key));
		}
		return metaForm;
	}

	protected MetaForm loadMetaForm(MetaFormProfile metaFormProfile) throws Throwable {

		MetaProject metaProject = (MetaProject) metaFormProfile.getProject();
		IMetaResolver projectResourceResolver = projectResolverMap.get(metaProject.getKey());
		if (projectResourceResolver == null) {
			throw new MetaException(MetaException.PROJECT_RESOLVER_UNDEFINED,
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.ProjectResolverUndefined), metaProject.getKey()));
		}

		MetaForm parentForm = null;
		String extendFormKey = metaFormProfile.getExtend();
		if (extendFormKey != null && !extendFormKey.isEmpty()) {
			parentForm = this.getMetaForm(extendFormKey);
		}
		MetaFormLoad formLoad = new MetaFormLoad(AppRunType.App, parentForm);
		formLoad.load(projectResourceResolver, metaFormProfile.getResource());
		final MetaForm metaForm = (MetaForm) formLoad.getRootMetaObject();
		metaForm.setMergeToSource(metaFormProfile.getMergeToSource());

		mergeDiffMeta4FormAndDataObject(metaForm.getKey(), metaForm, MetaForm.TAG_NAME);
		if (parentForm != null) {
			metaForm.setProject(parentForm.getProject());// 保持马甲Project与源单Project一致
		} else {
			metaForm.setProject(metaProject);
		}
		metaForm.setResource(metaFormProfile.getResource());
		MetaFormSetting formSetting = setting.getFormSetting();
		if (formSetting != null) {
			metaForm.setInitFocus(formSetting.initFocus());
			metaForm.setDimValueProvider(formSetting.getDimValueProvider());
		}
		// 计算DataObject,将引用的外部数据对象都计算好放到DataObject中
		MetaDataSource metaDataSource = metaForm.getDataSource();
		MetaDataObject metaDataObject = null;
		if (metaDataSource != null) {
			metaDataObject = metaDataSource.getDataObject();
			if (metaDataObject == null) {
				String refObjectKey = metaDataSource.getRefObjectKey();

				if (refObjectKey != null && !refObjectKey.isEmpty()) {
					if (metaForm.getMergeToSource()) {
						reloadDataObject(refObjectKey);
					}
					metaDataObject = this.getDataObject(refObjectKey);
					metaDataSource.setDataObject(metaDataObject);
				}
			} else {
				if (parentForm != null) {
					metaDataObject.setProject(parentForm.getProject());// 保持马甲Project与源单Project一致
				} else {
					metaDataObject.setProject(metaProject);
				}
			}
		}


		String lockKey = SystemPrefix.LOAD_META_DATAOBJECT+ (metaDataObject == null ? metaForm.getKey() : metaDataObject.getKey());
		try {
			MetaForm pForm = parentForm;
			// dataObject存在多次调用，refDataObject 加载一次，单据模板合并数据源也会调用
			LockUtil.execute(lockKey, () -> {
				return processMetaForm(metaFormProfile, metaForm, metaDataSource, extendFormKey, metaProject, pForm);
			});
		} catch (Throwable e) {
			throw new RuntimeException(e);
		}
	
		return metaForm;
	}

	private MetaForm processMetaForm(MetaFormProfile metaFormProfile, MetaForm metaForm, MetaDataSource metaDataSource, String extendFormKey, MetaProject metaProject, MetaForm parentForm) throws Throwable {
		// 1.如果有继承的父表单,预先处理数据源,因为后续模板处理的需要
		copyDataSource(metaForm, parentForm);

		// 2.模板替换
		MetaFormTemplateProcess templateProcess = new MetaFormTemplateProcess(this, metaForm);
		templateProcess.process();
		
		// 3.继承处理,如果被继承表单未加载,在内部获取时加载
		IFormExtendProcessor processor = newProcessor();
		processor.process(this, metaForm);
		
		// 4.拿到完整的DataObject后处理多语种 T 表
		if (metaDataSource != null) {
			MetaDataObject metaDataObject = metaDataSource.getDataObject();
			metaDataTable_T(metaDataObject);
		}
		// 在读取的时候才去处理内联数据对象需要存储到对象列表中的情况
		if (isEntityForm(metaFormProfile)) {
			addInlineDataObject(metaFormProfile, metaForm, true);
		} else {
			int formType = metaFormProfile.getFormType();
			if (formType < 0 && StringUtils.isBlank(extendFormKey)) {
				if ((metaForm.getFormType() == FormType.Normal) && Objects.nonNull(metaForm.getDataSource())) {
					normalFormProfileList.add(metaFormProfile);
				}
			}
		}

		// 移动处理属性合并之前的预先设置及处理
		MetaFormMergeHandler.preMergeMetaObject(this, metaForm);

		// 后期处理
		try {
			metaForm.doPostProcess(0, newCallBack(DefaultMetaFactory.this, null, metaProject));
		} catch (Throwable e) {
			String message = SimpleStringFormat.format(StringTable.getString(null, "", StringTable.MetaLoadError), MetaForm.TAG_NAME, metaFormProfile.getKey());
			throw new MetaException(MetaException.META_LOAD_ERROR,
					message+"："+e.getMessage(), e);
		}

		return metaForm;
	}

	
	// 修改此方法时，请同步修改T_Form表单
	@Override
	public void getAutoMetaForm(String key, MetaFormList AutoFormList) throws Throwable {
		if (formList.get(key) == null) {
			return;
		}
		MetaForm parentMetaForm = formList.get(key).getForm();
		if (parentMetaForm == null || parentMetaForm.getDataSource() == null) {
			return;
		}
		MetaDataObject metaDataObject = parentMetaForm.getDataSource().getDataObject();
		if (metaDataObject == null || metaDataObject.getTableCollection() == null) {
			return;
		}
		for (MetaTable metaTable : metaDataObject.getTableCollection()) {
			if (metaTable.isT()) {
				continue;
			}
			MetaTable tMetaTable = metaDataObject.getTableCollection().get(metaTable.getKey() + MetaTable._T);
			if (tMetaTable == null) {
				continue;
			}
			boolean onlyName = false;
			if (metaDataObject.getSecondaryType() == DataObjectSecondaryType.DICT || metaDataObject.getSecondaryType() == DataObjectSecondaryType.CHAINDICT
					|| metaDataObject.getSecondaryType() == DataObjectSecondaryType.COMPDICT) {
				if (metaTable.get(SystemField.NAME_DICT_KEY) != null && metaTable.get(SystemField.NAME_DICT_KEY).isSupportI18n()) {
					onlyName = true;
					for (MetaColumn col : metaTable) {
						if (col.isSupportI18n()) {
							if (!col.getKey().equals(SystemField.NAME_DICT_KEY)) {
								onlyName = false;
							}
						}
					}
				}
			}
			if (onlyName) {
				continue;
			}
			MetaForm metaForm = new MetaForm();
			metaForm.setI18n(true);
			MetaFormProfile metaFormProfile = new MetaFormProfile();
			metaFormProfile.setKey((tMetaTable.getKey() + "_F").intern());
			metaFormProfile.setCaption("翻译界面");
			metaFormProfile.setFormType(FormType.Normal);
			metaFormProfile.setExtend("");
			MetaFormProfile parentMetaFormProfile = formList.get(key);
			MetaProject metaProject = (MetaProject) parentMetaFormProfile.getProject();
			metaForm.setProject(metaProject);
			metaFormProfile.setProject(metaProject);
			metaForm.setKey((tMetaTable.getKey() + "_F").intern());
			metaForm.setCaption("翻译界面");
			metaForm.setFormType(FormType.Normal);
			metaForm.setInitState(OperationState.Default);
//			metaForm.setFormulaCaption("Macro_GetCaption()");
			String resource = parentMetaFormProfile.getResource();
			resource = resource.substring(0, resource.lastIndexOf("/") + 1);
			metaFormProfile.setResource(resource + metaForm.getKey() + ".xml");
			metaForm.setResource(metaFormProfile.getResource());
			bulidLangMetaForm(parentMetaForm, metaForm, tMetaTable, metaTable, metaProject);
			// 后期处理
			metaForm.doPostProcess(0, newCallBack(DefaultMetaFactory.this, null, metaProject));
			metaFormProfile.setForm(metaForm);
			AutoFormList.add(metaFormProfile);
		}
	}

	// 修改此方法时，请同步修改T_Form表单
	private void bulidLangMetaForm(MetaForm parentMetaForm, MetaForm metaForm, MetaTable tMetaTable, MetaTable metaTable, MetaProject metaProject) {
		// 窗口的操作定义集合
		MetaOperationCollection metaOperationCollection = new MetaOperationCollection();
		metaOperationCollection.add(newMetaOperation("BillEdit", "修改", "BillEdit"));
		metaOperationCollection.add(newMetaOperation("BillSave", "确定", ""));
		metaOperationCollection.add(newMetaOperation("UIClose", "关闭", "UIClose"));
		metaForm.setOperationCollection(metaOperationCollection);
		// 宏公式集合
		MetaMacroCollection metaMacroCollection = new MetaMacroCollection();
		metaMacroCollection.add(newMetaMacro("Macro_LangSave", "com.bokesoft.erp.i18n.LangFormula.langSave()"));
		metaMacroCollection.add(newMetaMacro("Macro_CheckRepeatLang", "com.bokesoft.erp.i18n.LangFormula.checkRepeatLang()"));
		metaMacroCollection.add(newMetaMacro("Macro_Load", "com.bokesoft.erp.i18n.LangFormula.langLoad(parent.GetPara('fieldKey'))"));
		metaMacroCollection.add(newMetaMacro("Macro_SOID", "com.bokesoft.erp.i18n.LangFormula.getSOID(parent.GetPara('fieldKey'))"));
		metaMacroCollection.add(newMetaMacro("Macro_SrcLangOID", "com.bokesoft.erp.i18n.LangFormula.getSrcLangOID(parent.GetPara('fieldKey'))"));
		metaMacroCollection.add(newMetaMacro("Macro_deleteRow", "com.bokesoft.erp.i18n.LangFormula.deleteFirstRow()"));
		metaMacroCollection.add(newMetaMacro("Macro_Lang", "com.bokesoft.erp.i18n.LangFormula.getLang()"));
		metaMacroCollection.add(newMetaMacro("Macro_Enable", "com.bokesoft.erp.i18n.LangFormula.setEnable()"));
//		metaMacroCollection.add(newMetaMacro("Macro_GetCaption", "com.bokesoft.erp.i18n.LangFormula.getCaption()"));
		metaForm.setMacroCollection(metaMacroCollection);
		// 窗口的数据源配置对象
		MetaDataSource metaDataSource = new MetaDataSource();
		MetaDataObject metaDataObject = new MetaDataObject();
		metaDataObject.setI18n(true);
		metaDataObject.setKey(tMetaTable.getKey());
		metaDataObject.setProject(metaProject);
		metaDataObject.setPrimaryType(DataObjectPrimaryType.ENTITY);
		metaDataObject.setCaption(tMetaTable.getCaption());
		// metaDataObject.setMainTableKey(metaTable.getKey());
		MetaTableCollection metaTableCollection = new MetaTableCollection();
		metaTableCollection.add(tMetaTable);
		metaDataObject.setTableCollection(metaTableCollection);
		metaDataSource.setDataObject(metaDataObject);
		metaForm.setDataSource(metaDataSource);
		// 表单窗体对象
		MetaBody metaBody = new MetaBody();
		MetaBlock metaBlock = new MetaBlock();
		// 根组件
		MetaFlexFlowLayoutPanel panel = new MetaFlexFlowLayoutPanel();
		panel.setKey("main");
		panel.setCaption("根面板");
		// 子控件集合，包含该控件范围内的所有子控件
		MetaToolBar metaToolBar = new MetaToolBar();
		metaToolBar.setKey("main_toolbar");
		metaToolBar.setCaption("main_toolbar");
		MetaGrid metaGrid = new MetaGrid();
		metaGrid.setKey("HeadGrid1");
		metaGrid.setCaption("HeadGrid1");
		metaGrid.setHeight(new DefSize(DefSize.Ratio, 100));
		MetaBaseScript onRowDeleteScript = new MetaBaseScript("onRowDelete");
		onRowDeleteScript.setContent("IIF(Macro_deleteRow(),DeleteRow(),'')");
		metaGrid.setOnRowDelete(onRowDeleteScript);
		metaGrid.setDisabledOption("shift,variantSet,export,sum,groupSum");
		// 列元数据集合
		MetaGridColumnCollection metaGridColumnCollection = new MetaGridColumnCollection();
		metaGridColumnCollection.add(newMetaGridColumn("IsSelect1", "选择"));
		metaGridColumnCollection.add(newMetaGridColumn("OID", "OID"));
		metaGridColumnCollection.add(newMetaGridColumn("SOID", "SOID"));
		metaGridColumnCollection.add(newMetaGridColumn("SrcLangOID", "SrcLangOID"));
		metaGridColumnCollection.add(newMetaGridColumn("IsEnvLang", "IsEnvLang"));
		metaGridColumnCollection.add(newMetaGridColumn("Lang", "语言"));
		for (MetaColumn col : metaTable) {
			if (col.isSupportI18n()) {
				metaGridColumnCollection.add(newMetaGridColumn(col.getKey(), col.getCaption()));
			}
		}
		metaGrid.setColumnCollection(metaGridColumnCollection);
		// 行元数据集合
		MetaGridRowCollection metaGridRowCollection = new MetaGridRowCollection();
		MetaGridRow metaGridRow = new MetaGridRow();
		metaGridRow.setKey("row1");
		metaGridRow.setTableKey(tMetaTable.getKey());
		metaGridRow.add(newMetaGridCell("IsSelect1", "选择", ControlType.CHECKBOX, false));
		metaGridRow.add(newMetaGridCell("OID", "OID", ControlType.NUMBEREDITOR, true));
		metaGridRow.add(newMetaGridCell("SOID", "SOID", ControlType.NUMBEREDITOR, true));
		metaGridRow.add(newMetaGridCell("SrcLangOID", "SrcLangOID", ControlType.NUMBEREDITOR, true));
		metaGridRow.add(newMetaGridCell("IsEnvLang", "IsEnvLang", ControlType.NUMBEREDITOR, true));
		metaGridRow.add(newMetaGridCell("Lang", "语言", ControlType.COMBOBOX, true));
		for (MetaColumn col : metaTable) {
			if (col.isSupportI18n()) {
				if (col.getDataType() == DataType.STRING || col.getDataType() == DataType.TEXT) {
					metaGridRow.add(newMetaGridCell(parentMetaForm, col));
				}
			}
		}
		metaGridRowCollection.add(metaGridRow);
		metaGrid.setRowCollection(metaGridRowCollection);

		panel.addComponent(metaToolBar);
		panel.addComponent(metaGrid);
		metaBlock.setRoot(panel);
		metaBody.add(0, metaBlock);
		metaForm.setMetaBody(metaBody);
		// OnLoad事件定义
		MetaBaseScript script = new MetaBaseScript("OnLoad");
		script.setContent("Macro_Load();IIF(!parent.ReadOnly(), EditBill())");
		metaForm.setOnLoad(script);
	}

	private MetaOperation newMetaOperation(String key, String caption, String refKey) {
		MetaOperation metaOperation = new MetaOperation();
		metaOperation.setKey(key.intern());
		metaOperation.setCaption(caption.intern());
		metaOperation.setRefKey(refKey.intern());
		if (key.equals("BillSave")) {
			metaOperation.setEnable("!parent.ReadOnly()&&!ReadOnly()");
			MetaBaseScript metaBaseScript = new MetaBaseScript("Action");
			metaBaseScript.setContent("Macro_LangSave();ResetEditBill()");
			metaOperation.setAction(metaBaseScript);
		}
		if (key.equals("BillEdit")) {
			metaOperation.setEnable("!parent.ReadOnly()&&ReadOnly()");
		}
		return metaOperation;
	}

	private MetaMacro newMetaMacro(String key, String content) {
		MetaMacro metaMacro = new MetaMacro();
		metaMacro.setKey(key);
		metaMacro.setContent(content);
		return metaMacro;
	}

	private MetaGridColumn newMetaGridColumn(String key, String caption) {
		MetaGridColumn metaGridColumn = new MetaGridColumn();
		metaGridColumn.setKey(key.intern());
		metaGridColumn.setOldKey(key.intern());
		metaGridColumn.setCaption(caption.intern());
		if (key.equals("OID") || key.equals("SOID") || key.equals("SrcLangOID") || key.equals("IsEnvLang")) {
			metaGridColumn.setVisible("false");
		}
		if (key.equals(SystemField.Lang_SYS_KEY)) {
			metaGridColumn.setWidth(new DefSize(DefSize.Fix, 100));
		}
		return metaGridColumn;
	}

	private MetaGridCell newMetaGridCell(String key, String caption, int cellType, boolean isDataBinding) {
		MetaGridCell metaGridCell = new MetaGridCell();
		metaGridCell.setKey(key.intern());
		metaGridCell.setCaption(caption.intern());
		metaGridCell.setCellType(cellType);
		if (key.equals("IsSelect1")) {
			metaGridCell.setSelect(true);
		}
		if (isDataBinding) {
			MetaDataBinding metaDataBinding = new MetaDataBinding();
			metaDataBinding.setColumnKey(key);
			if (key.equals(SystemField.SOID_SYS_KEY)) {
				metaDataBinding.setDefaultFormulaValue("Macro_SOID()");
			} else if (key.equals(SystemField.SrcLangOID_SYS_KEY)) {
				metaDataBinding.setDefaultFormulaValue("Macro_SrcLangOID()");
			} else if (key.equals(SystemField.Lang_SYS_KEY)) {
				metaDataBinding.setCheckRule("Macro_CheckRepeatLang()");
			}
			metaGridCell.setDataBinding(metaDataBinding);
		}
		if (key.equals(SystemField.Lang_SYS_KEY)) {
			MetaComboBoxProperties properties = new MetaComboBoxProperties();
			properties.setSourceType(ComboBoxSourceType.FORMULA);
			MetaBaseScript script = new MetaBaseScript("formulaItems");
			script.setContent("Macro_Lang()");
			properties.setFormulaItems(script);
			metaGridCell.setProperties(properties);
			metaGridCell.setEnable("IIF(!ReadOnly(), Macro_Enable()&&!parent.ReadOnly())");
		} else if (key.equals(SystemField.IsEnvLang_SYS_KEY)) {
			MetaNumberEditorProperties properties = new MetaNumberEditorProperties();
			properties.setPrecision(9);
			metaGridCell.setProperties(properties);
		}
		return metaGridCell;
	}

	private MetaGridCell newMetaGridCell(MetaForm parentMetaForm, MetaColumn col) {
		MetaGridCell metaGridCell = new MetaGridCell();
		String key = col.getKey();
		metaGridCell.setKey(key.intern());
		metaGridCell.setCaption(col.getCaption().intern());
		metaGridCell.setCellType(ControlType.TEXTEDITOR);

		MetaDataBinding metaDataBinding = new MetaDataBinding();
		metaDataBinding.setColumnKey(key);
		metaDataBinding.setValueChanged("IIF(Lang == GetLocale(), parent.SetValue('"+key+"',"+key+"))".intern());
		if (parentMetaForm.getComponentMap() != null && parentMetaForm.getComponentMap().get(key) != null) {
			String formulaValue = parentMetaForm.getComponentMap().get(key).getDefaultFormulaValue();
			if (!formulaValue.isEmpty()) {
				metaDataBinding.setDefaultFormulaValue(formulaValue.intern());
			}
		}
		metaGridCell.setDataBinding(metaDataBinding);
		return metaGridCell;
	}

	public MetaTaskFlow getTaskFlow(String key) throws Throwable {
		MetaTaskFlow metaTaskFlow = null;
		MetaTaskFlowProfile metaTaskFlowProfile = taskFlowList.get(key);
		if (metaTaskFlowProfile != null) {
			metaTaskFlow = metaTaskFlowProfile.getTaskFlow();
			if (metaTaskFlow == null) {
				MetaProject metaProject = (MetaProject) metaTaskFlowProfile.getProject();
				IMetaResolver projectResourceResolver = projectResolverMap.get(metaProject.getKey());
				if (projectResourceResolver == null) {
					throw new MetaException(MetaException.PROJECT_RESOLVER_UNDEFINED,
							SimpleStringFormat.format(StringTable.getString(null, "", StringTable.ProjectResolverUndefined), metaProject.getKey()));
				}

				MetaTaskFlowLoad flowLoad = new MetaTaskFlowLoad(AppRunType.App);
				flowLoad.load(projectResourceResolver, metaTaskFlowProfile.getResource());
				metaTaskFlow = (MetaTaskFlow) flowLoad.getRootMetaObject();
				metaTaskFlow.setProject(metaProject);
				metaTaskFlowProfile.setTaskFlow(metaTaskFlow);
			}
		}

		return metaTaskFlow;
	}

	private IFormExtendProcessor newProcessor() throws Throwable {
		if (setting != null) {
			MetaSimpleSetting mss = setting.getSimpleSetting("MetaFormExtendProcessor");
			if (mss != null) {
				String impl = mss.get("Impl");
				if (impl != null && !impl.isEmpty()) {
					return (IFormExtendProcessor) ReflectUtil.newInstance(impl);
				}
			}
		}
		return new DefaultFormExtendProcessor();
	}

	/**
	 * 处理马甲数据源,DataObject要么全部引用,保持key一致,要么自己定义
	 */
	private static void copyDataSource(MetaForm metaForm, MetaForm parentForm) throws Throwable {
		if (parentForm == null) {
			return;
		}
		MetaDataSource ds1 = parentForm.getDataSource();
		if (ds1 != null) {
			MetaDataSource ds2 = metaForm.getDataSource();
			if (ds1.getRefObjectKey() != null && !ds1.getRefObjectKey().isEmpty() && metaForm.getMergeToSource()) {
				return;
			} else {
				if (ds2 == null) {
					metaForm.setDataSource((MetaDataSource) ds1.depthClone());
				} else {
					if (metaForm.getMergeToSource()) {
						ds1.merge4Diff(ds2);
						metaForm.setDataSource((MetaDataSource) ds1.depthClone());
					} else {
						ds2.merge(ds1);
					}
				}
			}
		}
	}

	private static Callback<AbstractMetaObject, Boolean> newCallBack(IMetaFactory metaFactory, String solutionKey, IMetaProject metaProject){
		return new Callback<AbstractMetaObject, Boolean>() {

			@Override
			public Boolean call(AbstractMetaObject param) throws Throwable {
				String projectKey = "";
				if (metaProject != null) {
					projectKey = metaProject.getKey();
				}
				if (param instanceof MetaDictProperties) {
					((MetaDictProperties) param).calItemKey(projectKey);
				} else if (param instanceof MetaForm) {
					MetaFormMergeHandler.mergeCommonPropertiesWithMobileDef(metaFactory, (MetaForm) param);
				} else if (param instanceof MetaColumn) {
					String dataElementKey = ((MetaColumn) param).getDataElementKey();
					MetaDataElement dataElement = metaFactory.getDataElementDef(solutionKey).getDataElement(dataElementKey);
					if (dataElement == null) {
						throw new MetaException(MetaException.NO_DATAELEMENT_DEFINED,
								SimpleStringFormat.format(StringTable.getString(null, "", StringTable.NoDataElementDefined), dataElementKey));
					}
					((MetaColumn) param).setDataElement(dataElement);
				}
				return true;
			}
		};
	}

	@Deprecated
	@Override
	public MetaRelationList getRelationList() {
		return relationList;
	}

	public boolean hasMetaRelation(String key) {
		return relationList.containsKey(key);
	}

	@Deprecated
	public MetaMappingList getMappingList() {
		return mappingList;
	}

	@Override
	public MetaMapping getMapping(String key) throws Throwable {
		MetaMappingProfile profile = mappingList.get(key);
		MetaMapping mapping = null;
		if (profile != null) {
			mapping = profile.getMeta();
			if (mapping == null) {
				// 全加载
				MetaProject metaProject = (MetaProject) profile.getProject();
				IMetaResolver projectResourceResolver = projectResolverMap.get(metaProject.getKey());
				MetaMappingLoad load = new MetaMappingLoad(AppRunType.App);
				load.load(projectResourceResolver, profile.getResource());
				mapping = (MetaMapping) load.getRootMetaObject();
				profile.setMeta(mapping);
			}
		}
		return mapping;
	}

	@Override
	public MetaRelationPath getMetaRelationPath(String key) throws Throwable {
		MetaRelationPath relationPath = new MetaRelationPath();
		MetaRelationProfile profile = relationList.get(key);
		if (profile != null) {
			relationPath = profile.getRelationPath();
		}

		if (relationPath == null && profile != null) {
			MetaProject metaProject = (MetaProject) profile.getProject();
			IMetaResolver projectResourceResolver = projectResolverMap.get(metaProject.getKey());
			MetaRelationPathLoad relationLoad = new MetaRelationPathLoad(AppRunType.App);
			relationLoad.load(projectResourceResolver, profile.getResource());
			relationPath = (MetaRelationPath) relationLoad.getRootMetaObject();
		}
		return relationPath;
	}

	@Override
	public MetaSecurityFilter getSecurityFilter(String project) throws Throwable {
		MetaSecurityFilter securityFilter = null;
		if (project == null || project.isEmpty()) {
			securityFilter = solutionFilter;
		} else {
			MetaProject metaProject = this.getMetaProject(project);
			if (metaProject != null) {
				securityFilter = metaProject.getSecurityFilter();
			}
		}

		return securityFilter;
	}

	private void addInlineDataObject(MetaFormProfile metaFormProfile, MetaForm metaForm, boolean errorFlag) throws Throwable {
		if (metaFormProfile.getMergeToSource()) {
			// 合并至原单的马甲不需要处理
			return;
		}
		MetaDataSource metaDataSource = metaForm.getDataSource();
		if (metaDataSource != null) {
			String refDataObjectKey = metaDataSource.getRefObjectKey();
			// 只有独立引用的情况下才去读取数据源
			if (refDataObjectKey == null || refDataObjectKey.isEmpty()) {
				MetaDataObject metaDataObject = metaDataSource.getDataObject();
				if (metaDataObject != null) {
					IMetaProject project = metaFormProfile.getProject();
					metaDataObject.setProject(metaFormProfile.getProject());
					metaDataObject.setVersion(metaForm.getVersion());
					MetaDataObjectProfile metaDataObjectProfile = new MetaDataObjectProfile();
					metaDataObjectProfile.setProject(project);
					metaDataObjectProfile.setKey(metaDataObject.getKey());
					metaDataObjectProfile.setCaption(metaDataObject.getCaption());
					metaDataObjectProfile.setDataObject(metaDataObject);
					metaDataObjectProfile.setFormKey(metaFormProfile.getKey());
					metaDataObjectProfile.setPrimaryType(metaDataObject.getPrimaryType());
					metaDataObjectProfile.setSecondaryType(metaDataObject.getSecondaryType());

					if (dataObjectList.containsKey(metaDataObjectProfile.getKey())) {
						MetaDataObjectProfile tmpDataObjectProfile = dataObjectList.get(metaDataObjectProfile.getKey());
						IMetaProject tmpProject = tmpDataObjectProfile.getProject();
						if (errorFlag) {
							throw new MetaException(MetaException.REPEAT_DATAOBJECT_DEFINED,
									SimpleStringFormat.format(
											StringTable.getString(null, "", StringTable.RepeatDataObjectDefined),
											project.getKey(), metaFormProfile.getKey(), metaDataObjectProfile.getKey(),
											tmpProject.getKey(), tmpDataObjectProfile.getFormKey()));
						}
					} else {
						dataObjectList.add(metaDataObjectProfile);
					}
				}
			}
		}
	}

	@Override
	public MetaCommonDef getCommonDef(String project) throws Throwable {
		MetaCommonDef commonDef = null;
		if (project == null || project.isEmpty()) {
			commonDef = solutionCommonDef;
		} else {
			MetaProject metaProject = this.getMetaProject(project);
			if (metaProject != null) {
				commonDef = metaProject.getCommonDef();
			}
		}
		return commonDef;
	}

	@Override
	public MetaMobileDef getMobileDef(String project) throws Throwable {
		MetaMobileDef metaMobileDef = null;
		if (project == null || project.isEmpty()) {
			metaMobileDef = solutionMobileDef;
		} else {
			MetaProject metaProject = getMetaProject(project);
			if (metaProject != null) {
				metaMobileDef = metaProject.getMobileDef();
			}
		}
		return metaMobileDef;
	}

	@Override
	public MetaEnhance getEnhance(String project) throws Throwable {
		MetaEnhance enhance = null;
		if (project == null || project.isEmpty()) {
			enhance = solutionEnhance;
		} else {
			MetaProject metaProject = this.getMetaProject(project);
			if (metaProject != null) {
				enhance = metaProject.getEnhance();
			}
		}
		return enhance;
	}

	@Override
	public MetaEntry getMetaEntry(String key) throws Throwable {
		MetaProjectProfile metaProjectProfile = solution.getProjectCollection().get(key);
		return metaProjectProfile.getEntry();
	}

	@Override
	public MetaEntryItem getMetaEntryItem(String entryPath) throws Throwable {
		String[] paths = entryPath.split("[/]");
		String projectKey = paths[0];

		MetaProjectProfile metaProjectProfile = solution.getProjectCollection().get(projectKey);
		if (metaProjectProfile == null) {
			return null;
		}

		MetaEntry metaEntry = this.getMetaEntry(projectKey);

		AbstractCompositeObject obj = null;
		MetaEntryItem metaEntryItem = null;
		for (int i = 1; i < paths.length; i++) {
			String key = paths[i];
			obj = metaEntry.findChild(key);

			if (obj == null) {
				break;
			}

			if (obj.getCompositeType() == MetaEntryItem.ENTRY) {
				metaEntry = (MetaEntry) obj;
			} else if (obj.getCompositeType() == MetaEntryItem.ENTRY_ITEM) {
				if (i == paths.length - 1) {
					metaEntryItem = (MetaEntryItem) obj;
				} else {
					break;
				}
			} else {
				break;
			}
		}

		return metaEntryItem;
	}

	private HashMap<String, IExtendMetaFactory> extendMap = new HashMap<String, IExtendMetaFactory>();

	@Override
	public IExtendMetaFactory getExtendMetaFactory(String tag) throws Throwable {
		return extendMap.get(tag);
	}

	@Override
	public void putExtendMetaFactory(String tag, IExtendMetaFactory factory) throws Throwable {
		extendMap.put(tag, factory);
	}

	@Override
	public InputStream loadResource(String resource) throws Throwable {
		return primarySolutionResourceResolver.read(resource, -1);
	}

	@Override
	public InputStream loadResource(String resource, String projectKey) throws Throwable {
		// 在非多solution环境，则获取主solution的resource
		if (resolverFactoryMap.size() == 0) {
			return this.loadResource(resource);
		}
		IMetaResolverFactory resolverFactory = this.getMetaResolverFactory(projectKey);
		// 在多solution的环境，当前所在的solution就是MainSolution
		if (resolverFactory == null) {
			return this.loadResource(resource);
		}
		IMetaResolver metaResolver = resolverFactory.newMetaResolver("");
		InputStream inputStream = metaResolver.read(resource, -1);
		// 在多solution的环境，在当前的solution的resouce中没有找到所要的图片，就到主Solution中查找
		if (inputStream == null) {
			return this.loadResource(resource);
		}
		return inputStream;
	}

	@Override
	public URI getResourceURI(String resource) throws Throwable {
		return primarySolutionResourceResolver.getURI(resource, -1);
	}


	@Override
	public MetaDataObject getDataObject(String key) throws Throwable {
		MetaDataObjectProfile metaDataObjectProfile = dataObjectList.get(key);
		MetaDataObject metaDataObject = null;
		if (metaDataObjectProfile != null) {

			metaDataObject = metaDataObjectProfile.getDataObject();
			//if (metaDataObject == null) {
			String lockKey = SystemPrefix.LOAD_META_DATAOBJECT + key;
			metaDataObject = LockUtil.execute(lockKey, () -> {
				MetaDataObject meta = metaDataObjectProfile.getDataObject();
				if (meta != null) {
					return meta;
				}
				meta = loadMetaDataObject(metaDataObjectProfile);
				if (meta != null) {
					metaDataObjectProfile.setDataObject(meta);
				}
				return meta;
			});
			//}
		}

		return metaDataObject;
	}

	private MetaDataObject loadMetaDataObject(MetaDataObjectProfile metaDataObjectProfile) throws Throwable {
		String key = metaDataObjectProfile.getKey();
		MetaDataObject metaDataObject = null;
		String profileExtend = metaDataObjectProfile.getExtend();
		MetaProject metaProject = (MetaProject) metaDataObjectProfile.getProject();
		IMetaResolver projectResourceResolver = projectResolverMap.get(metaProject.getKey());

		MetaDataObject parentDataObject = null;
		String extendDataObjectKey = profileExtend;
		if (extendDataObjectKey != null && !extendDataObjectKey.isEmpty()) {
			parentDataObject = this.getDataObject(extendDataObjectKey);
		}
		MetaDataObjectLoad load = new MetaDataObjectLoad(AppRunType.App);
		load.load(projectResourceResolver, metaDataObjectProfile.getResource());
		metaDataObject = (MetaDataObject) load.getRootMetaObject();
		if (parentDataObject != null) {
			String mergeToSourceMapKey = parentDataObject.getMergeToSourceMapKey();
			if (StringUtils.isNotEmpty(mergeToSourceMapKey)) {
				if (!mergeToSourceMapKey.equals(key)) {
					throw new RuntimeException("数据对象配置有误！原因：" + parentDataObject.getKey() + "数据对象存在了两个马甲");
				}
			}
			MetaDataObjectTemplateProcess templateProcess = new MetaDataObjectTemplateProcess(this, metaDataObject);
			templateProcess.process();
			metaDataObject.doPostProcess(0, new Callback<AbstractMetaObject, Boolean>() {
				@Override
				public Boolean call(AbstractMetaObject param) throws Throwable {
					if (param instanceof MetaDataObject) {
						((MetaDataObject) param).calcMigrationExtension(DefaultMetaFactory.this);
					} else if (param instanceof MetaColumn) {
						String dataElementKey = ((MetaColumn) param).getDataElementKey();
						MetaDataElement dataElement = DefaultMetaFactory.this.getDataElementDef("").getDataElement(dataElementKey);
						if (dataElement == null) {
							throw new MetaException(MetaException.NO_DATAELEMENT_DEFINED, SimpleStringFormat.format(
									StringTable.getString(null, "", StringTable.NoDataElementDefined), dataElementKey));
						}
						((MetaColumn) param).setDataElement(dataElement);
					}
					return true;
				}

			});
			parentDataObject.merge(metaDataObject);
			metaDataObject = (MetaDataObject) parentDataObject.depthClone();
			metaDataObject.setKey(key);
			metaDataObject.setExtend(parentDataObject.getKey());
			parentDataObject.setMergeToSourceMapKey(key);
		} else {
			metaDataObject.setProject(metaProject);
			MetaDataObjectTemplateProcess templateProcess = new MetaDataObjectTemplateProcess(this, metaDataObject);
			templateProcess.process();
			metaDataObject.doPostProcess(0, new Callback<AbstractMetaObject, Boolean>() {
				@Override
				public Boolean call(AbstractMetaObject param) throws Throwable {
					if (param instanceof MetaDataObject) {
						((MetaDataObject) param).calcMigrationExtension(DefaultMetaFactory.this);
					} else if (param instanceof MetaColumn) {
						String dataElementKey = ((MetaColumn) param).getDataElementKey();
						MetaDataElement dataElement = DefaultMetaFactory.this.getDataElementDef().getDataElement(dataElementKey);
						if (dataElement == null) {
							throw new MetaException(MetaException.NO_DATAELEMENT_DEFINED, SimpleStringFormat.format(
									StringTable.getString(null, "", StringTable.NoDataElementDefined), dataElementKey));
						}
						((MetaColumn) param).setDataElement(dataElement);
					}
					return true;
				}

			});
		}
		mergeDiffMeta4FormAndDataObject(metaDataObject.getKey(), metaDataObject, MetaDataObject.TAG_NAME);
		metaDataObjectProfile.setDataObject(metaDataObject);
		metaDataObject = metaDataTable_T(metaDataObject);
		return metaDataObject;
	}

	private void getAutoDataObject(MetaTableCollection newMetaTableCollection, MetaTable metaTable) {
		MetaTable newMetaTable = null;
		boolean i18n = false;
		for (MetaColumn col : metaTable) {
			if (col.isSupportI18n()) {
				i18n = true;
				MetaColumn clone = (MetaColumn) col.clone();
				clone.setPersist(true);
				clone.setSupportI18n(false);
				clone.setCache(true);
				if (newMetaTable == null) {
					newMetaTable = new MetaTable();
				}
				newMetaTable.add(clone);
				col.setPersist(false);
			}
		}
		if (i18n) {
			newMetaTable.setT(true);
			newMetaTable.setKey((metaTable.getKey() + MetaTable._T).intern());
			newMetaTable.setCaption((metaTable.getCaption() + "翻译表").intern());
			newMetaTable.setPersist(true);
			newMetaTable.setTableMode(TableMode.DETAIL);
			newMetaTable.setIndexPrefix((metaTable.getKey() + MetaTable._T).intern());
			newMetaColumn(newMetaTable, SystemField.OID_SYS_KEY, "", DataType.LONG);
			newMetaColumn(newMetaTable, SystemField.SOID_SYS_KEY, "", DataType.LONG);
			newMetaColumn(newMetaTable, SystemField.POID_SYS_KEY, "", DataType.LONG);
			newMetaColumn(newMetaTable, SystemField.VERID_SYS_KEY, "", DataType.INT);
			newMetaColumn(newMetaTable, SystemField.DVERID_SYS_KEY, "", DataType.INT);
			newMetaColumn(newMetaTable, SystemField.SEQUENCE_SYS_KEY, "", DataType.INT);
			newMetaColumn(newMetaTable, SystemField.SELECT_FIELD_KEY, "", DataType.INT);
			newMetaColumn(newMetaTable, "SrcLangOID", "SrcLangOID", DataType.LONG);
			newMetaColumn(newMetaTable, "Lang", "语言", DataType.STRING);
			newMetaColumn(newMetaTable, "IsEnvLang", "IsEnvLang", DataType.INT);
			newMetaColumn(newMetaTable, SystemField.LASTMODIFIED_SYS_KEY, "", DataType.LONG);
			
            MetaColumn lastModified = newMetaTable.getLastModified();
            if(lastModified == null) {
            	lastModified = new MetaColumn();
            	lastModified.setKey(SystemField.LASTMODIFIED_SYS_KEY);
            	lastModified.setDataType(DataType.LONG);
            	lastModified.setDefaultValue("0");
            	lastModified.setPersist(true);
            	lastModified.setAutoGen(true);
            	newMetaTable.add(lastModified);
            }
			
			newMetaTable.doPostProcess(0, null);
			newMetaTableCollection.add(newMetaTable);
		}
	}

	private MetaColumn newMetaColumn(MetaTable metaTable, String key, String caption, int dataType) {
		MetaColumn column = new MetaColumn();
		column.setKey(key.intern());
		column.setCaption(caption.intern());
		column.setDataType(dataType);
		column.setCache(true);
		if (!key.equals("SrcLangOID") && !key.equals(SystemField.Lang_SYS_KEY)) {
			column.setAutoGen(true);
		}
		if (dataType == DataType.STRING) {
			column.setLength(30);
		}
		if (key.equals(SystemField.SELECT_FIELD_KEY)) {
			column.setPersist(false);
			column.setIgnoreQuery(true);
			column.setCache(false);
		}
		metaTable.add(column);
		return column;
	}

	/**
	 * 处理T表
	 * @param metaDataObject 要处理的数据对象
	 * @return
	 */
	private MetaDataObject metaDataTable_T(MetaDataObject metaDataObject) throws Throwable{
		if (metaDataObject != null && metaDataObject.getTableCollection() != null && metaDataObject.getTableCollection().size() > 0) {
			String key = metaDataObject.getKey();
			String lockKey = SystemPrefix.LOAD_META_DATAOBJECT + key;
			LockUtil.execute(lockKey, () -> {
				MetaTableCollection newMetaTableCollection = new MetaTableCollection();
				metaDataObject.getTableCollection().forEach(metaTable -> {
					if (metaTable.getKey().endsWith(MetaTable._T)) {
						return;
					}
					if (!metaDataObject.getTableCollection().containsKey(metaTable.getKey() + MetaTable._T)) {
						getAutoDataObject(newMetaTableCollection, metaTable);
					}
				});

				newMetaTableCollection.forEach(metaTable -> {
					if (metaTable.isT()) {
						metaDataObject.getTableCollection().add(metaTable);
					}
				});
				return true;
			});
		}
		return metaDataObject;
	}

	@Override
	public MetaDataMigration getDataMigration(String key) throws Throwable {
		MetaDataMigration metaDataMigration = null;
		MetaDataMigrationProfile metaDataMigrationProfile = migrationList.get(key);
		if (metaDataMigrationProfile != null) {
			metaDataMigration = metaDataMigrationProfile.getDataMigration();
			String profileExtend = metaDataMigrationProfile.getExtend();

			if (metaDataMigration == null && metaDataMigrationProfile != null) {
				MetaProject project = (MetaProject) metaDataMigrationProfile.getProject();
				IMetaResolver iMetaResolver = projectResolverMap.get(project.getKey());
				MetaDataMigration parentDataMigration = null;
				String extendDataMigrationKey = profileExtend;
				if (extendDataMigrationKey != null && !extendDataMigrationKey.isEmpty()) {
					parentDataMigration = this.getDataMigration(extendDataMigrationKey);
				}
				MetaDataMigrationLoad metaDataMigrationLoad = new MetaDataMigrationLoad(AppRunType.App);
				metaDataMigrationLoad.load(iMetaResolver, metaDataMigrationProfile.getResource());
				metaDataMigration = (MetaDataMigration) metaDataMigrationLoad.getRootMetaObject();
				if (parentDataMigration != null) {
					String mergeToSourceMapKey = parentDataMigration.getMergeToSourceMapKey();
					if (StringUtils.isNotEmpty(mergeToSourceMapKey)) {
						if (!mergeToSourceMapKey.equals(key)) {
							throw new RuntimeException("数据迁移配置有误！原因：" + parentDataMigration.getKey() + "数据迁移存在了两个马甲");
						}
					}
					parentDataMigration.merge(metaDataMigration);
					metaDataMigration = (MetaDataMigration) parentDataMigration.depthClone();
					metaDataMigration.setKey(key);
					metaDataMigration.setExtend(parentDataMigration.getKey());
					parentDataMigration.setMergeToSourceMapKey(key);
				} else {
					// TODO: mergeDiffMeta4Migration(metaDataMigration);
					metaDataMigration.setProject(project);
				}

				metaDataMigrationProfile.setDataMigration(metaDataMigration);
				metaDataMigration.doPostProcess(0, newCallBack(DefaultMetaFactory.this, null, project));

			}
		}
		if (metaDataMigration == null) {
			throw new MetaException(MetaException.NO_DATA_MIGRATION_DEFINDE,
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.NoDataMigrationDefined)));
		}
		return metaDataMigration;
	}

	@Deprecated
	@Override
	public MetaDataMigrationList getDataMigrationList() throws Throwable {
		return migrationList;
	}

	@Override
	public MetaDataObjectList getDataObjectList() throws Throwable {
		return dataObjectList;
	}

	public MetaRelationCheck getRelationCheck() {
		return relationCheck;
	}

	@Deprecated
	@Override
	public MetaDataMapList getDataMapList() {
		return dataMapList;
	}

	@Override
	public MetaMap getDataMap(String key) throws Throwable {
		MetaDataMapProfile profile = dataMapList.get(key);
		if (profile != null) {
			MetaMap dataMap = profile.getDataMap();
			return dataMap;
		} else {
			throw new MetaException(MetaException.NO_DATAMAP,
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.NoDataMap), key));
		}
	}

	@Override
	public InputStream loadInputStream(String project, String resource) throws Throwable {
		InputStream in = null;
		IMetaResolver projectResourceResolver = projectResolverMap.get(project);
		in = projectResourceResolver.read(resource, -1);
		return in;
	}

	public MetaBPM getMetaBPM() throws Throwable {
		return metaBPM;
	}

	@Override
	public MetaProcess getBPMProcess(String formKey) throws Throwable {
		if (this.metaBPM != null) {
			MetaForm metaForm = this.getMetaForm(formKey);
			MetaProcessMap pm = this.metaBPM.getMetaProcessMapCollection().getDataobjectMapInfo(metaForm.getDataSource().getDataObject().getRelateObjectKey());
			if (pm != null) {
				return this.getProcessDefinationByDeployKey(pm.getProcessKey());
			}
		}
		return null;
	}

	@Override
	public void reloadMetaBPM() throws Throwable {
		metaBPM = new MetaBPM();
		for (MetaProjectProfile metaProjectProfile : solution.getProjectCollection()) {
			MetaProject project = metaProjectProfile.getProject();
			String solutionKey = getSolutionKey(project.getKey());
			IMetaResolverFactory iMetaResolverFactory = resolverFactoryMap.get(solutionKey);
			IMetaResolver resolver = iMetaResolverFactory.newMetaResolver("");
			MetaBPMReferenceScanLoad BPMScanLoad = new MetaBPMReferenceScanLoad(metaBPM, resolver, project,null, AppRunType.App);
			BPMScanLoad.load();
		}
	}


	public MetaProcess getProcessDefinationByDeployKey(String processKey) throws Throwable {
		MetaProcessDeployInfo deployInfo = metaBPM.getMetaBPMDeployInfoCollection().get(processKey);
		if (deployInfo == null)
			return null;
		String key = deployInfo.getKey() + "_V" + deployInfo.getVersion();

		ProcessDefinitionProfile profile = metaBPM.getProfileMap().get(key);
		if (profile == null)
			return null;

		if (profile.getDefination() == null) {
			profile.setDefination(loadProcess(profile));
		}
		return profile.getDefination();
	}

	public MetaProcess getProcessDefinationBy(String processKey, int verID) throws Throwable {
		String key = processKey + "_V" + verID;
		ProcessDefinitionProfile profile = metaBPM.getProfileMap().get(key);
		if (profile == null)
			return null;

		if (profile.getDefination() == null) {
			profile.setDefination(loadProcess(profile));
		}
		return profile.getDefination();
	}

	public void updateProcessDefination(String processKey, int verID) throws Throwable {
		String key = processKey + "_V" + verID;
		ProcessDefinitionProfile profile = metaBPM.getProfileMap().get(key);
		if (profile == null)
			return;
		profile.setDefination(loadProcess(profile));
	}

	public void updateProcessDefinationByDeployKey(String processKey) throws Throwable {
		MetaProcessDeployInfo deployInfo = metaBPM.getMetaBPMDeployInfoCollection().get(processKey);
		if (deployInfo == null)
			return;
		String key = deployInfo.getKey() + "_V" + deployInfo.getVersion();
		ProcessDefinitionProfile profile = metaBPM.getProfileMap().get(key);
		if (profile == null)
			return;
		profile.setDefination(loadProcess(profile));
	}

	protected MetaProcess loadProcess(ProcessDefinitionProfile profile) throws Throwable {
		ProcessSourceFactory factory = new ProcessSourceFactory(projectResolverMap, profile);
		IProcessSource processSource = factory.getProcessSource();
		if (processSource == null) {
			return null;
		}
		return processSource.loadProcess(profile.getDefinationJson());
	}

	@Override
	public MetaReportSubList getReportSubList(String subKey) throws Throwable {
		return this.reportList.get(subKey);
	}
	@Override
	public MetaReportList getMetaReportList() throws Throwable {
		return this.reportList;
	}
	@Override
	public MetaExcelTemplateList getMetaExcelTemplateList() throws Throwable {
		return this.excelTemplateList;
	}

	@Override
	public MetaReport getReport(String group, String subKey, String reportKey) throws Throwable {
		MetaReport metaReport = null;
		MetaReportSubList subList = this.reportList.get(subKey);
		Iterator<MetaReportProfile> it = subList.iterator();
		MetaReportProfile profile = null;
		MetaReportProfile matchProfile = null;
		while (it.hasNext()) {
			profile = it.next();
			// 相同分组，相同子列表
			if (group.equalsIgnoreCase(profile.getGroup()) && subKey.equalsIgnoreCase(profile.getFormKey())) {
				// 在reportKey为空的情况下为查询默认报表
				if (reportKey.isEmpty() && profile.isDefault()) {
					matchProfile = profile;
					break;
				} else {
					if (reportKey.equalsIgnoreCase(profile.getKey())) {
						matchProfile = profile;
						break;
					}
				}
			}
		}

		if (matchProfile != null) {
			MetaSimpleSetting mss = setting.getSimpleSetting("ReportCache");
			boolean isCache = true;
			if (mss != null) {
				isCache = TypeConvertor.toBoolean(mss.get("Cache"));
			}
			if (isCache) {
				metaReport = matchProfile.getReport();
			}
			if (metaReport == null) {
				metaReport = loadReport(matchProfile);
			}
		}

		return metaReport;
	}

	protected MetaReport loadReport(MetaReportProfile matchProfile) throws Throwable {
		MetaProject metaProject = (MetaProject) matchProfile.getProject();
		IMetaResolver projectResourceResolver = projectResolverMap.get(metaProject.getKey());
		MetaReportLoad load = new MetaReportLoad(AppRunType.App);
		load.load(projectResourceResolver, matchProfile.getResource());
		MetaReport metaReport = (MetaReport) load.getRootMetaObject();
		matchProfile.setReport(metaReport);
		metaReport.setProject(metaProject);
		return metaReport;
	}

	/**
	 * 根据FormKey获取Excel模板下拉项
	 * @param formKey
	 * @return
	 * @throws Throwable
	 */
	public String getExcelTemplateDropList(String formKey) throws Throwable {
		String dropList = "";
		MetaForm metaForm = this.getMetaForm(formKey);
		String projectKey = metaForm.getProject().getKey();
		MetaExcelTemplateSubList subList = this.excelTemplateList.get(projectKey);
		if (subList != null) {
			Iterator<MetaExcelTemplateProfile> it = subList.iterator();
			MetaExcelTemplateProfile profile = null;
			while (it.hasNext()) {
				profile = it.next();
				MetaExcelWorkbook workbook = profile.getWorkbook();
				// 如果没有加载过workbook重新加载一次
				if (workbook == null) {
					workbook = getExcelTemplate(projectKey, profile.getKey());
				}
				String bindingFormKey = workbook.getFormKey();
				String caption = workbook.getCaption();
				if (bindingFormKey.equalsIgnoreCase(formKey)) {
					dropList = dropList + ";" + workbook.getKey() + "," + caption;
				}
			}
			if (dropList.length() > 0) {
				dropList = dropList.substring(0);
			}
		}

		return dropList;

	}

	public MetaExcelWorkbook getExcelTemplate(String projectKey, String templateKey) throws Throwable {
		MetaExcelWorkbook metaWorkbook = null;
		MetaExcelTemplateSubList subList = this.excelTemplateList.get(projectKey);
		Iterator<MetaExcelTemplateProfile> it = subList.iterator();
		MetaExcelTemplateProfile profile = null;
		MetaExcelTemplateProfile matchProfile = null;
		while (it.hasNext()) {
			profile = it.next();
			if (profile.getKey().equalsIgnoreCase(templateKey)) {
				matchProfile = profile;
				break;
			}
		}

		if (matchProfile != null) {
			// 是否不读缓存,直接读文件
			MetaSimpleSetting mss = setting.getSimpleSetting("ExcelTemplateCache");
			boolean isCahce = true;
			if (mss != null) {
				isCahce = TypeConvertor.toBoolean(mss.get("Cache"));
			}
			if (isCahce) {
				metaWorkbook = matchProfile.getWorkbook();
			}
			if (metaWorkbook == null) {
				IMetaResolver projectResourceResolver = projectResolverMap.get(projectKey);
				MetaExcelTemplateLoad load = new MetaExcelTemplateLoad(AppRunType.App);
				load.load(projectResourceResolver, matchProfile.getResource());
				metaWorkbook = (MetaExcelWorkbook) load.getRootMetaObject();
				matchProfile.setWorkbook(metaWorkbook);
			}
		}

		return metaWorkbook;
	}

	@Override
	public MetaSetting getSetting() {
		return this.setting;
	}

	@Override
	public void setSetting(MetaSetting setting) {
		this.setting = setting;
	}

	@Override
	public MetaClientAppDef getClientAppDef() {
		return this.clientAppDef;
	}

	@Override
	public MetaRightsDefinition getRightsDefinition() {
		return rightsDefinition;
	}

	@Override
	public void setRightsDefinition(MetaRightsDefinition metaRightsDefinition) {
		this.rightsDefinition = metaRightsDefinition;
	}

	@Override
	public boolean hasAllFormRights(String formKey) {
		MetaFormProfile formProfile = null;
		if (formList != null) {
			formProfile = formList.get(formKey);
		}
		if (formProfile == null && extFormList != null) {
			formProfile = extFormList.get(formKey);
		}

		String solutionKey = null;
		if (formProfile != null) {
			IMetaProject project = formProfile.getProject();
			if (project instanceof MetaProject) {
				IMetaSolution solution = ((MetaProject) project).getSolution();
				if (solution instanceof MetaSolution) {
					solutionKey = ((MetaSolution) solution).getKey();
				}
			}
		}

		return rightsDefinition == null ? false : rightsDefinition.hasAllFormRights(formKey, solutionKey);
	}

	@Override
	public boolean hasAllDictRights(String itemKey) {
		MetaDataObjectProfile dataObjectProfile = null;
		if (dataObjectList != null) {
			dataObjectProfile = dataObjectList.get(itemKey);
		}

		String solutionKey = null;
		if (dataObjectProfile != null) {
			IMetaProject project = dataObjectProfile.getProject();
			if (project instanceof MetaProject) {
				IMetaSolution solution = ((MetaProject) project).getSolution();
				if (solution instanceof MetaSolution) {
					solutionKey = ((MetaSolution) solution).getKey();
				}
			}
		}
		return rightsDefinition == null ? false : rightsDefinition.hasAllDictRights(itemKey, solutionKey);
	}

	@Override
	public IMetaResolver getProjectResolver(String project) {
		return this.projectResolverMap.get(project);
	}

	@Override
	public List<String> getProjectKeys() {
		List<String> list = new ArrayList<String>();
		list.addAll(this.projectResolverMap.keySet());
		return list;
	}

	@Override
	public MetaExConfiguration getExConfiguration() {
		return exConfiguration;
	}

	@Override
	public MetaPermConfiguration getPermConfiguration() {
		return permConfiguration;
	}

	@Override
	public MetaArchive getArchive() {
		return archive;
	}

	@Override
	public MetaArchiveSetting getArchiveSetting() {
		return archiveSetting;
	}

	@Override
	public MetaBPMMonitorSetting getBPMMonitorSetting() {
		return bpmMonitorSetting;
	}

	@Override
	public MetaElasticSearch getElasticSearch() {
		return this.metaES;
	}

	@Override
	public void reloadMetaForm(String key) throws Throwable {
		MetaFormProfile metaFormProfile = formList.get(key);
		if (metaFormProfile != null) {
			MetaForm metaForm = this.getMetaForm(key);
			MetaDataSource metaDataSource = metaForm.getDataSource();
			if (metaDataSource != null) {
				String refDataObjectKey = metaDataSource.getRefObjectKey();
				// 内联数据对象的情况下，并且不是关联数据对象,需要清除数据对象列表
				if (StringUtils.isEmpty(refDataObjectKey)) {
					MetaDataObject metaDataObject = metaDataSource.getDataObject();
					if (metaDataObject != null && StringUtils.isEmpty(metaDataObject.getRelateObjectKey()) && StringUtils.isEmpty(metaFormProfile.getExtend())) {
						// 不是关联数据对象
						this.dataObjectList.remove(metaDataObject.getKey());
					}
				}
			}
			metaFormProfile.setForm(null);
		}
		this.getMetaForm(key);
	}

	@Override
	public void reloadDataObject(String key) throws Throwable {

		String lockKey = SystemPrefix.LOAD_META_DATAOBJECT + key;
		LockUtil.execute(lockKey, () -> {
			MetaDataObjectProfile metaDataObjectProfile = dataObjectList.get(key);
			metaDataObjectProfile.setDataObject(null);
			this.getDataObject(key);
			return true;
		});
	}

	@Override
	public void replaceMetaForm(String key, MetaForm metaForm) throws Throwable {
		MetaFormProfile metaFormProfile = formList.get(key);
		if (metaFormProfile != null) {
			metaFormProfile.setForm(metaForm);
			MetaDataSource metaDataSource = metaForm.getDataSource();
			if (metaDataSource != null) {
				String refDataObjectKey = metaDataSource.getRefObjectKey();
				// 内联数据对象的情况下，需要替换数据对象
				if (refDataObjectKey == null || refDataObjectKey.isEmpty()) {
					MetaDataObject metaDataObject = metaDataSource.getDataObject();
					if (metaDataObject != null && StringUtils.isEmpty(metaDataObject.getRelateObjectKey())) {
						this.dataObjectList.remove(metaDataObject.getKey());
						addInlineDataObject(metaFormProfile, metaForm, true);
					}
				} else if (StringUtils.isNotEmpty(refDataObjectKey)) {
					if (metaForm.getDataSource().getDataObject() != null) {
						this.dataObjectList.get(refDataObjectKey).setDataObject(metaForm.getDataSource().getDataObject());
					}
				}
			}
		}
	}

	/**
	 * 替换MergeToSource马甲metaForm至源单
	 * @param extendFormKey
	 * @param metaForm
	 * @throws Throwable
	 */
	@Override
	public void replaceMetaForm4VestDiff(String extendFormKey, MetaForm metaForm) throws Throwable {
		MetaForm extendForm = this.getMetaForm(extendFormKey);// 源单
		List<String> cellKeyList = extendForm.getAllGridCells().stream().map(MetaGridCell::getKey).collect(Collectors.toList());
		for (MetaGridCell cell : metaForm.getAllGridCells()) {
			if (!cellKeyList.contains(cell.getKey())) {
				cell.setNewExtField(true);
			}
		}
		IMetaProject project = metaForm.getProject();
		MetaForm newMetaForm = (MetaForm) metaForm.depthClone();// 合并后的特殊马甲，源单合并马甲
		MetaForm resultMetaForm = (MetaForm) extendForm.depthClone();// 源单
		// 3.继承处理,如果被继承表单未加载,在内部获取时加载
		MetaFormExtendProcess processor = new MetaFormExtendProcess(this, resultMetaForm);
		processor.process(newMetaForm);
		MetaFormExtendProcess processor1 = new MetaFormExtendProcess(this, newMetaForm);
		processor1.process(resultMetaForm);
		MetaDataSource dataSource1 = metaForm.getDataSource();
		boolean isRefObjectVest = metaForm.getMergeToSource() && dataSource1 != null && StringUtils.isNotEmpty(dataSource1.getRefObjectKey());
		if (isRefObjectVest) {
			newMetaForm.setResource(extendForm.getResource());
			newMetaForm.setKey(extendFormKey);
			newMetaForm.setCaption(extendForm.getCaption());
			newMetaForm.setExtend("");
			processVestForm(newMetaForm, extendForm);
			newMetaForm.setKey(extendFormKey);
			newMetaForm.setMergeToSource(false);
			resultMetaForm.getDataSource().getDataObject().merge(newMetaForm.getDataSource().getDataObject());
			newMetaForm.setDataSource(resultMetaForm.getDataSource());
			MetaForm depthClone = (MetaForm) newMetaForm.depthClone();
			depthClone.setKey(metaForm.getKey());
			depthClone.setMergeToSource(true);
			depthClone.setResource(metaForm.getResource());
			depthClone.setCaption(metaForm.getCaption());
			depthClone.setExtend(extendFormKey);
			depthClone.setDataSource(metaForm.getDataSource());
			depthClone.setProject(project);
			this.replaceMetaForm(metaForm.getKey(), depthClone);
			newMetaForm.setProject(project);
			this.replaceMetaForm(extendFormKey, newMetaForm);
		} else {
			newMetaForm.setResource(extendForm.getResource());
			newMetaForm.setKey(extendFormKey);
			newMetaForm.setCaption(extendForm.getCaption());
			newMetaForm.setExtend("");
			MetaDataSource dataSource = newMetaForm.getDataSource();
			if (dataSource != null) {
				dataSource.setRefObjectKey("");
			}
			processVestForm(newMetaForm, extendForm);
			newMetaForm.setKey(extendFormKey);
			newMetaForm.setMergeToSource(false);
			MetaForm depthClone = (MetaForm) newMetaForm.depthClone();
			depthClone.setKey(metaForm.getKey());
			depthClone.setMergeToSource(true);
			depthClone.setResource(metaForm.getResource());
			depthClone.setCaption(metaForm.getCaption());
			depthClone.setExtend(extendFormKey);
			depthClone.setProject(project);
			newMetaForm.setProject(project);
			this.replaceMetaForm(metaForm.getKey(), depthClone);
			this.replaceMetaForm(extendFormKey, newMetaForm);
			if (dataSource != null && extendForm.getDataSource() != null) {
				this.getMetaForm(extendFormKey).getDataSource().setRefObjectKey(extendForm.getDataSource().getRefObjectKey());
			}
		}
	}

	private void processVestForm(MetaForm newMetaForm, MetaForm extendForm) throws Throwable {
		List<MetaEmbed> embeds = extendForm.getEmbeds();
		for (MetaEmbed embed : embeds) {
			newMetaForm.addEmbed(embed);
		}
		newMetaForm.setVersion(extendForm.getVersion());
		MetaFormTemplateProcess templateProcess = new MetaFormTemplateProcess(this, newMetaForm);
		templateProcess.process();

		final HashMap<String, AbstractMetaObject> allUIComponents = newMetaForm.getAllUIComponents();
		for (AbstractMetaObject abstractMetaObject : allUIComponents.values()) {
			if (abstractMetaObject instanceof MetaComponent) {
				final MetaComponent component = (MetaComponent) abstractMetaObject;
				final boolean extend = component.isExtend();
				if (extend) {
//                    component.setExtend(false);
					component.setVisible("false");
					component.setShiftExtend(true);
				}
			}
			if (abstractMetaObject instanceof MetaGrid) {
				// noinspection DuplicatedCode
				final MetaGridColumnCollection columnCollection = ((MetaGrid) abstractMetaObject).getColumnCollection();
				for (MetaGridColumn metaGridColumn : columnCollection) {
					if (metaGridColumn.isVestDeleted()) {
						metaGridColumn.setIsVestDeleteCol(false);
						metaGridColumn.setVisible("false");
					}
					final String visible = metaGridColumn.getVisible();
					if (StringUtils.equals(visible, "return FaLse")) {
						metaGridColumn.setVisible("false");
					}
				}
			}
			if (abstractMetaObject instanceof MetaSubDetail) {
				final MetaComponent root = ((MetaSubDetail) abstractMetaObject).getRoot();
				boolean isGrid = root instanceof MetaGrid;
				if (!isGrid) {
					// TODO root 是 MetaGridLayoutPanel
					continue;
				}
				// noinspection DuplicatedCode
				final MetaGridColumnCollection columnCollection = ((MetaGrid) root).getColumnCollection();
				for (MetaGridColumn metaGridColumn : columnCollection) {
					if (metaGridColumn.isVestDeleted()) {
						metaGridColumn.setIsVestDeleteCol(false);
						metaGridColumn.setVisible("false");
					}
					final String visible = metaGridColumn.getVisible();
					if (StringUtils.equals(visible, "return FaLse")) {
						metaGridColumn.setVisible("false");
					}
				}
			}
		}
		newMetaForm.doPostProcess(0, newCallBack(DefaultMetaFactory.this, null, newMetaForm.getProject()));
	}

	/**
	 * 替换MetaCustomObject
	 * @param <T>
	 * @param key
	 * @param clzz
	 * @param object
	 */
	@Override
	public <T> void replaceMetaCustomObject(String key, Class<T> clzz, KeyPairMetaObject object) {
		if (customList != null && !customList.isEmpty()) {
			for (KeyPairMetaObject o : customList) {
				if (o.getClass() == clzz) {
					if (o.getKey().equals(key)) {
						customList.remove(o);
						customList.add(object);
						break;
					}
				}
			}
		}
	}

	@Override
	public MetaIOSetting getIOSetting() {
		return this.IOSetting;
	}

	@Override
	public MetaCellTypeTable getCellTypeTable() {
		return cellTypeTable;
	}

	@Override
	public MetaChargingObjectList getChargingObjectList() {
		return this.bizExtend.getCharginbObjectList();
	}

	@Override
	public MetaChargingObject getChargingObject(String key) throws Throwable {
		MetaChargingObject chargingObject = null;
		MetaChargingObjectProfile profile = this.bizExtend.getCharginbObjectList().get(key);
		if (profile != null) {
			MetaProject metaProject = (MetaProject) profile.getProject();
			IMetaResolver projectResourceResolver = projectResolverMap.get(metaProject.getKey());
			MetaChargingObjectLoad load = new MetaChargingObjectLoad(AppRunType.App);
			load.load(projectResourceResolver, profile.getResource());
			chargingObject = (MetaChargingObject) load.getRootMetaObject();
		}
		return chargingObject;
	}

	@Override
	public MetaChargingRuleGroupList getChargingRuleGroupList() {
		return this.bizExtend.getChargingRuleGroupList();
	}

	@Override
	public MetaChargingRuleGroup getChargingRuleGroup(String key) throws Throwable {
		MetaChargingRuleGroup ruleGroup = null;
		MetaChargingRuleGroupProfile profile = this.bizExtend.getChargingRuleGroupList().get(key);
		if (profile != null) {
			MetaProject metaProject = (MetaProject) profile.getProject();
			IMetaResolver projectResourceResolver = projectResolverMap.get(metaProject.getKey());
			MetaChargingRuleGroupLoad load = new MetaChargingRuleGroupLoad(AppRunType.App);
			load.load(projectResourceResolver, profile.getResource());
			ruleGroup = (MetaChargingRuleGroup) load.getRootMetaObject();
		}
		return ruleGroup;
	}

	@Override
	public void preLoadEntity() throws Throwable {
		getLoadReportRegister();
		ExecutorService service = Executors.newFixedThreadPool(5);
		try {
			final List<Future<?>> futureTaskList = new ArrayList<>();
			// 初始化模板
			formList.forEach(metaFormProfile -> {
				if(metaFormProfile.getFormType() != FormType.Template) {
					return;
				}
				String extendFormKey = metaFormProfile.getExtend();
				boolean isVestDiff = extendFormKey != null && !extendFormKey.isEmpty();
				if (!isVestDiff) {
					Future<?> futureTask = service.submit(() -> {
						try {
							this.getMetaForm(metaFormProfile.getKey());
						} catch (Throwable e) {
							throw new RuntimeException(e);
						}
					});
					futureTaskList.add(futureTask);
				}
			});

			for (Future<?> task : futureTaskList) {
				task.get();
			}

			futureTaskList.clear();
			LockUtil.clear();
			
			// 循环所有的实体表单，加载元数据，为内嵌的数据对象建立列表
			formList.forEach(metaFormProfile -> {
				String extendFormKey = metaFormProfile.getExtend();
				boolean isVestDiff = extendFormKey != null && !extendFormKey.isEmpty();
				if (isEntityForm(metaFormProfile) && !isVestDiff) {
					Future<?> futureTask = service.submit(() -> {
						try {
							this.getMetaForm(metaFormProfile.getKey());
						} catch (Throwable e) {
							throw new RuntimeException(e);
						}
					});
					futureTaskList.add(futureTask);
				}
			});

			for (Future<?> task : futureTaskList) {
				task.get();
			}

			futureTaskList.clear();
			LockUtil.clear();
			
			// 初始化馬甲
			formList.forEach(metaFormProfile -> {
				String extendFormKey = metaFormProfile.getExtend();
				boolean isVestDiff =  extendFormKey != null && !extendFormKey.isEmpty();
				if (isVestDiff) {
					Future<?> futureTask = service.submit(() -> {
						try {
							this.getMetaForm(metaFormProfile.getKey());
						} catch (Throwable e) {
							throw new RuntimeException(e);
						}
					});
					futureTaskList.add(futureTask);
				}
			});

			for (Future<?> task : futureTaskList) {
				task.get();
			}

			futureTaskList.clear();
			LockUtil.clear();
			
			formList.forEach(metaFormProfile -> {
				String extendFormKey = metaFormProfile.getExtend();
				Boolean mergeToSource = metaFormProfile.getMergeToSource();
				boolean isVestDiff = mergeToSource && extendFormKey != null && !extendFormKey.isEmpty();
				if (isVestDiff) {
					Future<?> futureTask = service.submit(() -> {
						try {
							this.getMetaForm(metaFormProfile.getKey());
						} catch (Throwable e) {
							throw new RuntimeException(e);
						}
					});
					futureTaskList.add(futureTask);
				}
			});

			for (Future<?> task : futureTaskList) {
				task.get();
			}

			futureTaskList.clear();
			LockUtil.clear();
			
			// 循环所有数据对象，加载元数据，计算单独的数据对象
			dataObjectList.forEach(metaDataObjectProfile -> {
				MetaDataObject dataObject = metaDataObjectProfile.getDataObject();
				if (dataObject == null) {
					Future<?> futureTask = service.submit(() -> {
						try {
							this.getDataObject(metaDataObjectProfile.getKey());
						} catch (Throwable e) {
							throw new RuntimeException(e);
						}
					});
					futureTaskList.add(futureTask);
				}
			});

			for (Future<?> task : futureTaskList) {
				task.get();
			}
		} finally {
			LockUtil.clear();
			if (service != null) {
				service.shutdown();
			}
		}
	}

	@Override
	public MetaEntry getEntryList(String appKey) throws Throwable {
		MetaEntry root = new MetaEntry();
		if (appKey != null && !appKey.isEmpty()) {
			MetaApps metaApps = solution.getApps();
			for (int i = 0, size = metaApps.size(); i < size; ++i) {
				MetaApp tmpMetaApp = metaApps.get(i);
				if (tmpMetaApp.getKey().equals(appKey)) {
					for (int j = 0, t_size = tmpMetaApp.size(); j < t_size; ++j) {
						MetaRefProject p = tmpMetaApp.get(j);
						MetaEntry entry = this.getMetaEntry(p.getKey());
						if (entry != null) {
							for (int k = 0, e_size = entry.size(); k < e_size; ++k) {
								root.add(entry.get(k));
							}
						}
					}
					break;
				}
			}
		} else {
			Iterator<MetaProjectProfile> it = this.solution.getProjectCollection().iterator();
			MetaProjectProfile profile = null;
			while (it.hasNext()) {
				profile = it.next();
				MetaEntry entry = this.getMetaEntry(profile.getKey());
				if (entry != null) {
					for (int i = 0, size = entry.size(); i < size; ++i) {
						root.add(entry.get(i));
					}
				}
			}
		}
		return root;
	}

	@Override
	public MetaAppDefiniton getAppDefinition() {
		return appDefiniton;
	}

	@Override
	public MetaForm getMetaForm(String formKey, String templateKey) throws Throwable {
		// TODO 后续做缓存
		if (templateKey == null || templateKey.isEmpty()) {
			return getMetaForm(formKey);
		}

		MetaForm metaForm = getMetaForm(formKey);
		MetaForm temp = getMetaForm(templateKey);
		MetaFormFrameProcess p = new MetaFormFrameProcess(this, metaForm, temp);
		metaForm = p.process();

		return metaForm;
	}

	@Deprecated
	@Override
	public MetaFlatCanvasList getFlatCanvasList() {
		return flatCanvasList;
	}

	@Override
	public MetaFCPaper getMetaFCPaper(String key) throws Throwable {
		MetaFCPaper metaPaper = null;
		MetaFlatCanvasProfile profile = flatCanvasList.get(key);
		if (profile != null) {
			metaPaper = profile.getMetaPaper();
			if (metaPaper == null) {
				String filePath = profile.getResource();
				MetaProject metaProject = (MetaProject) profile.getProject();
				InputStream in = projectResolverMap.get(metaProject.getKey()).read(filePath, 0);
				Document document = DomHelper.createDocument(in);
				metaPaper = new MetaFCPaper();
				metaPaper.loadFromDocument(document);
				profile.setMetaPaper(metaPaper);
			}
		}
		return metaPaper;
	}

	@Override
	public File getUserSVGFile(String fileName) {
		return this.svgUserFileMap.get(fileName.toLowerCase());
	}

	@Override
	public MetaStringTable getFormStrings(String formKey) throws Throwable {
		return globalI18N.getFormStrings(formKey);
	}

	@Override
	public MetaStringTable getProcessStrings(String processKey) throws Throwable {
		return globalI18N.getProcessStrings(processKey);
	}

	@Override
	public MetaStringTable getDataObjectStrings(String dataObjectKey) throws Throwable {
		return globalI18N.getDataObjectStrings(dataObjectKey);
	}

	@Override
	public MetaMidSetting getMidSetting() {
		return midSetting;
	}

	@Override
	public MetaPermissionFilter getPermissionFilter() {
		return permissionFilter;
	}

	@Override
	public MetaCustomPermission getCustomPermission() {
		return customPermission;
	}

	@SuppressWarnings("unchecked")
	@Override
	public <S> S getMetaCustomObject(Class<S> clzz, String key) {
		if (customList != null && !customList.isEmpty()) {
			for (KeyPairMetaObject o : customList) {
				if (o.getClass() == clzz) {
					if (o.getKey().equals(key)) {
						return (S) o;
					}
				}
			}
		}

		return null;
	}

	@SuppressWarnings("unchecked")
	@Override
	public <S> List<S> getMetaCustomObjects(Class<S> clzz) {
		List<S> list = null;
		if (customList != null && !customList.isEmpty()) {
			for (KeyPairMetaObject o : customList) {
				if (o.getClass() == clzz) {
					if (list == null) {
						list = new ArrayList<S>();
					}
					list.add((S) o);
				}
			}
		}

		return list;
	}

	@Override
	public void deployProcess(String projectKey, String resource) throws Throwable {
		// 找到对应工程,扫描其中的bpm文件及bpm文件夹
		MetaProject project = solution.getProject(projectKey);
		if (project != null) {
			/*MetaBPMReferenceScanLoad bpmLoad = new MetaBPMReferenceScanLoad(metaBPM, solutionResourceResolver, project, null, AppRunType.App);
			bpmLoad.load();*/
		}
	}

	@Override
	public MetaTaskProcess getTaskProcessDefinitionByDeployKey(String key) throws Throwable {
		MetaTaskProcessDeployInfo deployInfo = metaTask.getDeployInfoCollection().get(key);
		if (deployInfo == null)
			return null;
		String processKey = deployInfo.getKey() + "_V" + deployInfo.getVersion();

		MetaTaskProcessProfile profile = metaTask.getProfileMap().get(processKey);
		if (profile == null)
			return null;
		return profile.getDefination();
	}

	@Override
	public MetaTaskProcess getTaskProcessDefinitionBy(String key, int verID) throws Throwable {
		String processKey = key + "_V" + verID;
		MetaTaskProcessProfile profile = metaTask.getProfileMap().get(processKey);
		return profile == null ? null : profile.getDefination();
	}

	/**
	 * 设置差异工程指向, 多solution时,差异工程solution需排在最前面
	 *
	 * @param metaProjectCollection
	 */
	private void initReferDiffProject(MetaProjectCollection metaProjectCollection) {
		Iterator<MetaProjectProfile> itMetaProject = metaProjectCollection.iterator();
		MetaProjectProfile metaProjectProfile = null;
		while (itMetaProject.hasNext()) {
			metaProjectProfile = itMetaProject.next();
			if (metaProjectProfile.isDiffProject()) {
				for (String sourceProjectKey : metaProjectProfile.getDiffSourceProjectList()) {
					mapDiffSourceProject.put(sourceProjectKey, metaProjectProfile.getKey());
				}
			}
		}
	}

	@Override
	public void reloadCustomList(MetaProject metaProject, MetaProjectProfile metaProjectProfile) throws Throwable {
		IMetaResolver projectMetaResolver = null;
		String refPath = metaProjectProfile.getRefPath();
		if (refPath == null || refPath.isEmpty()) {
			projectMetaResolver = this.primaryResolverFactory
					.newMetaResolver(this.primaryResolverFactory.getSeparator() + metaProjectProfile.getKey());
		} else {
			projectMetaResolver = this.primaryResolverFactory.newFileMetaResolver(refPath);
		}
		MetaSimpleSetting mss = this.setting == null ? null : this.setting.getSimpleSetting("MetaCustomObjectBuilder");
		if (mss != null) {
			String impl = mss.get("Impl");
			if (impl != null && !impl.isEmpty()) {
				MetaCustomObjectScanLoad customObjectScanLoad = new MetaCustomObjectScanLoad(customList,
						projectMetaResolver, metaProject, null, impl, AppRunType.App);
				customObjectScanLoad.load();
			}
		}
	}

	@Override
	public HashMap<String, IMetaResolver> getProjectResolverMap() throws Throwable {
		return this.projectResolverMap;
	}

	@Override
	public void reloadDataMigration(String key) throws Throwable {
		MetaDataMigrationProfile metaDataMigrationProfile = migrationList.get(key);
		if (metaDataMigrationProfile != null) {
			metaDataMigrationProfile.setDataMigration(null);
		}
	}

	/**
	 * 合并映射差异
	 * @param dataMap
	 * @throws Throwable
	 */
	private void mergeDiffMeta4DataMap(MetaMap dataMap) throws Throwable {
		if (dataMap != null && this.diffList != null && this.diffList.size() > 0 &&
				getSolution().isEnableDiff() && DiffActionManager.getInstance().isInited()) {
			MetaMapDiffLoad diffMapLoader = new MetaMapDiffLoad(AppRunType.App);
			MetaDiff metaDiff = this.getMetaDiff(dataMap.getKey(), dataMap.getTagName(), diffMapLoader);
			if (metaDiff != null) {
				DiffActionManager.getInstance().doDiffMergeAction(dataMap, metaDiff, diffMapLoader);
			}
		}
	}

	/**
	 * 合并迁移差异
	 * @param dataMigration
	 * @throws Throwable
	 */
	private void mergeDiffMeta4Migration(MetaDataMigration dataMigration) throws Throwable {
		if (dataMigration != null && this.diffList != null && this.diffList.size() > 0 &&
				getSolution().isEnableDiff() && DiffActionManager.getInstance().isInited()) {
			MetaMigrationDiffLoad diffMigrationLoader = new MetaMigrationDiffLoad(AppRunType.App);
			MetaDiff metaDiff = this.getMetaDiff(dataMigration.getKey(), dataMigration.getTagName(), diffMigrationLoader);
			if (metaDiff != null) {
				DiffActionManager.getInstance().doDiffMergeAction(dataMigration, metaDiff, diffMigrationLoader);
			}
		}
	}

	private void mergeDiffMeta4FormAndDataObject(String metaKey, AbstractMetaObject baseMeta) throws Throwable {
		if (baseMeta != null && this.diffList != null && this.diffList.size() > 0 &&
				getSolution().isEnableDiff() && DiffActionManager.getInstance().isInited()) {
			MetaFormDiffLoad difflLoader = new MetaFormDiffLoad(AppRunType.App);
			MetaDiff metaDiff = this.getMetaDiff(metaKey, baseMeta.getTagName(), difflLoader);
			if (metaDiff != null) {
				DiffActionManager.getInstance().doDiffMergeAction(baseMeta, metaDiff, difflLoader);
			}
		}
	}

	/**
	 * 取得差异配置
	 * @param key
	 * @param tagName
	 * @return
	 * @throws Exception
	 */
	private MetaDiff getMetaDiff(String key, String tagName, AbstractLoad difflLoader) throws Exception {
		MetaDiff metaDiff = null;
		String diffMetaKey = DiffKeyUtil.getMetaDiffKey(key, tagName);
		MetaDiffProfile metaDiffProfile = diffList.get(diffMetaKey);
		if (metaDiffProfile != null) {
			metaDiff = metaDiffProfile.getDiff();
		}
		if (metaDiff == null && metaDiffProfile != null) {
			MetaProject metaProject = (MetaProject) metaDiffProfile.getProject();
			IMetaResolver diffResolver = projectResolverMap.get(metaProject.getKey());
			if (diffResolver != null) {
				difflLoader.load(diffResolver, metaDiffProfile.getResource());
				metaDiff = (MetaDiff) difflLoader.getRootMetaObject();
				metaDiff.setProject(metaProject);
				metaDiff.setResource(metaDiffProfile.getResource());
				metaDiffProfile.setDiff(metaDiff);
			}
		}
		return metaDiff;
	}

	/**
	 * 取得字符串表
	 * @return 字符串表
	 * @throws Throwable
	 */
	public MetaStringTable getStrings() throws Throwable {
		return globalI18N.getSolutionStrings();
	}

	public MetaStringTable getStrings(String lang) throws Throwable {

		return globalI18N.getSolutionStrings(lang);
	}

	public void setStrings(MetaStringTable strings) throws Throwable {
		globalI18N.setSolutionStrings(strings);
	}

	/**
	 * 取得数据映射字符串表
	 */
	public MetaStringTable getDataMapStrings() throws Throwable {
		return globalI18N.getSolutionMapStrings();
	}

	/**
	 * 取得数据迁移字符串表
	 */
	public MetaStringTable getDataMigrationStrings() throws Throwable {
		return globalI18N.getSolutionMigrationStrings();
	}

	@Override
	public MetaStringTable getProjectStrings(String projectKey) throws Throwable {
		MetaProject metaProject = getMetaProject(projectKey);
		return metaProject.getStrings();
	}

	@Override
	public JSONObject readProfile(String resource) throws Throwable {
		return primarySolutionResourceResolver.readProfile(resource, 0);
	}

	@Override
	public MetaStatusCollection getStatusCollection(String formKey) throws Throwable {
		return MetaUtil.getStatusCollection(this, this.getMetaForm(formKey));
	}

	@Override
	public byte[] getExcelFileTemplate(String projectKey, String templateKey) throws Throwable {
		MetaGenericProfile metaProfile = this.excelFileTemplateMap.get(templateKey);
		return getExcelFileTemplateBytes(projectKey, metaProfile);
	}

	/**
	 * 动态更新单个配置文件入口 ,目前仅用与更新 xls 格式的excel模板
	 * 例: 需要更新  .....\ProjectA\ExcelTemplate\zzz\a_Batch.xls
	 * updateMetaFile("ProjectA", DomMetaConstants.EXCELTEMPLATE_FOLD, "a_Batch.xls", "\zzz");
	 *
	 * @param projectKey  工程key
	 * @param objectKey   配置对象key
	 * @param parentFold 对应配置文件所在模块下的父目录, 比如excel文件 .....\ExcelTemplate\zzz\a_Batch.xls, 该参数为  \zzz
	 * @param sModuleType 模块标志
	 * @throws Throwable
	 */
	@Override
	public void updateMetaFile(String projectKey, String objectKey, String parentFold, String sModuleType) throws Throwable {
		if (StringUtil.isBlankOrNull(sModuleType)) {
			return;
		}
		switch (sModuleType) {
			case DomMetaConstants.EXCELTEMPLATE_FOLD:
				updateExcelFileTemplate(projectKey, objectKey, parentFold);
				break;
		}
	}

	public void updateExcelFileTemplate(String projectKey, String objectKey, String parentFold) throws Throwable {
		parentFold = StringUtil.isBlankOrNull(parentFold) ? "" : parentFold;
		parentFold = !parentFold.startsWith(File.separator) ? (File.separator + parentFold) : parentFold;

		MetaGenericProfile metaProfile = this.excelFileTemplateMap.get(objectKey);
		if (metaProfile == null) {
			String resource = DomMetaConstants.EXCELTEMPLATE_FOLD
					+ parentFold + File.separator + objectKey;
			metaProfile = createGenericProfile(projectKey, resource);
		}
		metaProfile.setContent(null);
		byte[] bytes = getExcelFileTemplateBytes(projectKey, metaProfile);
		if (bytes != null && !this.excelFileTemplateMap.containsKey(objectKey)) {
			this.excelFileTemplateMap.put(objectKey, metaProfile);
		}
	}

	private byte[] getExcelFileTemplateBytes(String projectKey, MetaGenericProfile metaProfile) throws Throwable {
		byte[] bytes = null;
		if (metaProfile != null) {
			// 初始存在对应的xls模板文件
			bytes = (byte[]) metaProfile.getContent();
			// 未载入缓存时，载入
			if (bytes == null) {
				IMetaResolver projectResourceResolver = projectResolverMap.get(projectKey);
				// 此处metaProfile.getResource() 获取的 路径格式为 ExcelTemplate\xxx_Batch.xls
				InputStream is = projectResourceResolver.read(metaProfile.getResource(), -1);
				if (is != null) {
					bytes = IOUtils.toByteArray(is);
					is.close();
					metaProfile.setContent(bytes);
				} else {
					throw new Throwable(metaProfile.getResource() + " not exist");
				}
			}
		}
		return bytes;
	}

	private MetaGenericProfile createGenericProfile(String projectKey, String filePath) throws Throwable {
		MetaProject metaProject = this.getMetaProject(projectKey);
		MetaGenericProfile metaProfile = new MetaGenericProfile();
		metaProfile.setProject(metaProject);
		metaProfile.setResource(filePath);
		return metaProfile;
	}

	@Override
	public MetaOfflineDef getOfflineDef() {
		return offlineDef;
	}

	@Override
	public void reloadDesignMetaForm(String key) throws Throwable {
		MetaFormProfile metaFormProfile = formList.get(key);
		if (metaFormProfile != null) {
			if (metaFormProfile.getForm()!=null && metaFormProfile.getForm().getDataSource()!=null) {
				String refDataObjectKey = metaFormProfile.getForm().getDataSource().getRefObjectKey();
				// 内联数据对象的情况下，并且不是关联数据对象,需要清除数据对象列表
				if (StringUtils.isEmpty(refDataObjectKey)) {
					MetaDataObject metaDataObject = metaFormProfile.getForm().getDataSource().getDataObject();
					if (metaDataObject != null && StringUtils.isEmpty(metaDataObject.getRelateObjectKey()) && StringUtils.isEmpty(metaFormProfile.getExtend())) {
						// 不是关联数据对象
						this.dataObjectList.remove(metaDataObject.getKey());
					}
				}
			}
			metaFormProfile.setForm(null);
		}
	}

	@Override
	public MetaForm getDesignMetaForm(String key) throws Throwable {
		MetaFormProfile metaFormProfile = formList.get(key);
		if (metaFormProfile == null) {
			metaFormProfile = extFormList.get(key); //是否是扩展表单
		}
		if (metaFormProfile == null) {
			return getMetaForm(key); // 这一行仅仅是让程序报错去
		}
		MetaForm result = metaFormProfile.getForm();
		if (result == null) {
			synchronized (metaFormProfile) {
				if (metaFormProfile.getFormType() == FormType.Extension) { //是否是扩展表单
					result = getExtMetaForm(metaFormProfile.getSourceForm(), metaFormProfile.getKey());
				} else {
					result = getMetaForm(key);
				}
			}
		}
		return result;
	}

	public MetaStringTable getMetaStringTable(String formKey, String locale) throws Throwable {
		MetaStringTable stringTable = stringTableMap.get(formKey);
		MetaForm metaForm;
		MetaFormProfile extMetaFormProfile = extFormList.get(formKey);
		if (extMetaFormProfile != null) {
			String sourceForm = extMetaFormProfile.getSourceForm();
			metaForm = getMetaForm(sourceForm);
		} else {
			metaForm = getMetaForm(formKey);
		}

		if (stringTable == null) {
			stringTable = new MetaStringTable();
			stringTable.load(locale, this, metaForm.getProject().getKey(), formKey);
			stringTableMap.put(formKey, stringTable);
		} else if (!stringTable.containsLang(locale)) {
			stringTable.load(locale, this, metaForm.getProject().getKey(), formKey);
		}

		return stringTable;
	}

	@Override
	public MetaStringTable getProcessMetaStringTable(String process) throws Throwable {
		return this.processStringTableMap.get(process);
	}

	@Override
	public MetaStringTable getDataObjMetaStringTable(String dataObjKey) throws Throwable {
		return this.dataObjStringTableMap.get(dataObjKey);
	}

	@Override
	public MetaForm getExtMetaForm(String sourceFormkey, String extFormKey) throws Throwable {
		// 暂时以GetMetaForm方式实现，待后续配置合并好
		MetaForm metaForm = null;
		MetaFormProfile metaFormProfile = extFormList.get(extFormKey);
		if (metaFormProfile != null) {
			metaForm = metaFormProfile.getForm();
		}
		if (metaForm == null && metaFormProfile != null) {
			MetaProject metaProject = (MetaProject) metaFormProfile.getProject();
			IMetaResolver projectResourceResolver = projectResolverMap.get(metaProject.getKey());
			if (projectResourceResolver == null) {
				throw new MetaException(MetaException.PROJECT_RESOLVER_UNDEFINED,
						SimpleStringFormat.format(StringTable.getString(null, "", StringTable.ProjectResolverUndefined), metaProject.getKey()));
			}

			MetaForm parentForm = null;
			String extendFormKey = metaFormProfile.getExtend();
			if (extendFormKey != null && !extendFormKey.isEmpty()) {
				parentForm = this.getMetaForm(extendFormKey);
			}
			MetaFormLoad formLoad = new MetaFormLoad(AppRunType.App, parentForm);
			formLoad.load(projectResourceResolver, metaFormProfile.getResource());
			metaForm = (MetaForm) formLoad.getRootMetaObject();

			metaForm.setProject(metaProject);

			// 控件属性合并
//            MetaComponentExtProcess componentExtProcess = new MetaComponentExtProcess(this, metaForm);
//            componentExtProcess.process();

			mergeDiffMeta4FormAndDataObject(metaForm.getKey(), metaForm);

			metaForm.setResource(metaFormProfile.getResource());
			MetaFormSetting formSetting = setting.getFormSetting();
			if (formSetting != null) {
				metaForm.setInitFocus(formSetting.initFocus());
				metaForm.setDimValueProvider(formSetting.getDimValueProvider());
			}
			// 需要处理引用的外部数据对象
			MetaDataSource metaDataSource = metaForm.getDataSource();
			if (metaDataSource != null) {
				MetaDataObject metaDataObject = metaDataSource.getDataObject();
				if (metaDataObject == null) {
					String refObjectKey = metaDataSource.getRefObjectKey();
					if (refObjectKey != null && !refObjectKey.isEmpty()) {
						metaDataObject = this.getDataObject(refObjectKey);
						metaDataSource.setDataObject(metaDataObject);
					}
				} else {
					metaDataObject.setProject(metaProject);
				}
			}

			// 1.如果有继承的父表单,预先处理数据源,因为后续模板处理的需要
			copyDataSource(metaForm, parentForm);

			// 2.模板替换
			MetaFormTemplateProcess templateProcess = new MetaFormTemplateProcess(this, metaForm);
			templateProcess.process();

			// 3.继承处理,如果被继承表单未加载,在内部获取时加载
			IFormExtendProcessor processor = newProcessor();
			processor.process(this, metaForm);

			// 在读取的时候才去处理内联数据对象需要存储到对象列表中的情况
			if (isEntityForm(metaFormProfile)) {
				addInlineDataObject(metaFormProfile, metaForm, false);
			}

			// 移动处理属性合并之前的预先设置及处理
			MetaFormMergeHandler.preMergeMetaObject(this, metaForm);

			// 后期处理
			metaForm.doPostProcess(0, newCallBack(DefaultMetaFactory.this, null, metaProject));

			// 处理通过再添加
			metaFormProfile.setForm(metaForm);
		}
		return metaForm;
	}

	@Override
	public MetaExtFormList getExtFormList() throws Throwable {
		return extFormList;
	}

	@Override
	public MetaCommonDef getSolutionCommondDef(String project) throws Throwable {
		if (project == null || project.isEmpty()) {
			return this.solutionCommonDef;
		}

		String solutionKey = getSolutionKey(project);
		return this.solutionCommmonDefMap.get(solutionKey);
	}

	/**
	 * 获取Solution标识
	 * @param project 工程标识
	 * @return Solution标识
	 * @throws Throwable 异常
	 */
	private String getSolutionKey(String project) throws Throwable {
		MetaProject metaProject = this.getMetaProject(project);
		IMetaSolution iMetaSolution = metaProject == null ? null : metaProject.getSolution();

		String solutionKey = "";
		if (iMetaSolution != null) {
			solutionKey = ((MetaSolution) iMetaSolution).getKey();
		}
		return solutionKey;
	}

	@Override
	public IMetaResolverFactory getMetaResolverFactory() {
		return this.primaryResolverFactory;
	}

	@Override
	public IMetaResolverFactory getMetaResolverFactory(String project) throws Throwable {
		MetaProject metaProject = this.getMetaProject(project);
		IMetaSolution iMetaSolution = metaProject == null ? null : metaProject.getSolution();

		String solutionKey = "";
		if (iMetaSolution != null) {
			solutionKey = ((MetaSolution) iMetaSolution).getKey();
		}
		IMetaResolverFactory resolverFactory = this.resolverFactoryMap.get(solutionKey);
		return resolverFactory;
	}

	private static Callback<AbstractMetaObject, Boolean> newCommonDefCallBack(final IMetaFactory metaFactory,final IMetaResolverFactory resolverFactory,final MetaCommonDef commonDef) {
		return new Callback<AbstractMetaObject, Boolean>() {
			public Boolean call(AbstractMetaObject param) throws Throwable {
				if (param instanceof MetaIconFontSource) {
					MetaIconFontSource iconFont = (MetaIconFontSource) param;
					MetaIconFontItemCollection collection = iconFont.getItemCollection();

					String resource = "/Resource/" + iconFont.getSource();
					IMetaResolver metaResolver = resolverFactory.newMetaResolver("");
					InputStream inputStream = metaResolver.read(resource, -1);
					if (inputStream == null) {
						inputStream = metaFactory.loadResource(resource);
					}
					try (ZipInputStream zis = new ZipInputStream(inputStream)) {
						ZipEntry ze;
						while ((ze = zis.getNextEntry()) != null) {
							if (ze.getName().endsWith(".json")) {
								String jString = IOUtils.toString(zis, "UTF-8");
								if (jString != null && jString.length() > 0) {
									JSONObject jo = new JSONObject(jString);
									JSONArray glypArray = jo.getJSONArray("glyphs");
									for (int i = 0; i < glypArray.length(); i++) {
										JSONObject glypJo = glypArray.getJSONObject(i);
										String name = glypJo.getString("name");
										String unicode = glypJo.getString("unicode");
										MetaIconFontItem fontItem = collection.get(name);
										if (fontItem != null) {
											continue;
										} else {
											fontItem = new MetaIconFontItem();
											fontItem.setCode("\\" + unicode);
											fontItem.setKey(name);
											collection.add(fontItem);
										}
									}
								}
							}
						}
					}
				}
				return Boolean.valueOf(true);
			}
		};
	}

	public InputStream loadResourceBySolutionKey(String resource, String solutionKey) throws Throwable {
		if (this.resolverFactoryMap.size() == 0)
			return loadResource(resource);
		IMetaResolverFactory resolverFactory = this.resolverFactoryMap.get(solutionKey);
		if (resolverFactory == null) {
			return loadResource(resource);
		}
		IMetaResolver metaResolver = resolverFactory.newMetaResolver("");
		InputStream inputStream = metaResolver.read(resource, -1);
		if (inputStream == null) {
			return loadResource(resource);
		}
		return inputStream;
	}

	@Override
	public MetaIconSourceCollection getIconSourceCollection() throws Throwable {
		MetaIconSourceCollection metaIconCollection = new MetaIconSourceCollection();
		metaIconCollection.merge(solutionCommonDef.getIconSourceCollection());
		for (String key : solutionCommmonDefMap.keySet()) {
			MetaCommonDef commonDef = solutionCommmonDefMap.get(key);
			MetaIconSourceCollection collection = commonDef.getIconSourceCollection();
			metaIconCollection.merge(collection);
		}

		MetaProjectCollection projectCollection = this.solution.getProjectCollection();
		for (int i = 0; i < projectCollection.size(); i++) {
			MetaProjectProfile profile = projectCollection.get(i);
			MetaCommonDef commonDef = profile.getProject().getCommonDef();
			if (commonDef != null) {
				MetaIconSourceCollection collection = commonDef.getIconSourceCollection();
				metaIconCollection.merge(collection);
			}
		}
		return metaIconCollection;
	}

	@Override
	public MetaIconFontSourceCollection getIconFontSourceCollection() throws Throwable {
		if (collection == null) {
			collection = new MetaIconFontSourceCollection();
			collection.addCollection(solutionCommonDef.getIconFontSourceCollection());
			for (String key : solutionCommmonDefMap.keySet()) {
				MetaCommonDef commonDef = solutionCommmonDefMap.get(key);
				MetaIconFontSourceCollection collection = commonDef.getIconFontSourceCollection();
				this.collection.addCollection(collection);
			}

			MetaProjectCollection projectCollection = this.solution.getProjectCollection();
			for (int i = 0; i < projectCollection.size(); i++) {
				MetaProjectProfile profile = projectCollection.get(i);
				MetaCommonDef commonDef = profile.getProject().getCommonDef();
				if (commonDef != null) {
					MetaIconFontSourceCollection collection = commonDef.getIconFontSourceCollection();
					this.collection.addCollection(collection);
				}
			}
		}
		return collection;
	}


	@Override
	public Collection<MetaSolution> getMetaSolutions() {
		return this.solutionMap.values();
	}

	@Override
	public IMetaResolverFactory getMetaResolverFactoryBySolution(String solutionKey) {
		return this.resolverFactoryMap.get(solutionKey);
	}

	@Override
	public MetaCommonDef getCommonDefBySolution(String solutionKey) {
		if (StringUtils.equals(solutionKey, this.solution.getKey())) {
			return this.solutionCommonDef;
		}
		return this.solutionCommmonDefMap.get(solutionKey);
	}

	@Override
	public MetaStatusCollection getStatusCollectionByProjectKey(String projectKey) throws Throwable {
		return getStatusCollectionByProjectKey(projectKey, true);
	}

	@Override
	public MetaStatusCollection getStatusCollectionByProjectKey(String projectKey, boolean mergeOtherSolution) throws Throwable {
		MetaStatusCollection statusCollection = null;
		MetaCommonDef commonDef = getCommonDef(projectKey);
		if (commonDef != null) {
			statusCollection = commonDef.getStatusCollection();
		}

		if (statusCollection != null && statusCollection.size() > 0) {
			return statusCollection;
		}
		statusCollection = null;

		String solutionKey = getSolutionKey(projectKey);
		if (solutionKey != null && !solutionKey.isEmpty()) {
			if (mergeOtherSolution) {
				statusCollection = solutionStatusCollectionMap.get(solutionKey);
			} else {
				commonDef = solutionCommmonDefMap.get(solutionKey);
				if (commonDef != null) {
					statusCollection = commonDef.getStatusCollection();
				}
				return statusCollection;
			}
		}

		if (statusCollection != null && statusCollection.size() > 0) {
			return statusCollection;
		}
		statusCollection = null;

		if (solutionCommonDef != null) {
			statusCollection = solutionCommonDef.getStatusCollection();
		}
		return statusCollection;
	}

	private GlobalI18N loadSolutionI18N(IMetaResolverFactory resolverFactory) throws Throwable {
		GlobalI18N solutionGlobalI18N = new GlobalI18N();

		// 多语言resolver
		IMetaResolver i18NResolver = resolverFactory.newMetaResolver(resolverFactory.getSeparator() + DomMetaConstants.I18N_FOLD);

		// 载入应用多语种
		MetaI18NScanLoad i18nScanLoad = new MetaI18NScanLoad(solutionGlobalI18N, i18NResolver, null, null);
		i18nScanLoad.load();

		// 加载应用定义的数据映射多语言
		MetaDataMapI18NScanLoad dataMapI18NScanLoad = new MetaDataMapI18NScanLoad(solutionGlobalI18N, i18NResolver, null, null);
		dataMapI18NScanLoad.load();

		// 加载应用定义的数据迁移多语言
		MetaDataMigrationI18NScanLoad dataMigrationI18NScanLoad = new MetaDataMigrationI18NScanLoad(solutionGlobalI18N, i18NResolver, null, null);
		dataMigrationI18NScanLoad.load();

		return solutionGlobalI18N;
	}

	@Override
	public GlobalI18N getI18N(String project) throws Throwable {
		if (project == null || project.isEmpty()) {
			return this.globalI18N;
		}
		MetaProject metaProject = this.getMetaProject(project);

		// 在solutionI18NMap不存在该solution，返回主Solution的stringTable
		IMetaSolution iMetaSolution = metaProject.getSolution();
		String solutionKey = ((MetaSolution) iMetaSolution).getKey();
		GlobalI18N solutionI18N = this.solutionI18NMap.get(solutionKey);
		return solutionI18N;
	}

	protected MetaDomainDef loadDomainDef(MetaDomainDef domainDef,IMetaResolver resolver, String solutionKey, MetaProject metaProject) throws Throwable{
		MetaDomainDef metaDomainDef = MetaUtil.loadDomainDef( resolver, solutionKey, metaProject);
		this.initSolutionDomainDef();
		domainDef.toMerge(metaDomainDef);
		return metaDomainDef;
	}

	@Override
	public MetaParaTable getParaTable() throws Throwable {
		return this.paraTable;
	}

	@Override
	public MetaParameter getParameter() throws Throwable {
		return this.parameter;
	}

	protected MetaDataElementDef loadDataElementDef(MetaDataElementDef solutionDataElementDef,IMetaResolver resolver, String solutionKey, MetaProject metaProject) throws Throwable{
		MetaDataElementDef metaDataElementDef = MetaUtil.loadDataElementDef(this, resolver, solutionKey, metaProject);
		this.initSolutionDataElementDef();
		solutionDataElementDef.toMerge(metaDataElementDef);
		return metaDataElementDef;
	}
}
