package com.bokesoft.yigo.meta.exceltemplate;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaExcelCell extends AbstractMetaObject {
	public static final String TAG_NAME = "Cell";
	/** 单元格列号*/
	private Integer cellIndex = -1;
	/** 单元格取值方式*/
	private Integer sourceType = 0;
	/** 单元格取值公式*/
	private String definition = "";
	/** 单元格占用列数*/
	private Integer mergedColumnSpan = 1;
	/** 单元格占用行数*/
	private Integer mergedRowSpan = 1;
	/** 单元格是否扩展*/
	private Boolean isColumnExpand = false;
	/** 单元格显示信息*/
	private MetaExcelDisplay display = null;
	/** 单元格字段对应的数据源表标志*/
	private String tableKey = "";
	/** 列扩展信息 */
	private MetaExcelColumnExpand columnExpand = null;
	/** 行扩展*/
	private MetaExcelRowExpand rowExpand = null;
	/** 分组级别*/
	private Integer groupLevel = 0;
	/** 分组行位置*/
	private String groupPosition = "";
	/** 头部分组行的个数*/
	private Integer groupHeadRowCount = 0;
	/** 尾部分组行的个数*/
	private Integer groupTailRowCount = 0;
	/** 是否明细关联字段 */
	private Boolean detailLinkField = false;
	/** 忽略导出(表达式)  */
	private String ignoreExport = "";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		this.addAll2(list, this.display,this.rowExpand,this.columnExpand);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaExcelColumnExpand.TAG_NAME.equals(tagName) ) {
			this.columnExpand = new MetaExcelColumnExpand();
			resultMetaObject = this.columnExpand;
		} else if (MetaExcelDisplay.TAG_NAME.equals(tagName)) {
			this.display = new MetaExcelDisplay();
			resultMetaObject = this.display;
		}
		
		return resultMetaObject;
	}

	public Integer getCellIndex() {
		return cellIndex;
	}

	public void setCellIndex(Integer cellIndex) {
		this.cellIndex = cellIndex;
	}

	public Integer getSourceType() {
		return sourceType;
	}

	public void setSourceType(Integer sourceType) {
		this.sourceType = sourceType;
	}

	public String getDefinition() {
		return definition;
	}

	public void setDefinition(String definition) {
		this.definition = definition;
	}

	public Integer getMergedColumnSpan() {
		return mergedColumnSpan;
	}

	public void setMergedColumnSpan(Integer mergedColumnSpan) {
		this.mergedColumnSpan = mergedColumnSpan;
	}

	public Integer getMergedRowSpan() {
		return mergedRowSpan;
	}

	public void setMergedRowSpan(Integer mergedRowSpan) {
		this.mergedRowSpan = mergedRowSpan;
	}

	public Boolean isColumnExpand() {
		return isColumnExpand;
	}

	public void setColumnExpand(Boolean isColumnExpand) {
		this.isColumnExpand = isColumnExpand;
	}

	public MetaExcelColumnExpand getColumnExpand() {
		return columnExpand;
	}

	public void setColumnExpand(MetaExcelColumnExpand columnExpand) {
		this.columnExpand = columnExpand;
	}
	
	public MetaExcelDisplay ensureDisplay() {
		if ( this.display == null ) {
			this.display = new MetaExcelDisplay();
		}
		return this.display;
	}
	
	public MetaExcelDisplay getDisplay() {
		return display;
	}

	public void setDisplay(MetaExcelDisplay display) {
		this.display = display;
	}

	public String getTableKey() {
		return tableKey;
	}

	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}
	
	public void setGroupLevel(Integer groupLevel) {
		this.groupLevel = groupLevel;
	}
	
	public Integer getGroupLevel() {
		return groupLevel;
	}
	
	public void setGroupPosition(String groupPosition) {
		this.groupPosition = groupPosition;
	}
	
	public String getGroupPosition() {
		return groupPosition;
	}
	
	public void setGroupHeadRowCount(Integer groupHeadRowCount) {
		this.groupHeadRowCount = groupHeadRowCount;
	}
	
	public Integer getGroupHeadRowCount() {
		return groupHeadRowCount;
	}
	
	public void setGroupTailRowCount(Integer groupTailRowCount) {
		this.groupTailRowCount = groupTailRowCount;
	}
	
	public Integer getGroupTailRowCount() {
		return groupTailRowCount;
	}
	
	public Boolean isDetailLinked() {
		return this.detailLinkField;
	}
	
	public void setDetailLinked(Boolean detailLinkField) {
		this.detailLinkField = detailLinkField;
	}
	
	public String getIgnoreExport() {
		return this.ignoreExport;
	}
	
	public void setIgnoreExport(String ignoreExport) {
		this.ignoreExport = ignoreExport;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaExcelCell newCell = new MetaExcelCell();
		newCell.setCellIndex(cellIndex);
		newCell.setSourceType(sourceType);
		newCell.setDefinition(definition);
		newCell.setMergedColumnSpan(mergedColumnSpan);
		newCell.setMergedRowSpan(mergedRowSpan);
		newCell.setColumnExpand(isColumnExpand);
		newCell.setTableKey(tableKey);
		newCell.setGroupLevel(groupLevel);
		newCell.setGroupPosition(groupPosition);
		newCell.setGroupHeadRowCount(groupHeadRowCount);
		newCell.setGroupTailRowCount(groupTailRowCount);
		newCell.setDetailLinked(detailLinkField);
		newCell.setIgnoreExport(ignoreExport);
		
		newCell.setDisplay(display == null ? null : (MetaExcelDisplay)display.clone());
		newCell.setColumnExpand(columnExpand == null ? null : (MetaExcelColumnExpand)columnExpand.clone());
		
		return newCell;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExcelCell();
	}
	
	public boolean isDefault(){
		return  cellIndex == -1 &&
				sourceType==  ExcelTemplateCellType.Field &&
				definition.isEmpty() &&
				!isColumnExpand &&
				display == null && 
				tableKey .isEmpty() &&
				groupLevel == 0 &&
				groupPosition.isEmpty() &&
				groupHeadRowCount == 0 &&
				groupTailRowCount == 0 &&
				rowExpand == null &&
				columnExpand == null &&
				mergedRowSpan == 1 &&
				mergedColumnSpan == 1 ;
	}
}
