package com.bokesoft.yigo.meta.exceltemplate;

public class ExcelCellBorderType {
	/** 无边线 */
	public static final int Border_None = 0;
	public static final String STR_Border_None = "None";

	/** 双边线 */
	public static final int Border_Double = 1;
	public static final String STR_Border_Double = "Double";

	/** 细边线 */
	public static final int Border_Thin = 2;
	public static final String STR_Border_Thin = "Thin";

	/** 中等边线 */
	public static final int Border_Medium = 3;
	public static final String STR_Border_Medium = "Medium";

	/** 虚线边线 */
	public static final int Border_Dashed = 4;
	public static final String STR_Border_Dashed = "Dashed";

	/** 点状边线 */
	public static final int Border_Hair = 5;
	public static final String STR_Border_Hair = "Hair";

	/** 粗边线 */
	public static final int Border_Thick = 6;
	public static final String STR_Border_Thick = "Thick";

	public static int parse(String s) {
		int type = -1;
		if (STR_Border_None.equalsIgnoreCase(s)) {
			type = Border_None;
		} else if (STR_Border_Double.equalsIgnoreCase(s)) {
			type = Border_Double;
		} else if (STR_Border_Thin.equalsIgnoreCase(s)) {
			type = Border_Thin;
		} else if (STR_Border_Medium.equalsIgnoreCase(s)) {
			type = Border_Medium;
		} else if (STR_Border_Dashed.equalsIgnoreCase(s)) {
			type = Border_Dashed;
		} else if (STR_Border_Hair.equalsIgnoreCase(s)) {
			type = Border_Hair;
		} else if (STR_Border_Thick.equalsIgnoreCase(s)) {
			type = Border_Thick;
		}

		return type;
	}

	public static String toString(Integer type) {
		if(type == null)
			return "";
		
		String s = "";
		switch (type) {
		case Border_None:
			s = STR_Border_None;
			break;
		case Border_Double:
			s = STR_Border_Double;
			break;
		case Border_Thin:
			s = STR_Border_Thin;
			break;
		case Border_Medium:
			s = STR_Border_Medium;
			break;
		case Border_Dashed:
			s = STR_Border_Dashed;
			break;
		case Border_Hair:
			s = STR_Border_Hair;
			break;
		case Border_Thick:
			s = STR_Border_Thick;
			break;
		}
		return s;
	}
}
