package com.bokesoft.yigo.meta.entry;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.TreeMenuBarType;
import com.bokesoft.yigo.meta.base.AbstractCompositeObject;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericCompositeCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

public class MetaEntry extends GenericCompositeCollection {
	/** 入口项标识 */
	private String key = "";
	/** 入口项名称 */
	private String caption = "";
	/** 入口项英文名称 */
	private String captionEn = "";
	/** 是否展开子项 */
	private Boolean isOpen = false;
	/** 可见性 */
	private String visible = "";
	/** 图标 */
	private String icon = "";
	
	private String iconCode;
	
	/** 工程引用 */
	private String project = null;
	/** 入口项点击事件，移动端使用，*/
	private MetaBaseScript onClick=null;
	
	//===================非配置定义属性===================
	/** 样式 */
	private int style = TreeMenuBarType.GroupTree;
	/** 路径*/
	private String path = "";
	
	public MetaEntry() {
		super();
	}

	@Override
	public int getCompositeType() {
		return MetaEntryItem.ENTRY;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new Object[] {
				onClick
		});
	}

	public static final String TAG_NAME = "Entry";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaEntryItem.TAG_NAME.equals(tagName)) {
			MetaEntryItem metaEntryItem = new MetaEntryItem();
			this.add(metaEntryItem);
			resultMetaObject = metaEntryItem;
		} else if (MetaEntry.TAG_NAME.equals(tagName)) {
			MetaEntry metaEntry = new MetaEntry();
			this.add(metaEntry);
			resultMetaObject = metaEntry;
		}else if (tagName.equals(MetaConstants.Event_OnClick)) {
			onClick = new MetaBaseScript(MetaConstants.Event_OnClick);
			resultMetaObject = this.onClick;
		}

		return resultMetaObject;
	}

	public MetaBaseScript getOnClick() {
		return onClick;
	}

	public void setOnClick(MetaBaseScript onClick) {
		this.onClick = onClick;
	}

	public void setOpen(Boolean isOpen) {
		this.isOpen = isOpen;
	}

	public Boolean isOpen() {
		return this.isOpen;
	}

	/**
	 * 设置入口项标识
	 * 
	 * @param key
	 *            标识
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 取得入口项标识
	 * 
	 * @return 标识
	 */
	public String getKey() {
		return this.key;
	}

	/**
	 * 设置入口项名称
	 * 
	 * @param caption
	 *            名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}

	/**
	 * 取得入口项名称
	 * 
	 * @return 名称
	 */
	public String getCaption() {
		return this.caption;
	}

	/**
	 * 设置入口项英文名称
	 *
	 * @param captionEn
	 *            英文名称
	 */
	public void setCaptionEn(String captionEn) {
		this.captionEn = captionEn;
	}

	/**
	 * 取得入口项英文名称
	 *
	 * @return 英文名称
	 */
	public String getCaptionEn() {
		return this.captionEn;
	}

	/**
	 * 设置图标
	 * @param icon 图标
	 */
	public void setIcon(String icon) {
		this.icon = icon;
	}
	
	/**
	 * 取得图标
	 * @return 图标
	 */
	public String getIcon() {
		return this.icon;
	}
	
	/**
	 * 设置可见性
	 * @param visible 可见性
	 */
	public void setVisible(String visible) {
		this.visible = visible;
	}
	
	/**
	 * 取得可见性
	 * @return 可见性
	 */
	public String getVisible() {
		return this.visible;
	}
	
	/**
	 * 设置样式
	 * @param style 样式
	 */
	public void setStyle(int style) {
		this.style = style;
	}
	
	/**
	 * 取得样式
	 * @return 样式
	 */
	public int getStyle() {
		return this.style;
	}
	
	public String getIconCode() {
		return iconCode;
	}

	public void setIconCode(String iconCode) {
		this.iconCode = iconCode;
	}

	/**
	 * 设置工程引用
	 * @param project 工程引用
	 */
	public void setProject(String project) {
		this.project = project;
		this.setEntryProject(this, project);
	}
	
	public void setEntryProject(MetaEntry meta, String project) {
		MetaEntry entry = null;
		MetaEntryItem entryItem = null;
		AbstractMetaObject obj = null;
		for ( int i = 0, size = meta.size(); i < size; i++ ) {
			obj = meta.get(i);
			if(obj instanceof MetaEntry) {
				entry = (MetaEntry)obj;
				entry.setProject(project);
				if(entry.size() > 0) {
					this.setEntryProject(entry, project);
				}
			} else if(obj instanceof MetaEntryItem) {
				entryItem = (MetaEntryItem) obj;
				entryItem.setProject(project);
			}
		}
	}
	
	/**
	 * 取得工程引用
	 * @return 工程引用
	 */
	public String getProject() {
		return this.project;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaEntry newObject = (MetaEntry) super.clone();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setCaptionEn(captionEn);
		newObject.setOpen(isOpen);
		newObject.setIcon(icon);
		newObject.setStyle(style);
		newObject.setVisible(visible);
		newObject.setProject(project);
		newObject.setPath(path);
		newObject.setIconCode(iconCode);
		newObject.setOnClick(onClick == null ? null : (MetaBaseScript)onClick.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaEntry();
	}
	
	/**
	 * 合并一个入口菜单定义
	 * @param source 需要合并的入口菜单定义
	 */
	public void merge(MetaEntry source) {
		for ( int i =0, size = source.size(); i<size; ++i ) {
			this.add(source.get(i));
		}
	}
	
	/**
	 * 获取某个菜单入口
	 * @param key 标识
	 * @return 如果存在key指向的菜单入口定义则返回，否则返回null
	 */
	public AbstractCompositeObject findBy(String key) {
		Iterator<AbstractCompositeObject> iter = this.iterator();
		AbstractCompositeObject object = null;
		while (iter.hasNext()) {
			object = iter.next();
			if (object.getCompositeType() == MetaEntryItem.ENTRY) {
				MetaEntry metaEntry = (MetaEntry) object;
				if (key.equalsIgnoreCase(metaEntry.getKey())) {
					return metaEntry;
				}
				AbstractCompositeObject obj = metaEntry.findBy(key);
				if (obj != null) {
					return obj;
				}
			} else if (object.getCompositeType() == MetaEntryItem.ENTRY_ITEM){
				MetaEntryItem metaEntryItem = (MetaEntryItem) object;
				if (key.equalsIgnoreCase(metaEntryItem.getKey())) {
					return metaEntryItem;
				}
			}
		}
		return null;
	}
	
	/**
	 * 仅从第一级子项中查找key指定的入口定义
	 * @param key 标识
	 * @return 如果第一级子项中存在key指定的入口定义则返回，否则返回null
	 */
	public AbstractCompositeObject findChild(String key) {
		Iterator<AbstractCompositeObject> iter = this.iterator();
		AbstractCompositeObject object = null;
		while (iter.hasNext()) {
			object = iter.next();
			if (object.getCompositeType() == MetaEntryItem.ENTRY) {
				MetaEntry metaEntry = (MetaEntry) object;
				if (key.equalsIgnoreCase(metaEntry.getKey())) {
					return metaEntry;
				}
			} else if (object.getCompositeType() == MetaEntryItem.ENTRY_ITEM){
				MetaEntryItem metaEntryItem = (MetaEntryItem) object;
				if (key.equalsIgnoreCase(metaEntryItem.getKey())) {
					return metaEntryItem;
				}
			}
		}
		return null;
	}
	
	/**
	 * 移除菜单入库项
	 * 
	 * @param obj 入口定义对象
	 */
	public void removeBy(AbstractCompositeObject obj) {
		Iterator<AbstractCompositeObject> iter = this.iterator();
		AbstractCompositeObject object = null;
		while (iter.hasNext()) {
			object = iter.next();
			if (object.getCompositeType() == MetaEntryItem.ENTRY) {
				MetaEntry metaEntry = (MetaEntry) object;
				if (metaEntry == obj) {
					this.remove(obj);
					return;
				} else {
					metaEntry.remove(obj);
				}
			} else if (object.getCompositeType() == MetaEntryItem.ENTRY_ITEM){
				MetaEntryItem metaEntryItem = (MetaEntryItem) object;
				if (metaEntryItem == obj) {
					this.remove(obj);
				}
			}
		}
	}

	/**
	 * 获取路径
	 * @return 路径
	 */
	public String getPath() {
		return path;
	}

	/**
	 * 设置路径 
	 * @param path 路径
	 */
	public void setPath(String path) {
		this.path = path;
	}
	
}
