package com.bokesoft.yigo.meta.diff;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaMove extends KeyPairMetaObject {
	
	public static final String TAG_NAME = "Move";
	
	// 节点标识
	private String key = null;
	
	private String moveTag = "";

	// 移动至目标的标志, 为null时表示本身容器内部移动
	private String targetContainerKey = "";
	
	// 节点位置偏移量
	private Integer indexOffSet = 0;
	
	private String previousKey = "";
	
	// 被移动节点所在的父亲节点的tag
	private String parentTag = "";

	
	public MetaMove() {
	}
	
	public MetaMove(String key, String moveTag, String parentTag, String targetContainerKey, String previousKey) {
		this.key = key;
		this.moveTag = moveTag;
		this.targetContainerKey = targetContainerKey;
		this.previousKey = previousKey;
		this.parentTag = parentTag;
	}
	
	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public String getKey() {
		return key;
	}
	
	public void setPreviousKey(String previousKey) {
		this.previousKey = previousKey;
	}

	public String getPreviousKey() {
		return previousKey;
	}

	public void setIndexOffSet(Integer indexOffSet) {
		this.indexOffSet = indexOffSet;
	}
	
	public Integer getIndexOffSet() {
		return this.indexOffSet;
	}
	
	public void setTargetContainerKey(String target) {
		this.targetContainerKey = target;
	}
	
	public String getTargetContainerKey() {
		return this.targetContainerKey;
	}

	public void setMoveTag(String moveTagName) {
		this.moveTag = moveTagName;
	}
	
	public String getMoveTag() {
		return this.moveTag;
	}
	
	public void setParentTag(String parentTag) {
		this.parentTag = parentTag;
	}
	
	public String getParentTag() {
		return this.parentTag;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaMove o = new MetaMove();
		o.setKey(key);
		o.setIndexOffSet(this.getIndexOffSet());
		o.setTargetContainerKey(this.getTargetContainerKey());
		o.setMoveTag(this.getMoveTag());
		return o;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaMove();
	}
	
	public static MetaMove create(String key, String moveTag, String parentTag, String target, String previousKey) {
		return new MetaMove( key, moveTag, parentTag, target, previousKey);
	}
}
