package com.bokesoft.yigo.meta.datamigration;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.datamap.source.FieldType;

/**
 * MetaDMSourceField定义迁移关系中的源字段描述。
 * <p>
 * 对于一个源字段，其类型可以是字段域、表达式、常量，定义其取值方式；
 * <ul>
 * <li>字段域，即源值来源于数据对象中的某个表中的字段域；
 * <li>表达式，即源值需要解析表达式的内容来计算出结果；
 * <li>常量，即源值是一个常量，始终不变。
 * </ul>
 * <p>
 * 对字段值的处理可以是加变化值、加直接量、直接赋值。
 * <ul>
 * <li>加变化值，将新值相对于老值的变化值加到目标值上；
 * <li>加直接值，将新值直接加到目标值上；
 * <li>直接赋值，将新值直接覆盖目标值。
 * </ul>
 * <p>
 * 如果定义一个源字段为分组字段(即相同分组值的数据会迁移到目标的同一数据行中)，那么需要定义分组的策略，目前支持的分组策略分为直接取值和期间分组。
 * <p>
 * 最后需要定义源字段的迁移目标，由目标表标识和目标字段标识确定迁移的目标。
 * 
 * @author 王元和
 * @since YES 1.0
 */
public class MetaDMSourceField extends KeyPairMetaObject {
	/**
	 * 值类型
	 * 
	 * @see DMFieldType
	 */
	private Integer type = FieldType.FIELD;
	private String key = "";
	/**
	 * 源字段的来源定义，根据源泉字段的类型而定。
	 * <ul>
	 * <li>如果源字段类型为字段域，那么该定义为表中的字段标识
	 * <li>如果源字段类型为公式，那么该定义为表达式字符串
	 * <li>如果源字段类型为常量，那么该定义为常量字符串(根据目标类型进行类型转换)
	 * </ul>
	 */
	private String definition = null;

	/**
	 * 值处理方式
	 * 
	 * @see DMOpSign
	 */
	private Integer opSign = DMOpSign.OP_ADD_DELTA;

	/** 是否负向迁移标志，取得为true时，对值进行负向处理 */
	private Boolean isNegtive = false;

	/** 分组策略 */
	private Integer groupingPolicy = DMGroupingPolicyType.Discrete;

	/** 期间字段取值方式定义 */
	private Integer periodValue = DMPeriodValuePeekType.Default;

	/** 值映射公式 */
	private String mapFormula = "";

	/** 目标表标识，用于确定数据写到数据对象的哪个表中 */
	private String targetTableKey = "";

	/** 目标字段标识，用于确定数据写到数据表的哪个字段中 */
	private String targetFieldKey = "";

	/** 参照的主表字段标识 */
	private String refFieldKey = "";

	// 预处理之后的属性，无需保存。
	/** 所属的表的KEY */
	private String tableKey = "";
	/** 分组类型 */
	private int groupType = -1;
	/** 常量值 */
	private Object constValue;
	/** 映射是否需要进行值的类型的转换 */
	private boolean needTypeConvert = false;
	/** 类型的转换的目标类型 */
	private int targetFieldDataType = -1;
	/** 时间粒度，时间类型的转换方式 */
	private int dateGranularity = -1;
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "SourceField";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	/**
	 * 设置字段类型
	 * 
	 * @param type
	 *            类型
	 * @see #type
	 */
	public void setType(Integer type) {
		this.type = type;
	}

	/**
	 * 取得字段类型
	 * 
	 * @return 类型
	 * @see #type
	 */
	public Integer getType() {
		return this.type;
	}

	/**
	 * 设置字段定义
	 * 
	 * @param definition
	 *            字段定义
	 * @see #definition
	 */
	public void setDefinition(String definition) {
		this.definition = definition;
	}

	/**
	 * 取得字段这定义
	 * 
	 * @return 字段定义
	 * @see #definition
	 */
	public String getDefinition() {
		if (type == FieldType.CONST || type == FieldType.FORMULA){
			return definition;
		}
		return (definition != null && !definition.isEmpty()) ? definition : key;
	}
	public String getDBDefinition() {
		return      definition;
	}

	@Override
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 设置值处理方式
	 * 
	 * @param opSign
	 *            处理方式
	 * @see #opSign
	 */
	public void setOpSign(Integer opSign) {
		this.opSign = opSign;
	}

	/**
	 * 取得值处理方式
	 * 
	 * @return 处理方式
	 * @see #opSign
	 */
	public Integer getOpSign() {
		return this.opSign;
	}

	/**
	 * 设置是否负向迁移标志
	 * 
	 * @param isNegtive
	 *            标志
	 * @see #isNegtive
	 */
	public void setIsNegtive(Boolean isNegtive) {
		this.isNegtive = isNegtive;
	}

	/**
	 * 取得是否负向迁移标志
	 * 
	 * @return 标志
	 * @see #isNegtive
	 */
	public Boolean getIsNegtive() {
		return this.isNegtive;
	}

	/**
	 * 设置分组策略
	 * 
	 * @param groupingPolicy 分组策略
	 * @see #groupingPolicy
	 */
	public void setGroupingPolicy(Integer groupingPolicy) {
		this.groupingPolicy = groupingPolicy;
	}

	/**
	 * 取得分组策略
	 * 
	 * @return 分组策略
	 * @see #groupingPolicy
	 */
	public Integer getGroupingPolicy() {
		return groupingPolicy;
	}

	/**
	 * 设置期间取值方式
	 * 
	 * @param periodValue 期间取值方式
	 * @see #periodValue
	 */
	public void setPeriodValue(Integer periodValue) {
		this.periodValue = periodValue;
	}

	/**
	 * 取得期间取值方式
	 * 
	 * @return 期间取值方式
	 * @see #periodValue
	 */
	public Integer getPeriodValue() {
		return this.periodValue;
	}


	/**
	 * 设置值映射公式
	 * 
	 * @param mapFormula 值映射公式
	 */
	public void setMapFormula(String mapFormula) {
		this.mapFormula = mapFormula;
	}

	/**
	 * 取得值映射公式
	 * 
	 * @return 值映射公式
	 */
	public String getMapFormula() {
		return this.mapFormula;
	}

	/**
	 * 设置迁移的目标表标识
	 * 
	 * @param targetTableKey 表标识
	 * @see #targetTableKey
	 */
	public void setTargetTableKey(String targetTableKey) {
		this.targetTableKey = targetTableKey;
	}

	/**
	 * 取得迁移的目标表标识
	 * 
	 * @return 表标识
	 * @see #targetTableKey
	 */
	public String getTargetTableKey() {
		return this.targetTableKey;
	}

	/**
	 * 设置迁移的目标字段标识
	 * 
	 * @param targetFieldKey 字段标识
	 * @see #targetFieldKey
	 */
	public void setTargetFieldKey(String targetFieldKey) {
		this.targetFieldKey = targetFieldKey;
	}

	/**
	 * 取得迁移的目标字段标识
	 * 
	 * @return 字段标识
	 * @see #targetFieldKey
	 */
	public String getTargetFieldKey() {
		return this.targetFieldKey;
	}

	/**
	 * 取得表标识
	 * @return 表标识
	 */
	public String getTableKey() {
		return tableKey;
	}

	/**
	 * 设置表标识
	 * @param tableKey 表标识
	 */
	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}

	/**
	 * 取得分组类型
	 * @return 分组类型
	 */
	public int getGroupType() {
		return groupType;
	}
	
	/**
	 * 设置分组类型
	 * @param groupType 分组类型
	 */
	public void setGroupType(int groupType) {
		this.groupType = groupType;
	}

	/**
	 * 取得常量值
	 * @return 常量值
	 */
	public Object getConstValue() {
		return constValue;
	}

	/**
	 * 设置常量值
	 * @param constValue 常量值
	 */
	public void setConstValue(Object constValue) {
		this.constValue = constValue;
	}

	/**
	 * 取得是否需要类型转换标志
	 * @return 标志 
	 */
	public boolean isNeedTypeConvert() {
		return needTypeConvert;
	}

	/**
	 * 设置是否需要类型转换标志
	 * @param needTypeConvert 标志
	 */
	public void setNeedTypeConvert(boolean needTypeConvert) {
		this.needTypeConvert = needTypeConvert;
	}

	/**
	 * 取得目标字段的数据类型
	 * @return 数据类型
	 */
	public int getTargetFieldDataType() {
		return targetFieldDataType;
	}

	/**
	 * 设置目标字段的数据类型
	 * @param targetFieldDataType 数据类型
	 */
	public void setTargetFieldDataType(int targetFieldDataType) {
		this.targetFieldDataType = targetFieldDataType;
	}

	public int getDateGranularity() {
		return dateGranularity;
	}

	public void setDateGranularity(int dateGranularity) {
		this.dateGranularity = dateGranularity;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaDMSourceField newSourceField = new MetaDMSourceField();
		newSourceField.setType(type);
		newSourceField.setKey(key);
		newSourceField.setDefinition(definition);
		newSourceField.setOpSign(opSign);
		newSourceField.setIsNegtive(isNegtive);
		newSourceField.setGroupingPolicy(groupingPolicy);
		newSourceField.setPeriodValue(periodValue);
		newSourceField.setMapFormula(mapFormula);
		newSourceField.setTargetTableKey(targetTableKey);
		newSourceField.setTargetFieldKey(targetFieldKey);
		newSourceField.setRefFieldKey(refFieldKey);
		return newSourceField;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDMSourceField();
	}

	public String getRefFieldKey() {
		return refFieldKey;
	}

	public void setRefFieldKey(String refFieldKey) {
		this.refFieldKey = refFieldKey;
	}

	@Override
	public String getKey() {
		return key ;
	}
	/*public boolean needPreLoad() {
		return true;
	}*/
}
