package com.bokesoft.yigo.meta.datamap.target;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.datamap.source.FieldType;

/**
 * 数据映射目标字段对象
 * 
 * @author 刘翔翔
 *
 */
public class MetaTargetField extends GenericNoKeyCollection<MetaFeedback> {

	/** 标签名 */
	public static final String TAG_NAME = "TargetField";

	/** 字段类型 */
	private Integer type = FieldType.FIELD;

	/** 字段的定义 */
	private String definition = "";

	/** 字段是否进行反填的条件 */
	private String condition = "";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		if (MetaFeedback.TAG_NAME.equals(tagName)) {
			MetaFeedback feedback = new MetaFeedback();
			feedback.preProcessMetaObject(env, doc, node, flag, runType);
			add(feedback);

			return feedback;
		}
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaTargetField newMetaTargetField = (MetaTargetField) super.clone();
		newMetaTargetField.setType(type);
		newMetaTargetField.setDefinition(definition);
		return newMetaTargetField;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTargetField();
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getDefinition() {
		return definition;
	}

	public void setDefinition(String definition) {
		this.definition = definition;
	}

	public String getCondition() {
		return condition;
	}

	public void setCondition(String condition) {
		this.condition = condition;
	}
}
