package com.bokesoft.yigo.meta.datamap.source;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;


public class MetaSourceField extends KeyPairMetaObject  {
	

	private String key = "";
	public static final String TAG_NAME = "SourceField";
	private Integer type = FieldType.FIELD;
	private Integer opSign = FieldType.OP_ASSIGN;
	private Integer edgeType = FieldType.EDGE_NORMAL;
	private Boolean isNegtive = false;
	private String condition = "";
	private Boolean editable = true;
	private String targetTableKey = "";
	private String targetFieldKey = "";
	private String refFieldKey = "";
	private String definition = "";

	private Object constValue;
	private boolean needTypeConvert = false;
	private int targetFieldDataType = -1;
	private boolean targetFieldAccessControl=false;
	private String targetDirectionFieldKey ="";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaSourceField newMetaSourceField = new MetaSourceField();
		newMetaSourceField.setKey(key);
		newMetaSourceField.setType(type);
		newMetaSourceField.setOpSign(opSign);
		newMetaSourceField.setEdgeType(edgeType);
		newMetaSourceField.setCondition(condition);
		newMetaSourceField.setEditable(editable);
		newMetaSourceField.setTargetTableKey(targetTableKey);
		newMetaSourceField.setTargetFieldKey(targetFieldKey);
		newMetaSourceField.setRefFieldKey(refFieldKey);
		newMetaSourceField.setDefinition(definition);
		newMetaSourceField.setConstValue(constValue);
		newMetaSourceField.setNeedTypeConvert(needTypeConvert);
		newMetaSourceField.setTargetFieldDataType(targetFieldDataType);
		newMetaSourceField.setTargetFieldAccessControl(targetFieldAccessControl);
		// TODO: newMetaSourceField.setNegtive(isNegtive);
//		newMetaSourceField.setNegtive(isNegtive);
		return newMetaSourceField;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSourceField();
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public Integer getOpSign() {
		return opSign;
	}

	public void setOpSign(Integer opSign) {
		this.opSign = opSign;
	}

	public Integer getEdgeType() {
		return edgeType;
	}

	public void setEdgeType(Integer edgeType) {
		this.edgeType = edgeType;
	}

	public String getCondition() {
		return condition;
	}

	public void setCondition(String condition) {
		this.condition = condition;
	}

	public Boolean isEditable() {
		return editable;
	}

	public void setEditable(Boolean editable) {
		this.editable = editable;
	}

	public String getTargetTableKey() {
		return targetTableKey;
	}

	public void setTargetTableKey(String targetTableKey) {
		this.targetTableKey = targetTableKey;
	}

	public String getTargetFieldKey() {
		return targetFieldKey;
	}

	public void setTargetFieldKey(String targetFieldKey) {
		this.targetFieldKey = targetFieldKey;
	}

	public String getRefFieldKey() {
		return refFieldKey;
	}

	public void setRefFieldKey(String refFieldKey) {
		this.refFieldKey = refFieldKey;
	}

	public String getDefinition() {
		if (type == FieldType.CONST || type == FieldType.FORMULA){
			return definition;
		}
		return  (definition != null && !definition.isEmpty()) ? definition : key;
	}
	public String getDBDefinition() {
		return definition;
	}

	public void setDefinition(String definition) {
		this.definition = definition;
	}

	public Object getConstValue() {
		return constValue;
	}

	public void setConstValue(Object constValue) {
		this.constValue = constValue;
	}

	public boolean isNeedTypeConvert() {
		return needTypeConvert;
	}

	public void setNeedTypeConvert(boolean needTypeConvert) {
		this.needTypeConvert = needTypeConvert;
	}

	public int getTargetFieldDataType() {
		return targetFieldDataType;
	}

	public void setTargetFieldDataType(int targetFieldDataType) {
		this.targetFieldDataType = targetFieldDataType;
	}

	public boolean isTargetFieldAccessControl() {
		return targetFieldAccessControl;
	}

	public void setTargetFieldAccessControl(boolean targetFieldAccessControl) {
		this.targetFieldAccessControl = targetFieldAccessControl;
	}

	public Boolean isNegtive() {
		return isNegtive;
	}

	public void setNegtive(Boolean isNegtive) {
		this.isNegtive = isNegtive;
	}

	
	public String getTargetDirectionFieldKey() {
		return targetDirectionFieldKey;
	}

	public void setTargetDirectionFieldKey(String targetDirectionFieldKey) {
		this.targetDirectionFieldKey = targetDirectionFieldKey;
	}
	
	
}
