package com.bokesoft.yigo.meta.datamap.diagram;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaFeedbackCollection extends GenericKeyCollection<MetaFeedbackObject> {
	/** 状态字段标识 */
	private String statusFieldKey = "";
	/** 状态值 */
	private String statusValue = "";
	/** 数据条件 */
	private String condition = "";

	public MetaFeedbackCollection() {
		super();
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "FeedbackCollection";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	/**
	 * 设置状态字段标识
	 * 
	 * @param statusFieldKey
	 *            字段标识
	 */
	public void setStatusFieldKey(String statusFieldKey) {
		this.statusFieldKey = statusFieldKey;
	}

	/**
	 * 取得状态字段标识
	 * 
	 * @return 字段标识
	 */
	public String getStatusFieldKey() {
		return this.statusFieldKey;
	}

	/**
	 * 设置状态值
	 * 
	 * @param statusValue
	 *            状态值
	 */
	public void setStatusValue(String statusValue) {
		this.statusValue = statusValue;
	}

	/**
	 * 取得状态值
	 * 
	 * @return 状态值
	 */
	public String getStatusValue() {
		return this.statusValue;
	}

	/**
	 * 设置数据条件
	 * 
	 * @param condition
	 *            数据条件
	 */
	public void setCondition(String condition) {
		this.condition = condition;
	}

	/**
	 * 取得数据条件
	 * 
	 * @return 数据条件
	 */
	public String getCondition() {
		return this.condition;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaFeedbackObject.TAG_NAME.equals(tagName)) {
			MetaFeedbackObject feedbackObject = new MetaFeedbackObject();
			feedbackObject.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(feedbackObject);
			resultMetaObject = feedbackObject;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaFeedbackCollection newObject = (MetaFeedbackCollection) super.clone();
		newObject.setStatusFieldKey(statusFieldKey);
		newObject.setStatusValue(statusValue);
		newObject.setCondition(condition);

		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFeedbackCollection();
	}

}
