package com.bokesoft.yigo.meta.datamap;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.datamap.MetaMapConstants;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.datamap.calculate.MetaMapParas;
import com.bokesoft.yigo.meta.datamap.diagram.MetaFeedbackCollection;
import com.bokesoft.yigo.meta.datamap.error.MetaDataMapErrorInfoCollection;
import com.bokesoft.yigo.meta.datamap.relatedatamap.MetaRelateDataMapCollection;
import com.bokesoft.yigo.meta.datamap.source.MetaSourceTable;
import com.bokesoft.yigo.meta.datamap.source.MetaSourceTableCollection;
import com.bokesoft.yigo.meta.datamap.split.MetaSplit;
import com.bokesoft.yigo.meta.datamap.target.MetaTargetField;
import com.bokesoft.yigo.meta.datamap.target.MetaTargetTable;
import com.bokesoft.yigo.meta.datamap.target.MetaTargetTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.intf.IMetaProject;

/**
 * MetaMap定义了从一个数据对象到一个数据对象的数据映射关系。
 * 
 * @author 刘翔翔
 */
public class MetaMap extends KeyPairMetaObject {
	/** 标签名 */
	public static final String TAG_NAME = "Map";

	/** 映射的标识 */
	private String key = "";
	/** 映射的名称 */
	private String caption = "";
	/** 映射的描述 */
	private String description = "";
	/** 源数据对象标识 */
	private String srcDataObjectKey = "";
	/** 目标数据对象标识 */
	private String tgtDataObjectKey = "";

	/** 允许将关系值下推 */
	private Boolean mapRelationValue = true;
	/** 剩余下推量 */
	private String remainderPushValue = "";
	/** 总体最大下推值 */
	private String maxPushValue = "";
	/** 单次最小下推值 */
	private String minPushValue = "";
	/** 是否允许超量 */
	private Boolean allowSurplus = false;
	/** 允许余量下推 */
	private Boolean allowRemainderPush = true;

	/** 数据映射执行的前提条件 */
	private String mapCondition = "";
	/** 中间层下推完之后执行的二次开发公式 */
	private MetaBaseScript postProcess = null;

	/** 关联的映射 */
	private MetaRelateDataMapCollection relateDataMapCollection = null;
	/** 源数据表集合 */
	private MetaSourceTableCollection sourceTableCollection = null;
	/** 目标数据表集合 */
	private MetaTargetTableCollection targetTableCollection = null;
	/** 反填数据表集合 */
	private MetaFeedbackCollection feedbackCollection = null;
	/** 解析之后的映射设置 */
	private MetaMapParas dataMapParas = null;
	/** 分组拆分定义 */
	private MetaSplit mapSplit = null;
	/** 当前映射关系仅推送数据，不建立关系 */
	private Boolean pullDataOnly = false;
	/** 是否在源单上记录通过映射产生的数据条数 */
	private Boolean markMapCount = true;
	
	/** 映射所在的工程*/
	private IMetaProject project = null;
	
	/** 错误信息集合*/
	private MetaDataMapErrorInfoCollection errorInfoCollection = null;
	
	@Override
	public String getKey() {
		return key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { postProcess , relateDataMapCollection, sourceTableCollection, targetTableCollection, feedbackCollection, mapSplit,errorInfoCollection});
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject child = null;
		if (MetaSourceTableCollection.TAG_NAME.equals(tagName)) {
			sourceTableCollection = new MetaSourceTableCollection();
			child = sourceTableCollection;
		} else if (MetaTargetTableCollection.TAG_NAME.equals(tagName)) {
			targetTableCollection = new MetaTargetTableCollection();
			child = targetTableCollection;
		} else if (MetaFeedbackCollection.TAG_NAME.equals(tagName)) {
			feedbackCollection = new MetaFeedbackCollection();
			child = feedbackCollection;
		} else if (MetaRelateDataMapCollection.TAG_NAME.equals(tagName)) {
			relateDataMapCollection = new MetaRelateDataMapCollection();
			child = relateDataMapCollection;
		} else if (MetaSplit.TAG_NAME.equals(tagName)) {
			mapSplit = new MetaSplit();
			child = mapSplit;
		} else if (MetaMapConstants.MAP_POSTPROCESS.equals(tagName)) {
			postProcess = new MetaBaseScript(MetaMapConstants.MAP_POSTPROCESS);
			child = postProcess;
		}else if (MetaDataMapErrorInfoCollection.TAG_NAME.equals(tagName)) {
			errorInfoCollection = new MetaDataMapErrorInfoCollection();
			child = errorInfoCollection;
		}

		if (child != null) {
			child.preProcessMetaObject(env, doc, node, flag, runType);
		}

		return child;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaMap newMetaMap = new MetaMap();
		newMetaMap.setKey(key);
		newMetaMap.setCaption(caption);
		newMetaMap.setDescription(description);
		newMetaMap.setSrcDataObjectKey(srcDataObjectKey);
		newMetaMap.setTgtDataObjectKey(tgtDataObjectKey);
		newMetaMap.setMapRelationValue(mapRelationValue);
		newMetaMap.setMaxPushValue(maxPushValue);
		newMetaMap.setMinPushValue(minPushValue);
		newMetaMap.setAllowSurplus(allowSurplus);
		newMetaMap.setRemainderPushValue(remainderPushValue);
		newMetaMap.setAllowRemainderPush(allowRemainderPush);
		newMetaMap.setMapCondition(mapCondition);
		newMetaMap.setRelateDataMapCollection(relateDataMapCollection == null ? null : (MetaRelateDataMapCollection) relateDataMapCollection.clone());
		newMetaMap.setSourceTableCollection(sourceTableCollection == null ? null : (MetaSourceTableCollection) sourceTableCollection.clone());
		newMetaMap.setTargetTableCollection(targetTableCollection == null ? null : (MetaTargetTableCollection) targetTableCollection.clone());
		newMetaMap.setFeedbackCollection(feedbackCollection == null ? null : (MetaFeedbackCollection) feedbackCollection.clone());
		newMetaMap.setSplit(mapSplit == null ? null : (MetaSplit) mapSplit.clone());
		newMetaMap.setPostProcess(postProcess);
		newMetaMap.setErrorInfoCollection(errorInfoCollection == null ? null : (MetaDataMapErrorInfoCollection)errorInfoCollection.clone());
		return newMetaMap;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaMap();
	}

	public String getCaption() {
		return caption;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getSrcDataObjectKey() {
		return srcDataObjectKey;
	}

	public void setSrcDataObjectKey(String srcDataObjectKey) {
		this.srcDataObjectKey = srcDataObjectKey;
	}

	public String getTgtDataObjectKey() {
		return tgtDataObjectKey;
	}

	public void setTgtDataObjectKey(String tgtDataObjectKey) {
		this.tgtDataObjectKey = tgtDataObjectKey;
	}

	public String getMaxPushValue() {
		return maxPushValue;
	}

	public void setMaxPushValue(String maxPushValue) {
		this.maxPushValue = maxPushValue;
	}

	public MetaSourceTableCollection getSourceTableCollection() {
		return sourceTableCollection;
	}

	public void setSourceTableCollection(MetaSourceTableCollection sourceTableCollection) {
		this.sourceTableCollection = sourceTableCollection;
	}

	public void setTargetTableCollection(MetaTargetTableCollection targetTableCollection) {
		this.targetTableCollection = targetTableCollection;
	}

	public MetaTargetTableCollection getTargetTableCollection() {
		return targetTableCollection;
	}

	public MetaFeedbackCollection getFeedbackCollection() {
		return feedbackCollection;
	}

	public void setFeedbackCollection(MetaFeedbackCollection feedbackCollection) {
		this.feedbackCollection = feedbackCollection;
	}

	public MetaSplit getSplit() {
		return mapSplit;
	}

	public void setSplit(MetaSplit metaSplit) {
		mapSplit = metaSplit;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public MetaMapParas getDataMapParas(IMetaFactory factory) throws Throwable {
		if (dataMapParas == null) {
			synchronized (this) {
				if (dataMapParas == null)
					dataMapParas = new MetaMapParas(this, factory);
			}
		}

		return dataMapParas;
	}
	
	public boolean isMapTargetField(String tableKey,String columnKey) throws Throwable {
		MetaTargetTable targetTable = targetTableCollection.get(tableKey);
		if( targetTable == null )
			return false;
		for( MetaTargetField field : targetTable ) {
			if( field.getDefinition().equals(columnKey) || (field.getDefinition() + "_CF").equals(columnKey))
				return true;
		}
		return false;
	}
	
	public boolean midMap() {
		return postProcess != null && postProcess.getContent().length() > 0;
	}

	public MetaSourceTable getSourceTable(String key) {
		return sourceTableCollection.get(key);
	}

	public String getMinPushValue() {
		return minPushValue;
	}

	public void setMinPushValue(String minPushValue) {
		this.minPushValue = minPushValue;
	}

	public Boolean isMarkMapCount() {
		return markMapCount;
	}

	public void setMarkMapCount(Boolean markMapCount) {
		this.markMapCount = markMapCount;
	}

	public Boolean isPullDataOnly() {
		return pullDataOnly;
	}

	public void setPullDataOnly(Boolean pullDataOnly) {
		this.pullDataOnly = pullDataOnly;
	}

	public Boolean getAllowSurplus() {
		return allowSurplus;
	}

	public MetaRelateDataMapCollection getRelateDataMapColletion() {
		return relateDataMapCollection;
	}

	public void setRelateDataMapCollection(MetaRelateDataMapCollection relateDataMapCollection) {
		this.relateDataMapCollection = relateDataMapCollection;
	}

	public void setAllowSurplus(Boolean allowSurplus) {
		this.allowSurplus = allowSurplus;
	}

	public String getMapCondition() {
		return mapCondition;
	}

	public void setMapCondition(String mapCondition) {
		this.mapCondition = mapCondition;
	}

	public MetaBaseScript getPostProcess() {
		return postProcess;
	}

	public void setPostProcess(MetaBaseScript postProcess) {
		this.postProcess = postProcess;
	}

	public String getRemainderPushValue() {
		return remainderPushValue;
	}

	public void setRemainderPushValue(String remainderPushValue) {
		this.remainderPushValue = remainderPushValue;
	}

	public Boolean getAllowRemainderPush() {
		return allowRemainderPush;
	}

	public void setAllowRemainderPush(Boolean allowRemainderPush) {
		this.allowRemainderPush = allowRemainderPush;
	}

	public Boolean getMapRelationValue() {
		return mapRelationValue;
	}

	public void setMapRelationValue(Boolean mapRelationValue) {
		this.mapRelationValue = mapRelationValue;
	}

	public IMetaProject getProject() {
		return project;
	}

	public void setProject(IMetaProject project) {
		this.project = project;
	}

	public MetaDataMapErrorInfoCollection getErrorInfoCollection() {
		return errorInfoCollection;
	}

	public void setErrorInfoCollection(MetaDataMapErrorInfoCollection errorInfoCollection) {
		this.errorInfoCollection = errorInfoCollection;
	}
}
