package com.bokesoft.yigo.meta.commondef;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaSearchBoxProvider extends KeyPairMetaObject {
	/** 标识 */
	private String key = "";
	/** 名称 */
	private String caption = "";
	/** dataObjectKey */
	private String dataObjectKey = "";
	/** tableKey */
	private String tableKey = "";
	/** columnKey */
	private String columnKey = "";
	/** 弹出框配置 */
	private String popConfigKey = "";
	/** 类型 */
	private Integer type = 0;
	/** sql语句 */
	private String sql = "";
	/** 接口 */
	private String impl = "";
	
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub	
	}

	public static final String TAG_NAME = "SearchBoxProvider";
	
	@Override
	public String getTagName() { 
		return TAG_NAME;
	}
	
	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得标识
	 * @return 标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置名称
	 * @param caption 名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得名称
	 * @return 名称
	 */
	public String getCaption() {
		return this.caption;
	}

	/**
	 * 设置DataObjectKey
	 * @param dataObjectKey 数据对象标识
	 */
	public void setDataObjectKey(String dataObjectKey){
		this.dataObjectKey = dataObjectKey;
	}
	
	/**
	 * 获取DataObjectKey
	 * @return 数据对象标识
	 */
	public String getDataObjectKey(){
		return this.dataObjectKey;
	}
	
	/**
	 * 设置TableKey
	 * @param tableKey 给标识
	 */
	public void setTableKey(String tableKey){
		this.tableKey = tableKey;
	}
	
	/**
	 * 获取TableKey
	 * @return 表标识
	 */
	public String getTableKey(){
		return this.tableKey;
	}
	
	/**
	 * 设置ColumnKey
	 * @param columnKey 列标识
	 */
	public void setColumnKey(String columnKey){
		this.columnKey = columnKey;
	}
	
	/**
	 * 获取ColumnKey
	 * @return 列标识
	 */
	public String getColumnKey(){
		return this.columnKey;
	}
	
	/**
	 * 设置弹出窗口配置
	 * @param configKey 配置标识
	 */
	public void setPopConfigKey(String configKey){
		this.popConfigKey = configKey;
	}
	
	/**
	 * 获取弹出窗口配置
	 * @return 配置标识
	 */
	public String getPopConfigKey(){
		return this.popConfigKey;
	}
	
	/**
	 * 设置provider类型
	 * @param type 类型
	 */
	public void setType(Integer type){
		this.type = type;
	}
	
	/**
	 * 获取provider类型
	 * @return 类型
	 */
	public Integer getType(){
		return this.type;
	}
	
	/**
	 * 设置SQL语句
	 * @param sql SQL语句
	 */
	public void setSQL(String sql){
		this.sql = sql;
	}
	
	/**
	 * 获取SQL语句
	 * @return SQL语句
	 */
	public String getSQL(){
		return this.sql;
	}
	
	/**
	 * 设置接口类
	 * @param impl 实现类全名
	 */
	public void setImpl(String impl){
		this.impl = impl;
	}
	
	/**
	 * 获取接口类
	 * @return 实现类全名
	 */
	public String getImpl(){
		return this.impl;
	}
	
	
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaSearchBoxProvider newObject = (MetaSearchBoxProvider)newInstance();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setDataObjectKey(dataObjectKey);
		newObject.setTableKey(tableKey);
		newObject.setColumnKey(columnKey);
		newObject.setSQL(sql);
		newObject.setType(type);
		newObject.setPopConfigKey(popConfigKey);
		newObject.setImpl(impl);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSearchBoxProvider();
	}

}
