package com.bokesoft.yigo.meta.common;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map.Entry;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 表单服务权限集合
 * @author zhufw
 *
 */
public class MetaServiceRightsCollection extends GenericKeyCollection<MetaServiceRights> {

	public static final String TAG_NAME = "ServiceRightsCollection";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		Iterator<Entry<String, MetaServiceRights>> itEntry = elementMap.entrySet().iterator();
		Entry<String, MetaServiceRights> entry = null;
		while (itEntry.hasNext()) {
			entry = itEntry.next();
			//String key = entry.getKey();  // serviceRights.key
			MetaServiceRights sver = entry.getValue();
			list.add(sver);
		}
		//System.out.println("--- MetaServiceRightsCollection.getChildMetaObjects().list:"+list.toString());
	}

	public JSONArray toJSONArray() throws SerializationException {
		Iterator<Entry<String, MetaServiceRights>> itEntry = this.entryIterator();
		JSONObject svr = null;   
		JSONArray jarr = new JSONArray();
		Entry<String, MetaServiceRights> entry = null;
		while (itEntry.hasNext()) {
			entry = itEntry.next();
			MetaServiceRights ob = entry.getValue();
			svr = new JSONObject();
			svr.put("key", ob.getKey());
			svr.put("caption", ob.getCaption());
			svr.put("refOperation", ob.getRefOperation());
			jarr.put(svr);
		}
		return jarr;
	}
	
	public JSONArray toJSONArray2() throws SerializationException {
		Iterator<MetaServiceRights> itEntry = this.iterator();
		JSONObject svr = null;   
		JSONArray jarr = new JSONArray();
		MetaServiceRights entry = null;
		while (itEntry.hasNext()) {
			entry = itEntry.next();
			svr = new JSONObject();
			svr.put("key", entry.getKey());
			svr.put("caption", entry.getCaption());
			svr.put("refOperation", entry.getRefOperation());
			jarr.put(svr);
		}
		return jarr;
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if(MetaServiceRights.TAG_NAME.equals(tagName)){
			MetaServiceRights service = new MetaServiceRights();
			service.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(service);
			resultMetaObject = service;
		} else {
			throw new MetaException(MetaException.NO_ACTION_DEFINED,
					"No MetaObject defined for " + tagName);
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaServiceRightsCollection();
	}

}
