package com.bokesoft.yigo.meta.common;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaParameterCollection;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaQuery extends KeyPairMetaObject implements IPropertyMerger<MetaQuery>{
	/** 查询的标识 */
	private String key = "";
	/** 查询的描述 */
	private String description = "";
	/** 查询的参数 */
	private String args = "";
	/** 不同数据库查询语句的集合 */
	private MetaStatementCollection statements = null;	
	/** 查询的参数集合*/
	private MetaParameterCollection parameters = null;
	
	public MetaQuery() {
		super();
	}
	
	@Override
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置查询标识
	 * @param key 查询标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 设置查询描述
	 * @param description 描述
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * 取得查询描述
	 * @return 描述
	 */
	public String getDescription() {
		return this.description;
	}
	
	/**
	 * 设置查询参数集
	 * @param args 参数集
	 */
	public void setArgs(String args) {
		this.args = args;
	}
	
	/**
	 * 取得查询参数集
	 * @return 参数集
	 */
	public String getArgs() {
		return this.args;
	}

	/**
	 * 取得查询声明集
	 * @return 查询声明的集合
	 */
	public MetaStatementCollection getStatements() {
		return statements;
	}

	/**
	 * 设置查询声明集
	 * @param statements 查询语句集合
	 */
	public void setStatements(MetaStatementCollection statements) {
		this.statements = statements;
	}

	/**
	 * 取得查询参数集合
	 * @return 查询参数集合
	 */
	public MetaParameterCollection getParameters() {
		return parameters;
	}

	/**
	 * 设置查询参数集合
	 * @param parameters 查询参数集合
	 */
	public void setParameters(MetaParameterCollection parameters) {
		this.parameters = parameters;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { statements, parameters });
	}

	public static final String TAG_NAME = "Query";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaStatement.TAG_NAME)) {
			if(this.statements == null) {
				this.statements = new MetaStatementCollection();
			}
			resultMetaObject = this.statements.createChildMetaObject(env, doc, node, tagName, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaParameterCollection.TAG_NAME)) {
			parameters = new MetaParameterCollection();
			resultMetaObject = parameters;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaQuery newObject = (MetaQuery)newInstance();
		newObject.setKey(key);
		newObject.setDescription(description);
		newObject.setArgs(args);
		newObject.setStatements(statements == null ? null : (MetaStatementCollection) statements.clone());
		newObject.setParameters(parameters == null ? null : (MetaParameterCollection) parameters.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaQuery();
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
		if( parameters != null ) {
			this.parameters.doPostProcess(flag, callback);
		}
	}
	
	@Override
	public boolean needCheckExtend() {
		return true;
	}

	@Override
	public void merge(MetaQuery query) {
		if( this.description == null ) {
			this.description = query.getDescription();
		}
		if( this.args == null ) {
			this.args = query.getArgs();
		}
		if( this.statements == null ) {
			MetaStatementCollection sc = query.getStatements();
			if( sc != null ) {
				this.statements = (MetaStatementCollection) sc.depthClone();
			}
		}
		if( this.parameters == null ) {
			MetaParameterCollection pc = query.getParameters();
			if( parameters != null ) {
				this.parameters = (MetaParameterCollection) pc.depthClone();
			}
		}
	}
}
