package com.bokesoft.yigo.meta.common;

import com.bokesoft.yigo.common.def.KeyHandlerType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;

public class MetaKeyHandler extends MetaBaseScript {
	/** 事件标识*/
	private String key = "";
	/** 事件描述*/
	private String description = "";
	/** 事件类型*/
	private Integer type = -1;
	
	public static final String TAG_NAME = "KeyHandler";
	
	public MetaKeyHandler() {
		super(TAG_NAME);
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
		this.type = KeyHandlerType.parse(key);
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}
	
	@Override
	public Integer getType() {
		return type;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaKeyHandler();
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaKeyHandler newObject = (MetaKeyHandler)super.clone();
		newObject.setKey(key);
		newObject.setDescription(description);
		return newObject;
	}

}
