package com.bokesoft.yigo.meta.calendar;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaWorkingCalendar extends
		GenericNoKeyCollectionWithKey<MetaVacation> {

	public static final String TAG = "WorkingCalendar";

	/** 工作日历的Key */
	private String key = "";

	/***/
	private String cluster = "";
	/**
	 * 每周的非工作日。(1 = Sunday, 2 = Monday, 3 = Tuesday, 4 = Wednesday, 5 =
	 * Thursday, 6 = Friday, 7 = Saturday)。 一个星期的第一天是星期天，国际惯例。
	 */
	private String weekend = "";

	/** 工作时间，形式为：HH:MM-HH:MM。（时间采用24小时计时法表示） */
	private String officeHour = "00:00-23:59";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		MetaVacation amo = null;
		if (tagName.equalsIgnoreCase(MetaVacation.TAG)) {
			amo = new MetaVacation();
			amo.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(amo);
		}
		return amo;

	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaWorkingCalendar();
	}

	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public String getKey() {
		return key;
	}

	public String getWeekend() {
		return weekend;
	}

	public void setWeekend(String weekend) {
		this.weekend = weekend;
	}

	public String getOfficeHour() {
		return officeHour;
	}

	public void setOfficeHour(String officeHour) {
		this.officeHour = officeHour;
	}

	public void setCluster(String cluster) {
		this.cluster = cluster;
	}
	
	public String getCluster() {
		return cluster;
	}
}
