package com.bokesoft.yigo.meta.bpm.process.perm.extend;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaProcessPerm extends AbstractMetaObject {

	public static final String TAG_NAME = "ProcessPerm";
	
	private String processKey = "";
	private Integer version = -1;
	
	private MetaGlobalPermCollection globalPermCollection = null;
	private MetaNodePermCollection nodePermCollection = null;
	private MetaInitiatorPermCollection initiatorPermCollection = null;
	
	public String getProcessKey() {
		return processKey;
	}
	
	public void setProcessKey(String processKey) {
		this.processKey = processKey;
	}
	
	public void setVersion(Integer version) {
		this.version = version;
	}
	
	public Integer getVersion() {
		return version;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] {globalPermCollection, nodePermCollection, initiatorPermCollection});

	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaGlobalPermCollection.TAG_NAME)) {
			resultMetaObject = new MetaGlobalPermCollection();
			globalPermCollection = (MetaGlobalPermCollection)resultMetaObject;
		} else if (tagName.equalsIgnoreCase(MetaNodePermCollection.TAG_NAME)) {
			resultMetaObject = new MetaNodePermCollection();
			nodePermCollection = (MetaNodePermCollection)resultMetaObject;
		} else if (tagName.equalsIgnoreCase(MetaInitiatorPermCollection.TAG_NAME)) {
			resultMetaObject = new MetaInitiatorPermCollection();
			initiatorPermCollection = (MetaInitiatorPermCollection)resultMetaObject;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaProcessPerm meta = new MetaProcessPerm();
		meta.setProcessKey(processKey);
		meta.setVersion(version);
		meta.setGlobalPermCollection(globalPermCollection == null ? null : (MetaGlobalPermCollection)globalPermCollection.clone());
		meta.setNodePermCollection(nodePermCollection == null ? null : (MetaNodePermCollection)nodePermCollection.clone());
		meta.setInitiatorPermCollection(initiatorPermCollection == null ? null : (MetaInitiatorPermCollection)initiatorPermCollection.clone());
		return meta;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaProcessPerm();
	}
	
	public void setGlobalPermCollection(MetaGlobalPermCollection globalPermCollection) {
		this.globalPermCollection = globalPermCollection;
	}
	
	public MetaGlobalPermCollection getGlobalPermCollection() {
		return globalPermCollection;
	}
	
	public void setNodePermCollection(MetaNodePermCollection nodePermCollection) {
		this.nodePermCollection = nodePermCollection;
	}
	
	public MetaNodePermCollection getNodePermCollection() {
		return nodePermCollection;
	}
	
	public void setInitiatorPermCollection(MetaInitiatorPermCollection initiatorPermCollection) {
		this.initiatorPermCollection = initiatorPermCollection;
	}
	
	public MetaInitiatorPermCollection getInitiatorPermCollection() {
		return initiatorPermCollection;
	}

}
