package com.bokesoft.yigo.meta.bpm.process.perm;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaSourceParaCollection;

public class MetaPermExternalLink extends KeyPairMetaObject {

	public static final String TAG_NAME = "PermExternalLink";
	
	private String key = "";
	
	private MetaSourceParaCollection metaSourceParaCollection = null;
	
	public void setSourceParaCollection(MetaSourceParaCollection metaSourceParaCollection) {
		this.metaSourceParaCollection = metaSourceParaCollection;
	}
	
	public MetaSourceParaCollection getSourceParaCollection() {
		return metaSourceParaCollection;
	}
	
	public void setKey(String key) {
		this.key = key;
	}
	
	@Override
	public String getKey() {
		return key;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaSourceParaCollection.TAG_NAME)) {
			metaSourceParaCollection = new MetaSourceParaCollection();
			resultMetaObject = metaSourceParaCollection;
			resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return resultMetaObject;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { metaSourceParaCollection });
		
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaPermExternalLink meta = (MetaPermExternalLink)newInstance();
		meta.setKey(key);
		meta.setSourceParaCollection(metaSourceParaCollection == null ? null : (MetaSourceParaCollection)metaSourceParaCollection.clone());
		return meta;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaPermExternalLink();
	}
	
	@Override
	public JSONObject toJSON() throws SerializationException {
		JSONObject obj = new JSONObject();
		obj.put("tag-name", getTagName());
		obj.put("key", key);
		if(metaSourceParaCollection != null){
			obj.put("sourceparas", metaSourceParaCollection.toJSON());
		}
		return obj;
	}
	
	@Override
	public void fromJSON(JSONObject json) throws SerializationException {
		key = json.optString("key");
		if(json.has("sourceparas")){
			metaSourceParaCollection = new MetaSourceParaCollection();
			metaSourceParaCollection.fromJSON(json.getJSONObject("sourceparas"));
		}
	}
}
