package com.bokesoft.yigo.meta.bpm.process.node;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;

public class MetaMultiAudit extends MetaAudit {

	/** 节点的标签 */
	public final static String TAG_NAME = "MultiAudit";
	
	/** 是否顺序执行 */
	private Boolean inOrder = true;

	/**
	 * 获取是否顺序执行
	 * 
	 * @return 是否顺序执行标志
	 */
	public Boolean isInOrder() {
		return inOrder;
	}

	/**
	 * 设置是否顺序执行
	 * 
	 * @param inOrder 是否顺序执行的布尔值标志
	 */
	public void setInOrder(Boolean inOrder) {
		this.inOrder = inOrder;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaMultiAudit newObj = (MetaMultiAudit) super.clone();
		newObj.setInOrder(inOrder);
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaMultiAudit();
	}

	@Override
	public int getNodeType() {
		return NodeType.MULTI_AUDIT;
	}
}
